/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.FieldLockInfo;
import gov.nasa.jpf.jvm.FieldLockInfoFactory;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class StatisticFieldLockInfoFactory
implements FieldLockInfoFactory {
    static Logger log = JPF.getLogger("gov.nasa.jpf.jvm.FieldLockInfo");
    static int CHECK_THRESHOLD = 5;
    static boolean PINDOWN = false;
    static boolean AGRESSIVE = false;

    public StatisticFieldLockInfoFactory(Config conf) {
        CHECK_THRESHOLD = conf.getInt("vm.por.sync_detection.threshold", CHECK_THRESHOLD);
        PINDOWN = conf.getBoolean("vm.por.sync_detection.pindown", PINDOWN);
        AGRESSIVE = conf.getBoolean("vm.por.sync_detection.agressive", AGRESSIVE);
    }

    @Override
    public FieldLockInfo createFieldLockInfo(ThreadInfo ti, ElementInfo ei, FieldInfo fi) {
        ElementInfo eiLockCandidate;
        LinkedList<ElementInfo> currentLocks = ti.getLockedObjects();
        int n = currentLocks.size();
        if (n == 0) {
            return FieldLockInfo.empty;
        }
        if (AGRESSIVE && (eiLockCandidate = this.strongProtectionCandidate(ei, fi, currentLocks)) != null) {
            return new SingleLockFli(ti, eiLockCandidate.getIndex(), CHECK_THRESHOLD);
        }
        if (n == 1) {
            return new SingleLockFli(ti, ((ElementInfo)currentLocks.get(0)).getIndex(), 0);
        }
        return new MultiLockFli(ti, fi, currentLocks);
    }

    ElementInfo strongProtectionCandidate(ElementInfo ei, FieldInfo fi, List<ElementInfo> currentLocks) {
        int n = currentLocks.size();
        if (fi.isStatic()) {
            ClassInfo ci = fi.getClassInfo();
            int cref = ci.getClassObjectRef();
            for (int i = 0; i < n; ++i) {
                ElementInfo e = currentLocks.get(i);
                if (e.getIndex() != cref) continue;
                log.info("sync-detection: " + ei + " assumed to be synced on class object: " + e);
                return e;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ElementInfo e = currentLocks.get(i);
                int eidx = e.getIndex();
                if (ei == e) {
                    log.info("sync-detection: " + ei + " assumed to be synced on itself");
                    return e;
                }
                if (e.hasRefField(ei.getIndex())) {
                    log.info("sync-detection: " + ei + " assumed to be synced on object wrapper: " + e);
                    return e;
                }
                if (!ei.hasRefField(eidx)) continue;
                log.info("sync-detection: " + ei + " assumed to be synced on sibling: " + e);
                return e;
            }
        }
        return null;
    }

    static class MultiLockFli
    extends StatisticFieldLockInfo {
        int[] lockRefSet;

        public MultiLockFli(ThreadInfo ti, FieldInfo fi, List<ElementInfo> currentLocks) {
            int n = currentLocks.size();
            this.lockRefSet = new int[n];
            for (int i = 0; i < n; ++i) {
                this.lockRefSet[i] = currentLocks.get(i).getIndex();
            }
        }

        @Override
        protected int[] getCandidateLockSet() {
            return this.lockRefSet;
        }

        @Override
        public FieldLockInfo checkProtection(ThreadInfo ti, ElementInfo ei, FieldInfo fi) {
            LinkedList<ElementInfo> currentLocks = ti.getLockedObjects();
            int nLocks = currentLocks.size();
            ++this.checkLevel;
            if (nLocks == 0) {
                this.checkFailedLockAssumption(ti, ei, fi);
                return empty;
            }
            int l = 0;
            int[] newLset = new int[this.lockRefSet.length];
            block0: for (int i = 0; i < nLocks; ++i) {
                ElementInfo lei = (ElementInfo)currentLocks.get(i);
                int leidx = lei.getIndex();
                for (int j = 0; j < this.lockRefSet.length; ++j) {
                    if (this.lockRefSet[j] != leidx) continue;
                    newLset[l++] = leidx;
                    continue block0;
                }
            }
            if (l == 0) {
                this.checkFailedLockAssumption(ti, ei, fi);
                return empty;
            }
            if (l == 1) {
                return new SingleLockFli(ti, newLset[0], this.checkLevel);
            }
            if (l < newLset.length) {
                this.lockRefSet = new int[l];
                System.arraycopy(newLset, 0, this.lockRefSet, 0, l);
            }
            this.tiLastCheck = ti;
            return this;
        }

        @Override
        public FieldLockInfo cleanUp() {
            DynamicArea area = DynamicArea.getHeap();
            int[] newSet = null;
            int l = 0;
            if (this.lockRefSet != null) {
                for (int i = 0; i < this.lockRefSet.length; ++i) {
                    if (area.get(this.lockRefSet[i]) == null) {
                        if (newSet != null) continue;
                        newSet = new int[this.lockRefSet.length - 1];
                        if (i <= 0) continue;
                        System.arraycopy(this.lockRefSet, 0, newSet, 0, i);
                        l = i;
                        continue;
                    }
                    if (newSet == null) continue;
                    newSet[l++] = this.lockRefSet[i];
                }
            }
            if (l == 1) {
                assert (newSet != null);
                return new SingleLockFli(this.tiLastCheck, (int)newSet[0], this.checkLevel);
            }
            if (newSet != null) {
                if (l == newSet.length) {
                    this.lockRefSet = newSet;
                } else {
                    if (l == 0) {
                        return empty;
                    }
                    this.lockRefSet = new int[l];
                    System.arraycopy(newSet, 0, this.lockRefSet, 0, l);
                }
            }
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MultiLockFli {");
            sb.append("checkLevel=");
            sb.append(this.checkLevel);
            sb.append(",lset=[");
            if (this.lockRefSet != null) {
                for (int i = 0; i < this.lockRefSet.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.lockRefSet[i]);
                }
            }
            sb.append("]}");
            return sb.toString();
        }
    }

    static class SingleLockFli
    extends StatisticFieldLockInfo {
        int lockRef;

        SingleLockFli(ThreadInfo ti, int lockRef, int nChecks) {
            this.tiLastCheck = ti;
            this.lockRef = lockRef;
            this.checkLevel = nChecks;
        }

        @Override
        protected int[] getCandidateLockSet() {
            int[] set = new int[]{this.lockRef};
            return set;
        }

        @Override
        public FieldLockInfo checkProtection(ThreadInfo ti, ElementInfo ei, FieldInfo fi) {
            LinkedList<ElementInfo> currentLocks = ti.getLockedObjects();
            int n = currentLocks.size();
            ++this.checkLevel;
            for (int i = 0; i < n; ++i) {
                ElementInfo lei = (ElementInfo)currentLocks.get(i);
                if (lei.getIndex() != this.lockRef) continue;
                return this;
            }
            this.checkFailedLockAssumption(ti, ei, fi);
            return empty;
        }

        @Override
        public FieldLockInfo cleanUp() {
            DynamicArea area = DynamicArea.getHeap();
            if (area.get(this.lockRef) == null) {
                return FieldLockInfo.empty;
            }
            return this;
        }

        public String toString() {
            return "SingleLockFli {checkLevel=" + this.checkLevel + ",lock=" + this.lockRef + '}';
        }
    }

    static abstract class StatisticFieldLockInfo
    extends FieldLockInfo {
        int checkLevel;

        StatisticFieldLockInfo() {
        }

        @Override
        public boolean isProtected() {
            return this.checkLevel >= CHECK_THRESHOLD;
        }

        @Override
        public boolean needsPindown(ElementInfo ei) {
            return PINDOWN && this.checkLevel >= CHECK_THRESHOLD;
        }

        protected void checkFailedLockAssumption(ThreadInfo ti, ElementInfo ei, FieldInfo fi) {
            if (this.checkLevel >= CHECK_THRESHOLD) {
                this.lockAssumptionFailed(ti, ei, fi);
            }
        }
    }
}

