/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.Area;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.Monitor;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.util.Debug;
import gov.nasa.jpf.util.IntTable;

public class StaticArea
extends Area<StaticElementInfo> {
    static StaticArea staticArea;
    private IntTable<String> staticMap = new IntTable();

    public static void init(Config config) {
    }

    public static StaticArea getStaticArea() {
        return staticArea;
    }

    public StaticArea(Config config, KernelState ks) {
        super(ks);
        staticArea = this;
    }

    public boolean containsClass(String cname) {
        return this.indexOf(cname) != -1;
    }

    public StaticElementInfo get(String cname) {
        int index = this.indexOf(cname);
        if (index == -1) {
            return null;
        }
        return (StaticElementInfo)this.get(index);
    }

    @Override
    public void resetVolatiles() {
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementInfo ei = (ElementInfo)this.elements.get(i);
            if (ei == null) continue;
            ClassInfo ci = ei.getClassInfo();
            ci.setStaticElementInfo(null);
        }
    }

    @Override
    public void restoreVolatiles() {
        for (int i = 0; i < this.elements.size(); ++i) {
            StaticElementInfo sei = (StaticElementInfo)this.elements.get(i);
            if (sei == null) continue;
            ClassInfo ci = sei.getClassInfo();
            ci.setStaticElementInfo(sei);
        }
    }

    public int indexOf(String cname) {
        IntTable.Entry<String> e = this.staticMap.get(cname);
        if (e != null && this.elements.get(e.val) != null) {
            return e.val;
        }
        return -1;
    }

    public void log() {
        Debug.println(2, "SA");
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementInfo ei = (ElementInfo)this.elements.get(i);
            if (ei == null) continue;
            ei.log();
        }
    }

    public void markRoots() {
        int length = this.elements.size();
        for (int i = 0; i < length; ++i) {
            StaticElementInfo ei = (StaticElementInfo)this.elements.get(i);
            if (ei == null) continue;
            ei.markStaticRoot();
        }
    }

    public int addClass(ClassInfo ci, ThreadInfo ti) {
        int index = this.indexOf(ci.getName());
        if (index == -1) {
            index = this.indexFor(ci.getName());
            int cref = ci.createClassObject(ti, index);
            StaticElementInfo ei = this.createElementInfo(ci, cref);
            this.add(index, ei);
        }
        return index;
    }

    @Override
    StaticElementInfo createElementInfo() {
        return new StaticElementInfo();
    }

    StaticElementInfo createElementInfo(ClassInfo ci, int classObjRef) {
        Fields f = ci.createStaticFields();
        Monitor m = new Monitor();
        StaticElementInfo ei = new StaticElementInfo(f, m, classObjRef);
        ci.setStaticElementInfo(ei);
        ci.initializeStaticData(ei);
        return ei;
    }

    public int addStartupClass(ClassInfo ci) {
        StaticElementInfo ei = this.createElementInfo(ci, -1);
        int index = this.indexFor(ci.getName());
        this.add(index, ei);
        return index;
    }

    int indexFor(String cname) {
        return this.staticMap.poolIndex(cname);
    }
}

