/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.util.HashData;
import java.io.PrintStream;
import org.apache.bcel.Constants;

public class StackFrame
implements Constants,
Cloneable {
    protected int top;
    protected int thisRef = -1;
    protected int[] operands;
    protected boolean[] isOperandRef;
    protected Object[] operandAttr;
    protected Object[] localAttr;
    protected int[] locals;
    protected boolean[] isLocalRef;
    protected Instruction pc;
    protected MethodInfo mi;

    public boolean hasReferenceOperand(int n, int objRef) {
        int[] op = this.operands;
        boolean[] ref = this.isOperandRef;
        int i = 0;
        for (int j = this.top - n + 1; i < n && j >= 0; ++i, ++j) {
            if (!ref[j] || op[j] != objRef) continue;
            return true;
        }
        return false;
    }

    public StackFrame(MethodInfo m, StackFrame caller) {
        this.mi = m;
        this.pc = this.mi.getInstruction(0);
        int nOperands = this.mi.getMaxStack();
        this.operands = new int[nOperands];
        this.isOperandRef = new boolean[nOperands];
        this.top = -1;
        int nargs = this.mi.getArgumentsSize();
        int nlocals = this.pc == null ? nargs : this.mi.getMaxLocals();
        this.locals = new int[nlocals];
        this.isLocalRef = new boolean[nlocals];
        if (nargs > 0 && caller != null) {
            int[] a = caller.operands;
            boolean[] r = caller.isOperandRef;
            int i = 0;
            int j = caller.top - nargs + 1;
            while (i < nargs) {
                this.locals[i] = a[j];
                this.isLocalRef[i] = r[j];
                ++i;
                ++j;
            }
            if (!this.mi.isStatic()) {
                this.thisRef = this.locals[0];
            }
            if (caller.operandAttr != null) {
                this.operandAttr = new Object[this.operands.length];
                this.localAttr = new Object[this.locals.length];
                Object[] oa = caller.operandAttr;
                int i2 = 0;
                int j2 = caller.top - nargs + 1;
                while (i2 < nargs) {
                    this.localAttr[i2] = oa[j2];
                    ++i2;
                    ++j2;
                }
            }
        }
    }

    public StackFrame(MethodInfo m, int objRef) {
        this(m, null);
        this.locals[0] = this.thisRef = objRef;
        this.isLocalRef[0] = true;
    }

    protected StackFrame() {
    }

    public int getCalleeThis(MethodInfo mi) {
        return this.getCalleeThis(mi.getArgumentsSize());
    }

    public int getCalleeThis(int size) {
        int i = size - 1;
        if (this.top < i) {
            return -1;
        }
        return this.operands[this.top - i];
    }

    public Object getLocalOrFieldValue(String id) {
        String[] localNames = this.mi.getLocalVariableNames();
        for (int i = 0; i < localNames.length; ++i) {
            if (!localNames[i].equals(id)) continue;
            return this.getLocalValueObject(i);
        }
        return this.getFieldValue(id);
    }

    Object getLocalValueObject(int i) {
        String[] localTypes = this.mi.getLocalVariableTypes();
        if (localTypes != null) {
            String type = localTypes[i];
            if ("boolean".equals(type)) {
                return this.locals[i] != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("byte".equals(type)) {
                return new Byte((byte)this.locals[i]);
            }
            if ("char".equals(type)) {
                return new Character((char)this.locals[i]);
            }
            if ("short".equals(type)) {
                return new Short((short)this.locals[i]);
            }
            if ("int".equals(type)) {
                return new Integer(this.locals[i]);
            }
            if ("float".equals(type)) {
                return new Float(Float.intBitsToFloat(this.locals[i]));
            }
            if ("long".equals(type)) {
                return new Long(Types.intsToLong(this.locals[i], this.locals[i + 1]));
            }
            if ("double".equals(type)) {
                return new Double(Double.longBitsToDouble(Types.intsToLong(this.locals[i], this.locals[i + 1])));
            }
            if (this.locals[i] != -1) {
                return DynamicArea.getHeap().get(this.locals[i]);
            }
        }
        return null;
    }

    public Object getFieldValue(String id) {
        Object ei;
        Object v;
        if (this.thisRef != -1 && (v = ((ElementInfo)(ei = DynamicArea.getHeap().get(this.thisRef))).getFieldValueObject(id)) != null) {
            return v;
        }
        return this.mi.getClassInfo().getStaticFieldValueObject(id);
    }

    public ClassInfo getClassInfo() {
        return this.mi.getClassInfo();
    }

    public String getClassName() {
        return this.mi.getClassInfo().getName();
    }

    public String getSourceFile() {
        return this.mi.getClassInfo().getSourceFileName();
    }

    public boolean isDirectCallFrame() {
        return false;
    }

    public int getLine() {
        return this.mi.getLineNumber(this.pc);
    }

    public void setOperandAttr(Object attr) {
        this.setOperandAttr(0, attr);
    }

    public void setOperandAttr(int offset, Object attr) {
        if (this.operandAttr == null && attr != null) {
            this.operandAttr = new Object[this.operands.length];
            this.localAttr = new Object[this.locals.length];
        }
        if (this.operandAttr != null) {
            this.operandAttr[this.top - offset] = attr;
        }
    }

    public void setLongOperandAttr(Object attr) {
        this.setOperandAttr(1, attr);
    }

    public void setLocalAttr(int index, Object attr) {
        if (index < this.locals.length) {
            if (this.localAttr == null && attr != null) {
                this.operandAttr = new Object[this.operands.length];
                this.localAttr = new Object[this.locals.length];
            }
            if (this.localAttr != null) {
                this.localAttr[index] = attr;
            }
        }
    }

    public Object[] getArgumentAttrs(MethodInfo miCallee) {
        if (this.operandAttr != null) {
            Object[] attrs;
            int nArgs = miCallee.getNumberOfArguments();
            byte[] at = miCallee.getArgumentTypes();
            if (!miCallee.isStatic()) {
                attrs = new Object[nArgs + 1];
                attrs[0] = this.getOperandAttr(miCallee.getArgumentsSize() - 1);
            } else {
                attrs = new Object[nArgs];
            }
            int i = nArgs - 1;
            int off = 0;
            int j = attrs.length - 1;
            while (i >= 0) {
                byte argType = at[i];
                if (argType == 11 || argType == 7) {
                    attrs[j] = this.getOperandAttr(off + 1);
                    off += 2;
                } else {
                    attrs[j] = this.getOperandAttr(off);
                    ++off;
                }
                --i;
                --j;
            }
            return attrs;
        }
        return null;
    }

    public int getAbsOperand(int idx) {
        return this.operands[idx];
    }

    public boolean isAbsOperandRef(int idx) {
        return this.isOperandRef[idx];
    }

    public Object getLongOperandAttr() {
        return this.getOperandAttr(1);
    }

    public boolean hasOperandAttrs() {
        return this.operandAttr != null;
    }

    public boolean hasLocalAtts() {
        return this.localAttr != null;
    }

    public Object getOperandAttr() {
        if (this.top >= 0 && this.operandAttr != null) {
            return this.operandAttr[this.top];
        }
        return null;
    }

    public Object getOperandAttr(int offset) {
        if (this.top >= offset && this.operandAttr != null) {
            return this.operandAttr[this.top - offset];
        }
        return null;
    }

    public void setOperand(int offset, int v, boolean ref) {
        int i = this.top - offset;
        this.operands[i] = v;
        this.isOperandRef[i] = ref;
    }

    public Object getLocalAttr(int index) {
        if (index < this.locals.length && this.localAttr != null) {
            return this.localAttr[index];
        }
        return null;
    }

    public void setLocalVariable(int index, int v, boolean ref) {
        boolean activateGc = this.isLocalRef[index] && this.locals[index] != -1;
        this.locals[index] = v;
        this.isLocalRef[index] = ref;
        if (ref && v != -1) {
            activateGc = true;
        }
        if (activateGc) {
            JVM.getVM().getSystemState().activateGC();
        }
    }

    public int getLocalVariable(int i) {
        return this.locals[i];
    }

    public int getLocalVariable(String name) {
        int idx = this.getLocalVariableOffset(name);
        if (idx >= 0) {
            return this.getLocalVariable(idx);
        }
        throw new JPFException("local variable not found: " + name);
    }

    public int getLocalVariableCount() {
        return this.locals.length;
    }

    public String[] getLocalVariableNames() {
        return this.mi.getLocalVariableNames();
    }

    public boolean isLocalVariableRef(int idx) {
        return this.isLocalRef[idx];
    }

    public String getLocalVariableType(String name) {
        String[] lNames = this.mi.getLocalVariableNames();
        String[] lTypes = this.mi.getLocalVariableTypes();
        if (lNames != null && lTypes != null) {
            int l = lNames.length;
            for (int i = 0; i < l; ++i) {
                if (!name.equals(lNames[i])) continue;
                return lTypes[i];
            }
        }
        return null;
    }

    int[] getLocalVariables() {
        return this.locals;
    }

    public void setLongLocalVariable(int index, long v) {
        this.locals[index] = Types.hiLong(v);
        this.isLocalRef[index] = false;
        this.locals[++index] = Types.loLong(v);
        this.isLocalRef[index] = false;
    }

    public long getLongLocalVariable(int i) {
        return Types.intsToLong(this.locals[i + 1], this.locals[i]);
    }

    public long getLongLocalVariable(String name) {
        int idx = this.getLocalVariableOffset(name);
        if (idx >= 0) {
            return this.getLongLocalVariable(idx);
        }
        throw new JPFException("long local variable not found: " + name);
    }

    public MethodInfo getMethodInfo() {
        return this.mi;
    }

    public String getMethodName() {
        return this.mi.getName();
    }

    public boolean isOperandRef(int idx) {
        return this.isOperandRef[this.top - idx];
    }

    public boolean isOperandRef() {
        return this.isOperandRef[this.top];
    }

    public void setPC(Instruction newpc) {
        this.pc = newpc;
    }

    public Instruction getPC() {
        return this.pc;
    }

    public void advancePC() {
        int i = this.pc.getOffset() + 1;
        this.pc = i < this.mi.getNumberOfInstructions() ? this.mi.getInstruction(i) : null;
    }

    public int getTopPos() {
        return this.top;
    }

    public String getStackTraceInfo() {
        StringBuilder sb = new StringBuilder(128);
        ClassInfo ciMi = this.mi.getClassInfo();
        if (ciMi != null) {
            sb.append(this.mi.getClassInfo().getName());
            sb.append('.');
        }
        sb.append(this.mi.getName());
        if (this.pc != null) {
            if (ciMi != null) {
                sb.append('(');
                sb.append(this.pc.getFilePos());
                sb.append(')');
            } else {
                sb.append("(Synthetic)");
            }
        } else {
            sb.append("(Native Method)");
        }
        return sb.toString();
    }

    public int getThis() {
        return this.thisRef;
    }

    public void clearOperandStack() {
        this.top = -1;
    }

    public StackFrame clone() {
        try {
            StackFrame sf = (StackFrame)super.clone();
            sf.operands = (int[])this.operands.clone();
            sf.isOperandRef = (boolean[])this.isOperandRef.clone();
            if (this.operandAttr != null) {
                sf.operandAttr = (Object[])this.operandAttr.clone();
            }
            sf.locals = (int[])this.locals.clone();
            sf.isLocalRef = (boolean[])this.isLocalRef.clone();
            if (this.localAttr != null) {
                sf.localAttr = (Object[])this.localAttr.clone();
            }
            return sf;
        }
        catch (CloneNotSupportedException cnsx) {
            throw new JPFException(cnsx);
        }
    }

    public void dup() {
        int t = this.top++;
        this.operands[this.top] = this.operands[t];
        this.isOperandRef[this.top] = this.isOperandRef[t];
        if (this.operandAttr != null) {
            this.operandAttr[this.top] = this.operandAttr[t];
        }
    }

    public void dup2() {
        int td = this.top + 1;
        int ts = this.top - 1;
        this.operands[td] = this.operands[ts];
        this.isOperandRef[td] = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = this.operandAttr[ts];
        }
        this.operands[++td] = this.operands[++ts];
        this.isOperandRef[td] = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = this.operandAttr[ts];
        }
        this.top = td;
    }

    public void dup2_x1() {
        boolean cRef;
        int c;
        boolean bRef;
        int b;
        Object bAnn = null;
        Object cAnn = null;
        int ts = this.top - 1;
        int td = this.top + 1;
        this.operands[td] = b = this.operands[ts];
        this.isOperandRef[td] = bRef = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = bAnn = this.operandAttr[ts];
        }
        ts = this.top;
        this.operands[++td] = c = this.operands[ts];
        this.isOperandRef[td] = cRef = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = cAnn = this.operandAttr[ts];
        }
        ts = this.top - 2;
        td = this.top;
        this.operands[td] = this.operands[ts];
        this.isOperandRef[td] = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = this.operandAttr[ts];
        }
        td = ts;
        this.operands[td] = b;
        this.isOperandRef[td] = bRef;
        if (this.operandAttr != null) {
            this.operandAttr[td] = bAnn;
        }
        this.operands[++td] = c;
        this.isOperandRef[td] = cRef;
        if (this.operandAttr != null) {
            this.operandAttr[td] = cAnn;
        }
        this.top += 2;
    }

    public void dup2_x2() {
        boolean dRef;
        int d;
        boolean cRef;
        int c;
        Object cAnn = null;
        Object dAnn = null;
        int ts = this.top - 1;
        int td = this.top + 1;
        this.operands[td] = c = this.operands[ts];
        this.isOperandRef[td] = cRef = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = cAnn = this.operandAttr[ts];
        }
        ts = this.top;
        this.operands[++td] = d = this.operands[ts];
        this.isOperandRef[td] = dRef = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = dAnn = this.operandAttr[ts];
        }
        ts = this.top - 3;
        td = this.top - 1;
        this.operands[td] = this.operands[ts];
        this.isOperandRef[td] = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = this.operandAttr[ts];
        }
        td = this.top;
        this.operands[td] = this.operands[++ts];
        this.isOperandRef[td] = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = this.operandAttr[ts];
        }
        td = ts;
        this.operands[td] = c;
        this.isOperandRef[td] = cRef;
        if (this.operandAttr != null) {
            this.operandAttr[td] = cAnn;
        }
        this.operands[++td] = d;
        this.isOperandRef[td] = dRef;
        if (this.operandAttr != null) {
            this.operandAttr[td] = dAnn;
        }
        this.top += 2;
    }

    public void dup_x1() {
        boolean bRef;
        int b;
        Object bAnn = null;
        int ts = this.top;
        int td = this.top + 1;
        this.operands[td] = b = this.operands[ts];
        this.isOperandRef[td] = bRef = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = bAnn = this.operandAttr[ts];
        }
        ts = this.top - 1;
        td = this.top;
        this.operands[td] = this.operands[ts];
        this.isOperandRef[td] = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = this.operandAttr[ts];
        }
        td = ts;
        this.operands[td] = b;
        this.isOperandRef[td] = bRef;
        if (this.operandAttr != null) {
            this.operandAttr[td] = bAnn;
        }
        ++this.top;
    }

    public void dup_x2() {
        boolean cRef;
        int c;
        Object cAnn = null;
        int ts = this.top;
        int td = this.top + 1;
        this.operands[td] = c = this.operands[ts];
        this.isOperandRef[td] = cRef = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = cAnn = this.operandAttr[ts];
        }
        ts = this.top - 1;
        td = this.top;
        this.operands[td] = this.operands[ts];
        this.isOperandRef[td] = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = this.operandAttr[ts];
        }
        td = ts--;
        this.operands[td] = this.operands[ts];
        this.isOperandRef[td] = this.isOperandRef[ts];
        if (this.operandAttr != null) {
            this.operandAttr[td] = this.operandAttr[ts];
        }
        td = ts;
        this.operands[td] = c;
        this.isOperandRef[td] = cRef;
        if (this.operandAttr != null) {
            this.operandAttr[td] = cAnn;
        }
        ++this.top;
    }

    public boolean equals(Object object) {
        StackFrame sf = (StackFrame)object;
        if (this.pc != sf.pc) {
            return false;
        }
        if (this.mi != sf.mi) {
            return false;
        }
        int[] l = sf.locals;
        boolean[] lr = sf.isLocalRef;
        int nlocals = this.locals.length;
        if (nlocals != l.length) {
            return false;
        }
        for (int idx = 0; idx < nlocals; ++idx) {
            if (this.locals[idx] == l[idx] && this.isLocalRef[idx] == lr[idx]) continue;
            return false;
        }
        int[] o = sf.operands;
        boolean[] or = sf.isOperandRef;
        if (this.top != sf.top) {
            return false;
        }
        for (int idx = 0; idx <= this.top; ++idx) {
            if (this.operands[idx] == o[idx] && this.isOperandRef[idx] == or[idx]) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnyRef() {
        int i;
        for (i = 0; i <= this.top; ++i) {
            if (!this.isOperandRef[i]) continue;
            return true;
        }
        int l = this.locals.length;
        for (i = 0; i < l; ++i) {
            if (!this.isLocalRef[i]) continue;
            return true;
        }
        return false;
    }

    public void hash(HashData hd) {
        int i;
        int[] v = this.locals;
        int l = v.length;
        for (i = 0; i < l; ++i) {
            hd.add(v[i]);
        }
        Object[] attrs = this.localAttr;
        if (attrs != null) {
            l = attrs.length;
            for (i = 0; i < l; ++i) {
                hd.add(attrs[i]);
            }
        }
        v = this.operands;
        for (i = 0; i <= this.top; ++i) {
            hd.add(v[i]);
        }
        attrs = this.operandAttr;
        if (attrs != null) {
            l = attrs.length;
            for (i = 0; i < l; ++i) {
                hd.add(attrs[i]);
            }
        }
    }

    public int hashCode() {
        HashData hd = new HashData();
        this.hash(hd);
        return hd.getValue();
    }

    public void markThreadRoots(int tid) {
        int i;
        DynamicArea heap = DynamicArea.getHeap();
        for (i = 0; i <= this.top; ++i) {
            if (!this.isOperandRef[i]) continue;
            heap.markThreadRoot(this.operands[i], tid);
        }
        int l = this.locals.length;
        for (i = 0; i < l; ++i) {
            if (!this.isLocalRef[i]) continue;
            heap.markThreadRoot(this.locals[i], tid);
        }
    }

    public void printStackContent() {
        int i;
        PrintStream pw = System.err;
        pw.print("\tat ");
        pw.print(this.mi.getCompleteName());
        if (this.pc != null) {
            pw.println(":" + this.pc.getPosition());
        } else {
            pw.println();
        }
        pw.println("\t  Operand stack is:");
        for (i = 0; i <= this.top; ++i) {
            pw.print("\t    ");
            if (this.isOperandRef[i]) {
                pw.print("#");
            }
            pw.println(this.operands[i]);
        }
        pw.println("\t  Local variables are:");
        int l = this.locals.length;
        for (i = 0; i < l; ++i) {
            pw.print("\t    ");
            if (this.isLocalRef[i]) {
                pw.print("#");
            }
            pw.println("" + this.locals[i]);
        }
    }

    public void printStackTrace() {
        System.err.println(this.getStackTraceInfo());
    }

    public void swap() {
        int t = this.top - 1;
        int v = this.operands[this.top];
        boolean isRef = this.isOperandRef[this.top];
        this.operands[this.top] = this.operands[t];
        this.isOperandRef[this.top] = this.isOperandRef[t];
        this.operands[t] = v;
        this.isOperandRef[t] = isRef;
        if (this.operandAttr != null) {
            Object attr = this.operandAttr[this.top];
            this.operandAttr[this.top] = this.operandAttr[t];
            this.operandAttr[t] = attr;
        }
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("StackFrame[");
        sb.append(this.mi.getUniqueName());
        sb.append(",top=");
        sb.append(this.top);
        sb.append(",operands=[");
        for (i = 0; i <= this.top; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.operands[i]);
            if (this.operandAttr == null || this.operandAttr[i] == null) continue;
            sb.append('(');
            sb.append(this.operandAttr[i]);
            sb.append(')');
        }
        sb.append("],locals=[");
        for (i = 0; i < this.locals.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.locals[i]);
            if (this.localAttr == null || this.localAttr[i] == null) continue;
            sb.append('(');
            sb.append(this.localAttr[i]);
            sb.append(')');
        }
        sb.append("],pc=");
        sb.append(this.pc.getPosition());
        sb.append(",oRefs=");
        for (i = 0; i <= this.top; ++i) {
            sb.append(this.isOperandRef[i] ? (char)'R' : '-');
        }
        sb.append(",lRefs=");
        for (i = 0; i < this.locals.length; ++i) {
            sb.append(this.isLocalRef[i] ? (char)'R' : '-');
        }
        sb.append(']');
        return sb.toString();
    }

    public long longPeek() {
        return Types.intsToLong(this.operands[this.top], this.operands[this.top - 1]);
    }

    public long longPeek(int n) {
        int i = this.top - n;
        return Types.intsToLong(this.operands[i], this.operands[i - 1]);
    }

    public void longPush(long v) {
        this.push(Types.hiLong(v));
        this.push(Types.loLong(v));
    }

    public void doublePush(double v) {
        this.push(Types.hiDouble(v));
        this.push(Types.loDouble(v));
    }

    public double doublePop() {
        int i = this.top;
        int lo = this.operands[i--];
        int hi = this.operands[i--];
        if (this.operandAttr != null) {
            i = this.top;
            this.operandAttr[i--] = null;
            this.operandAttr[i--] = null;
        }
        this.top = i;
        return Types.intsToDouble(lo, hi);
    }

    public long longPop() {
        int i = this.top;
        int lo = this.operands[i--];
        int hi = this.operands[i--];
        if (this.operandAttr != null) {
            i = this.top;
            this.operandAttr[i--] = null;
            this.operandAttr[i--] = null;
        }
        this.top = i;
        return Types.intsToLong(lo, hi);
    }

    public int peek() {
        return this.operands[this.top];
    }

    public int peek(int offset) {
        return this.operands[this.top - offset];
    }

    public void pop(int n) {
        int i;
        int t = this.top - n;
        for (i = this.top; i > t; --i) {
            if (!this.isOperandRef[i] || this.operands[i] == -1) continue;
            JVM.getVM().getSystemState().activateGC();
            break;
        }
        if (this.operandAttr != null) {
            for (i = this.top; i > t; --i) {
                this.operandAttr[i] = null;
            }
        }
        this.top = t;
    }

    public int pop() {
        int v = this.operands[this.top];
        if (this.isOperandRef[this.top] && v != -1) {
            JVM.getVM().getSystemState().activateGC();
        }
        if (this.operandAttr != null) {
            this.operandAttr[this.top] = null;
        }
        --this.top;
        return v;
    }

    public void pushLocal(int index) {
        ++this.top;
        this.operands[this.top] = this.locals[index];
        this.isOperandRef[this.top] = this.isLocalRef[index];
        if (this.localAttr != null) {
            this.operandAttr[this.top] = this.localAttr[index];
        }
    }

    public void pushLongLocal(int index) {
        int t = this.top;
        this.operands[++t] = this.locals[index];
        this.isOperandRef[t] = false;
        this.operands[++t] = this.locals[index + 1];
        this.isOperandRef[t] = false;
        if (this.operandAttr != null) {
            this.operandAttr[t - 1] = this.localAttr[index];
            this.operandAttr[t] = null;
        }
        this.top = t;
    }

    public void storeOperand(int index) {
        this.locals[index] = this.operands[this.top];
        this.isLocalRef[index] = this.isOperandRef[this.top];
        if (this.localAttr != null) {
            this.localAttr[index] = this.operandAttr[this.top];
            this.operandAttr[this.top] = null;
        }
        --this.top;
    }

    public void storeLongOperand(int index) {
        int t = this.top - 1;
        int i = index;
        this.locals[i] = this.operands[t];
        this.isLocalRef[i] = false;
        this.locals[++i] = this.operands[t + 1];
        this.isLocalRef[i] = false;
        if (this.localAttr != null) {
            this.localAttr[index] = this.operandAttr[t];
            this.localAttr[i] = null;
            this.operandAttr[t] = null;
            this.operandAttr[t + 1] = null;
        }
        this.top -= 2;
    }

    public void push(int v) {
        ++this.top;
        this.operands[this.top] = v;
        this.isOperandRef[this.top] = false;
    }

    public void pushRef(int ref) {
        ++this.top;
        this.operands[this.top] = ref;
        this.isOperandRef[this.top] = true;
        if (ref != -1) {
            JVM.getVM().getSystemState().activateGC();
        }
    }

    public void push(int v, boolean ref) {
        ++this.top;
        this.operands[this.top] = v;
        this.isOperandRef[this.top] = ref;
        if (ref && v != -1) {
            JVM.getVM().getSystemState().activateGC();
        }
    }

    public int getLocalVariableOffset(String name) {
        String[] lNames = this.mi.getLocalVariableNames();
        String[] lTypes = this.mi.getLocalVariableTypes();
        int offset = 0;
        int i = 0;
        int l = lNames.length;
        while (i < l) {
            if (name.equals(lNames[i])) {
                return offset;
            }
            if (lTypes[i].charAt(0) == '?') continue;
            int typeSize = Types.getTypeSize(lTypes[i]);
            offset += typeSize;
            i += typeSize;
        }
        return -1;
    }
}

