/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ObjRef;
import gov.nasa.jpf.jvm.StaticElementInfo;

public abstract class Ref {
    public static final ObjRef NULL = new ObjRef(-1);
    int reference;
    boolean isClass;

    protected Ref(int r, boolean c) {
        this.reference = r;
        this.isClass = c;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isNull() {
        return this.reference == -1;
    }

    public int getReference() {
        return this.reference;
    }

    public abstract Object clone();

    public boolean equals(Object o) {
        return this.reference == ((Ref)o).reference && this.isClass == ((Ref)o).isClass;
    }

    public int hashCode() {
        return this.reference;
    }

    public String toString() {
        if (this.isClass) {
            return ((StaticElementInfo)JVM.getVM().getStaticArea().get(this.reference)).toString();
        }
        return ((DynamicElementInfo)DynamicArea.getHeap().get(this.reference)).toString();
    }
}

