/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativePeer {
    static final String MODEL_PACKAGE = "<model>";
    static final String DEFAULT_PACKAGE = "<default>";
    static Logger logger = JPF.getLogger("gov.nasa.jpf.jvm.NativePeer");
    static ClassLoader loader;
    static HashMap<String, NativePeer> peers;
    static final int MAX = 6;
    static Object[][] argCache;
    static Config config;
    static String[] peerPackages;
    ClassInfo ci;
    Class<?> peerClass;
    HashMap<String, Method> methods;
    static StackFrame lastCaller;

    public static void init(Config conf) throws Config.Exception {
        loader = conf.getCurrentClassLoader();
        peers = new HashMap();
        argCache = new Object[6][];
        for (int i = 0; i < 6; ++i) {
            NativePeer.argCache[i] = new Object[i];
        }
        peerPackages = NativePeer.getPeerPackages(conf);
        config = conf;
    }

    static String[] getPeerPackages(Config conf) {
        String[] defPeerPackages = new String[]{MODEL_PACKAGE, "gov.nasa.jpf.jvm.", DEFAULT_PACKAGE};
        String[] packages = conf.getStringArray("vm.peer.packages", defPeerPackages);
        for (int i = 0; i < packages.length; ++i) {
            if (packages[i].equals(MODEL_PACKAGE)) {
                packages[i] = MODEL_PACKAGE;
                continue;
            }
            if (!packages[i].equals(DEFAULT_PACKAGE)) continue;
            packages[i] = DEFAULT_PACKAGE;
        }
        return packages;
    }

    NativePeer() {
    }

    NativePeer(Class<?> peerClass, ClassInfo ci) {
        this.initialize(peerClass, ci, true);
    }

    static Class<?> locatePeerCls(String clsName) {
        String cn = "JPF_" + clsName.replace('.', '_');
        for (int i = 0; i < peerPackages.length; ++i) {
            String pcn;
            String pkg = peerPackages[i];
            if (pkg == MODEL_PACKAGE) {
                int j = clsName.lastIndexOf(46);
                pcn = clsName.substring(0, j + 1) + cn;
            } else {
                pcn = pkg == DEFAULT_PACKAGE ? cn : pkg + '.' + cn;
            }
            try {
                Class<?> peerCls = loader.loadClass(pcn);
                if ((peerCls.getModifiers() & 1) != 0) {
                    return peerCls;
                }
                logger.warning("non-public peer class: " + peerCls.getName());
                continue;
            }
            catch (ClassNotFoundException cnfx) {
                // empty catch block
            }
        }
        return null;
    }

    static NativePeer getNativePeer(ClassInfo ci) {
        String clsName = ci.getName();
        NativePeer peer = peers.get(clsName);
        Class<?> peerCls = null;
        if (peer == null && (peerCls = NativePeer.locatePeerCls(clsName)) != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("load peer: " + peerCls.getName());
            }
            peer = new NativePeer(peerCls, ci);
            peers.put(clsName, peer);
        }
        return peer;
    }

    static String getPeerDispatcherClassName(String clsName) {
        return clsName + '$';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Instruction executeMethod(ThreadInfo ti, MethodInfo mi) {
        Object ret = null;
        Object[] args = null;
        MJIEnv env = ti.getMJIEnv();
        ElementInfo ei = null;
        env.setCallEnvironment(mi);
        Method mth = this.getMethod(mi);
        if (mth == null) {
            return ti.createAndThrowException("java.lang.UnsatisfiedLinkError", "cannot find native " + this.ci.getName() + '.' + mi.getName());
        }
        try {
            args = this.getArguments(env, ti, mi, mth);
            if (mi.isSynchronized()) {
                ei = env.getElementInfo((Integer)args[1]);
                ei.lock(ti);
                if (mi.isClinit()) {
                    this.ci.setInitializing(ti);
                }
            }
            ret = mth.invoke(this.peerClass, args);
            String exception = env.getException();
            if (exception != null) {
                String details = env.getExceptionDetails();
                Instruction instruction = ti.createAndThrowException(exception, details);
                return instruction;
            }
            if (env.getRepeat()) {
                Instruction details = ti.getPC();
                return details;
            }
            ti.removeArguments(mi);
            this.releaseArgArray(args);
            if (ret != null) {
                this.pushReturnValue(ti, mi, ret, env.getReturnAttribute());
            }
        }
        catch (IllegalArgumentException iax) {
            logger.warning(iax.toString());
            Instruction instruction = ti.createAndThrowException("java.lang.IllegalArgumentException", "calling " + this.ci.getName() + '.' + mi.getName());
            return instruction;
        }
        catch (IllegalAccessException ilax) {
            logger.warning(ilax.toString());
            Instruction instruction = ti.createAndThrowException("java.lang.IllegalAccessException", "calling " + this.ci.getName() + '.' + mi.getName());
            return instruction;
        }
        catch (InvocationTargetException itx) {
            Instruction instruction = ti.createAndThrowException("java.lang.reflect.InvocationTargetException", "in " + this.ci.getName() + '.' + mi.getName() + " : " + itx.getCause());
            return instruction;
        }
        finally {
            if (mi.isSynchronized() && ei != null && ei.isLocked()) {
                ei.unlock(ti);
                if (mi.isClinit()) {
                    this.ci.setInitialized();
                }
            }
            env.clearCallEnvironment();
        }
        Instruction pc = ti.getPC();
        return pc.getNext();
    }

    void initialize(Class<?> peerClass, ClassInfo ci, boolean cacheMethods) {
        if (this.ci != null || this.peerClass != null) {
            throw new RuntimeException("cannot re-initialize NativePeer: " + peerClass.getName());
        }
        this.ci = ci;
        this.peerClass = peerClass;
        this.loadMethods(cacheMethods);
        this.initializePeerClass();
    }

    void initializePeerClass() {
        try {
            Method m = this.peerClass.getDeclaredMethod("init", Config.class);
            try {
                m.invoke(null, config);
            }
            catch (IllegalArgumentException iax) {
            }
            catch (IllegalAccessException iacx) {
                throw new RuntimeException("peer initialization method not accessible: " + this.peerClass.getName());
            }
            catch (InvocationTargetException itx) {
                throw new RuntimeException("initialization of peer " + this.peerClass.getName() + " failed: " + itx.getCause());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static boolean isMJICandidate(Method mth) {
        if ((mth.getModifiers() & 9) != 9) {
            return false;
        }
        Class<?>[] argTypes = mth.getParameterTypes();
        return argTypes.length >= 2 && argTypes[0] == MJIEnv.class && argTypes[1] == Integer.TYPE;
    }

    private Object[] getArgArray(int n) {
        Object[] a;
        if (n < 6) {
            a = argCache[n];
            if (a != null) {
                NativePeer.argCache[n] = null;
            } else {
                a = new Object[n];
            }
        } else {
            a = new Object[n];
        }
        return a;
    }

    private void releaseArgArray(Object[] a) {
        int n = a.length;
        if (n < 6 && argCache[n] == null) {
            NativePeer.argCache[n] = a;
        }
    }

    public static StackFrame getLastCaller() {
        return lastCaller;
    }

    private Object[] getArguments(MJIEnv env, ThreadInfo ti, MethodInfo mi, Method mth) {
        int nArgs = mi.getNumberOfArguments();
        Object[] a = this.getArgArray(nArgs + 2);
        byte[] argTypes = mi.getArgumentTypes();
        StackFrame caller = ti.getTopFrame();
        lastCaller = caller.clone();
        int i = 0;
        int stackOffset = 0;
        int j = nArgs + 1;
        int k = nArgs - 1;
        while (i < nArgs) {
            switch (argTypes[k]) {
                case 4: {
                    int ival = caller.peek(stackOffset);
                    a[j] = Types.intToBoolean(ival);
                    break;
                }
                case 8: {
                    int ival = caller.peek(stackOffset);
                    a[j] = (byte)ival;
                    break;
                }
                case 5: {
                    int ival = caller.peek(stackOffset);
                    a[j] = Character.valueOf((char)ival);
                    break;
                }
                case 9: {
                    int ival = caller.peek(stackOffset);
                    a[j] = new Short((short)ival);
                    break;
                }
                case 10: {
                    int ival = caller.peek(stackOffset);
                    a[j] = new Integer(ival);
                    break;
                }
                case 11: {
                    long lval = caller.longPeek(stackOffset);
                    ++stackOffset;
                    a[j] = new Long(lval);
                    break;
                }
                case 6: {
                    int ival = caller.peek(stackOffset);
                    a[j] = new Float(Types.intToFloat(ival));
                    break;
                }
                case 7: {
                    long lval = caller.longPeek(stackOffset);
                    ++stackOffset;
                    a[j] = new Double(Types.longToDouble(lval));
                    break;
                }
                default: {
                    int ival = caller.peek(stackOffset);
                    a[j] = new Integer(ival);
                }
            }
            ++stackOffset;
            ++i;
            --j;
            --k;
        }
        a[1] = mi.isStatic() ? new Integer(this.ci.getClassObjectRef()) : new Integer(ti.getCalleeThis(mi));
        a[0] = env;
        return a;
    }

    private Method getMethod(MethodInfo mi) {
        return this.getMethod(null, mi);
    }

    private Method getMethod(String prefix, MethodInfo mi) {
        String name = mi.getUniqueName();
        if (prefix != null) {
            name = prefix + name;
        }
        return this.methods.get(name);
    }

    private void loadMethods(boolean cacheMethods) {
        Method[] m = this.peerClass.getDeclaredMethods();
        this.methods = new HashMap(m.length);
        Map<String, MethodInfo> methodInfos = this.ci.getDeclaredMethods();
        MethodInfo[] mis = null;
        for (int i = 0; i < m.length; ++i) {
            MethodInfo mi;
            Method mth = m[i];
            if (!NativePeer.isMJICandidate(mth)) continue;
            String mn = mth.getName();
            if (mn.startsWith("$clinit")) {
                mn = "<clinit>";
            } else if (mn.startsWith("$init")) {
                mn = "<init>" + mn.substring(5);
            }
            String mname = Types.getJNIMethodName(mn);
            String sig = Types.getJNISignature(mn);
            if (sig != null) {
                mname = mname + sig;
            }
            if ((mi = methodInfos.get(mname)) == null && sig == null) {
                if (mis == null) {
                    mis = new MethodInfo[methodInfos.size()];
                    methodInfos.values().toArray(mis);
                }
                mi = NativePeer.searchMethod(mname, mis);
            }
            if (mi != null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("load MJI method: " + mname);
                }
                mi.setMJI(true);
                if (!cacheMethods) continue;
                this.methods.put(mi.getUniqueName(), mth);
                continue;
            }
            logger.warning("orphant NativePeer method: " + this.ci.getName() + '.' + mname);
        }
    }

    private static MethodInfo searchMethod(String mname, MethodInfo[] methods) {
        int idx = -1;
        for (int j = 0; j < methods.length; ++j) {
            if (!methods[j].getName().equals(mname)) continue;
            if (idx == -1) {
                idx = j;
                continue;
            }
            throw new JPFException("overloaded native method without signature: " + mname);
        }
        if (idx >= 0) {
            return methods[idx];
        }
        return null;
    }

    private void pushReturnValue(ThreadInfo ti, MethodInfo mi, Object ret, Object retAttr) {
        int retSize = 1;
        if (ret != null) {
            switch (mi.getReturnType()) {
                case 4: {
                    int ival = Types.booleanToInt((Boolean)ret);
                    ti.push(ival, false);
                    break;
                }
                case 8: {
                    ti.push(((Byte)ret).byteValue(), false);
                    break;
                }
                case 5: {
                    ti.push(((Character)ret).charValue(), false);
                    break;
                }
                case 9: {
                    ti.push(((Short)ret).shortValue(), false);
                    break;
                }
                case 10: {
                    ti.push((Integer)ret, false);
                    break;
                }
                case 11: {
                    ti.longPush((Long)ret);
                    retSize = 2;
                    break;
                }
                case 6: {
                    int ival = Types.floatToInt(((Float)ret).floatValue());
                    ti.push(ival, false);
                    break;
                }
                case 7: {
                    long lval = Types.doubleToLong((Double)ret);
                    ti.longPush(lval);
                    retSize = 2;
                    break;
                }
                default: {
                    ti.push((Integer)ret, true);
                }
            }
            if (retAttr != null) {
                StackFrame frame = ti.getTopFrame();
                if (retSize == 1) {
                    frame.setOperandAttr(retAttr);
                } else {
                    frame.setLongOperandAttr(retAttr);
                }
            }
        }
    }
}

