/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.util.HashData;
import java.io.PrintWriter;
import java.util.Arrays;

public class Monitor {
    static ThreadInfo[] emptySet = new ThreadInfo[0];
    private ThreadInfo lockingThread;
    private int lockCount;
    ThreadInfo[] lockedThreads;

    public Monitor() {
        this.lockingThread = null;
        this.lockCount = 0;
        this.lockedThreads = emptySet;
    }

    private Monitor(ThreadInfo locking, int count, ThreadInfo[] locked) {
        this.lockingThread = locking;
        this.lockCount = count;
        this.lockedThreads = (ThreadInfo[])locked.clone();
        Arrays.sort(this.lockedThreads);
    }

    void printFields(PrintWriter pw) {
        pw.print("[");
        if (this.lockingThread != null) {
            pw.print("locked by: ");
            pw.print(this.lockingThread.getName());
        } else {
            pw.print("unlocked");
        }
        pw.print(", lockCount: ");
        pw.print(this.lockCount);
        pw.print(", locked: {");
        for (int i = 0; i < this.lockedThreads.length; ++i) {
            if (i > 0) {
                pw.print(',');
            }
            pw.print(this.lockedThreads[i].getName());
            pw.print(':');
            pw.print(this.lockedThreads[i].getStatusName());
        }
        pw.println("}]");
    }

    @Deprecated
    Monitor cloneWithoutLocked() {
        return new Monitor(this.lockingThread, this.lockCount, emptySet);
    }

    Monitor cloneWithLocked(ThreadInfo ti) {
        return new Monitor(this.lockingThread, this.lockCount, Monitor.add(this.lockedThreads, ti));
    }

    Monitor cloneWithoutLocked(ThreadInfo ti) {
        return new Monitor(this.lockingThread, this.lockCount, Monitor.remove(this.lockedThreads, ti));
    }

    @Deprecated
    Monitor cloneWithLocked(ThreadInfo[] locked) {
        return new Monitor(this.lockingThread, this.lockCount, locked);
    }

    public Monitor clone() {
        return new Monitor(this.lockingThread, this.lockCount, (ThreadInfo[])this.lockedThreads.clone());
    }

    @Deprecated
    void setLocked(ThreadInfo[] locked) {
        this.lockedThreads = (ThreadInfo[])locked.clone();
        Arrays.sort(this.lockedThreads);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Monitor)) {
            return false;
        }
        Monitor m = (Monitor)o;
        if (this.lockingThread != m.getLockingThread()) {
            return false;
        }
        if (this.lockCount != m.getLockCount()) {
            return false;
        }
        ThreadInfo[] list = m.lockedThreads;
        if (this.lockedThreads.length != list.length) {
            return false;
        }
        for (int i = 0; i < this.lockedThreads.length; ++i) {
            if (this.lockedThreads[i] == list[i]) continue;
            return false;
        }
        return true;
    }

    public void hash(HashData hd) {
        if (this.lockingThread != null) {
            hd.add(this.lockingThread.getIndex());
        }
        hd.add(this.lockCount);
        int l = this.lockedThreads.length;
        for (int i = 0; i < l; ++i) {
            hd.add(this.lockedThreads[i].getIndex());
        }
    }

    public int hashCode() {
        HashData hd = new HashData();
        this.hash(hd);
        return hd.getValue();
    }

    public int getLockCount() {
        return this.lockCount;
    }

    public ThreadInfo getLockingThread() {
        return this.lockingThread;
    }

    public ThreadInfo[] getLockedThreads() {
        return this.lockedThreads;
    }

    public boolean hasLockedThreads() {
        return this.lockedThreads.length > 0;
    }

    public boolean canLock(ThreadInfo th) {
        if (this.lockingThread == null) {
            return true;
        }
        return this.lockingThread == th;
    }

    void setLockingThread(ThreadInfo ti) {
        this.lockingThread = ti;
    }

    void incLockCount() {
        ++this.lockCount;
    }

    void decLockCount() {
        assert (this.lockCount > 0) : "negative lockCount";
        --this.lockCount;
    }

    void setLockCount(int lc) {
        assert (lc >= 0) : "attempt to set negative lockCount";
        this.lockCount = lc;
    }

    public int objectHashCode() {
        return super.hashCode();
    }

    void resetLockedThreads() {
        this.lockedThreads = emptySet;
    }

    static ThreadInfo[] add(ThreadInfo[] list, ThreadInfo ti) {
        int pos;
        int len = list.length;
        ThreadInfo[] newList = new ThreadInfo[len + 1];
        for (pos = 0; pos < len && ti.compareTo(list[pos]) > 0; ++pos) {
            newList[pos] = list[pos];
        }
        newList[pos] = ti;
        while (pos < len) {
            newList[pos + 1] = list[pos];
            ++pos;
        }
        return newList;
    }

    void addLocked(ThreadInfo ti) {
        this.lockedThreads = Monitor.add(this.lockedThreads, ti);
    }

    static ThreadInfo[] remove(ThreadInfo[] list, ThreadInfo ti) {
        int len = list.length;
        if (len == 0) {
            return list;
        }
        if (len == 1) {
            if (list[0] == ti) {
                return emptySet;
            }
            return list;
        }
        for (int i = 0; i < len; ++i) {
            if (list[i] != ti) continue;
            int newLen = len - 1;
            ThreadInfo[] newList = new ThreadInfo[newLen];
            if (i > 0) {
                System.arraycopy(list, 0, newList, 0, i);
            }
            if (i < newLen) {
                System.arraycopy(list, i + 1, newList, i, newLen - i);
            }
            return newList;
        }
        return list;
    }

    void removeLocked(ThreadInfo ti) {
        this.lockedThreads = Monitor.remove(this.lockedThreads, ti);
    }
}

