/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.ExceptionHandler;
import gov.nasa.jpf.jvm.InfoObject;
import gov.nasa.jpf.jvm.InstructionFactory;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.NativePeer;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.RETURN;
import gov.nasa.jpf.util.Debug;
import java.util.ArrayList;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;

public class MethodInfo
extends InfoObject
implements Cloneable {
    static final int INIT_MTH_SIZE = 4096;
    private static ArrayList<MethodInfo> mthTable;
    static final String[] EMPTY;
    protected static boolean warnedLocalInfo;
    static final int MJI_NONE = 0;
    static final int MJI_NATIVE = 1;
    static final int EXEC_ATOMIC = 65536;
    static final int EXEC_HIDDEN = 131072;
    static final int FIREWALL = 262144;
    static final int IS_CLINIT = 524288;
    protected String name;
    protected String signature;
    protected ClassInfo ci;
    protected Instruction[] code;
    protected ExceptionHandler[] exceptions;
    protected int[] lineNumbers;
    protected String[] localVariableNames;
    protected String[] localVariableTypes;
    protected int maxLocals;
    protected int maxStack;
    int modifiers;
    int attrs;
    private int argSize = -1;
    private int nArgs = -1;
    private byte returnType = (byte)-1;
    private byte[] argTypes = null;
    private String uniqueName;
    private int globalId = -1;
    static InstructionFactory insnFactory;

    static boolean init(Config config) throws Config.Exception {
        insnFactory = config.getEssentialInstance("vm.insn_factory.class", InstructionFactory.class);
        mthTable = new ArrayList(4096);
        return true;
    }

    protected MethodInfo(Method m, ClassInfo c) {
        this.name = m.getName();
        this.signature = m.getSignature();
        this.ci = c;
        this.code = this.loadCode(m);
        this.exceptions = this.loadExceptions(m);
        this.lineNumbers = this.loadLineNumbers(m);
        this.maxLocals = MethodInfo.getMaxLocals(m);
        this.maxStack = MethodInfo.getMaxStack(m);
        this.localVariableNames = this.loadLocalVariableNames(m);
        this.localVariableTypes = this.loadLocalVariableTypes(m);
        this.modifiers = m.getModifiers();
        if (this.name.equals("<clinit>")) {
            this.modifiers |= 0x20;
            this.attrs |= 0xC0000;
        }
        this.uniqueName = MethodInfo.getUniqueName(this.name, this.signature);
        this.globalId = mthTable.size();
        mthTable.add(this);
        this.loadAnnotations(m.getAnnotationEntries());
    }

    protected MethodInfo() {
        this.globalId = mthTable.size();
        mthTable.add(this);
    }

    public MethodInfo(String name, int maxLocals, int maxStack, int modifiers, Instruction[] code) {
        this.name = name;
        this.uniqueName = name;
        this.signature = "()V";
        this.maxLocals = maxLocals;
        this.maxStack = maxStack;
        this.localVariableNames = EMPTY;
        this.localVariableTypes = EMPTY;
        this.modifiers = modifiers;
        this.lineNumbers = null;
        this.exceptions = null;
        if (code != null) {
            this.setCode(code);
        }
        this.globalId = mthTable.size();
        mthTable.add(this);
    }

    public static MethodInfo getMethodInfo(int globalId) {
        if (globalId >= 0 && globalId < mthTable.size()) {
            return mthTable.get(globalId);
        }
        return null;
    }

    public static InstructionFactory getInstructionFactory() {
        return insnFactory;
    }

    public static void setInstructionFactory(InstructionFactory newFactory) {
        insnFactory = newFactory;
    }

    public void setClassInfo(ClassInfo ci) {
        this.ci = ci;
    }

    public void setCode(Instruction[] code) {
        for (int i = 0; i < code.length; ++i) {
            code[i].setMethodInfo(this);
        }
        this.code = code;
    }

    public static int getNumberOfLoadedMethods() {
        return mthTable.size();
    }

    void setAtomic(boolean isAtomic) {
        this.attrs = isAtomic ? (this.attrs |= 0x10000) : (this.attrs &= 0xFFFEFFFF);
    }

    public boolean isAtomic() {
        return (this.attrs & 0x10000) != 0;
    }

    void setHidden(boolean isHidden) {
        this.attrs = isHidden ? (this.attrs |= 0x20000) : (this.attrs &= 0xFFFDFFFF);
    }

    public boolean isHidden() {
        return (this.attrs & 0x20000) != 0;
    }

    void setFirewall(boolean isFirewalled) {
        this.attrs = isFirewalled ? (this.attrs |= 0x40000) : (this.attrs &= 0xFFFBFFFF);
    }

    public boolean isFirewall() {
        return (this.attrs & 0x40000) != 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnx) {
            return null;
        }
    }

    public int getGlobalId() {
        return this.globalId;
    }

    boolean isReflectionCallStub() {
        return this.name.startsWith("[reflection]");
    }

    public MethodInfo createReflectionCallStub() {
        return this.createDirectCallStub("[reflection]");
    }

    public boolean isDirectCallStub() {
        return this.ci == null;
    }

    public MethodInfo createDirectCallStub(String originator) {
        Instruction insn;
        MethodInfo mi = new MethodInfo();
        String cname = this.ci.getName();
        mi.name = originator + this.name;
        mi.signature = "()V";
        mi.maxLocals = this.isStatic() ? 0 : 1;
        mi.maxStack = this.getNumberOfCallerStackSlots();
        mi.localVariableNames = EMPTY;
        mi.localVariableTypes = EMPTY;
        mi.lineNumbers = null;
        mi.exceptions = null;
        mi.uniqueName = mi.name;
        mi.code = new Instruction[2];
        if (this.isStatic()) {
            mi.modifiers |= 8;
            insn = this.isClinit() ? insnFactory.create(null, "INVOKECLINIT") : insnFactory.create(null, "INVOKESTATIC");
        } else {
            insn = this.name.equals("<init>") ? insnFactory.create(null, "INVOKESPECIAL") : insnFactory.create(null, "INVOKEVIRTUAL");
        }
        ((InvokeInstruction)insn).initialize(mi, cname, this.name, this.signature, 0, 0);
        mi.code[0] = insn;
        insn = insnFactory.create(null, "RETURN");
        ((RETURN)insn).initialize(mi, 1, 4);
        mi.code[1] = insn;
        return mi;
    }

    public boolean isSyncRelevant() {
        return this.name.charAt(0) != '<';
    }

    public boolean isClinit() {
        return (this.attrs & 0x80000) != 0;
    }

    public boolean isClinit(ClassInfo ci) {
        return (this.attrs & 0x80000) != 0 && this.ci == ci;
    }

    public String getLongName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('(');
        String[] argTypeNames = this.getArgumentTypeNames();
        for (int i = 0; i < argTypeNames.length; ++i) {
            String a = argTypeNames[i];
            int idx = a.lastIndexOf(46);
            if (idx > 0) {
                a = a.substring(idx + 1);
            }
            if (i > 0) {
                sb.append(',');
            }
            sb.append(a);
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getUniqueName(String mname, String signature) {
        return mname + signature;
    }

    public byte[] getArgumentTypes() {
        if (this.argTypes == null) {
            this.argTypes = Types.getArgumentTypes(this.signature);
            this.nArgs = this.argTypes.length;
        }
        return this.argTypes;
    }

    public String[] getArgumentTypeNames() {
        return Types.getArgumentTypeNames(this.signature);
    }

    public int getArgumentsSize() {
        if (this.argSize < 0) {
            this.argSize = Types.getArgumentsSize(this.signature);
            if (!this.isStatic()) {
                ++this.argSize;
            }
        }
        return this.argSize;
    }

    public String getReturnTypeName() {
        return Types.getReturnTypeName(this.signature);
    }

    public String getSourceFileName() {
        if (this.ci != null) {
            return this.ci.getSourceFileName();
        }
        return "[VM]";
    }

    public String getClassName() {
        if (this.ci != null) {
            return this.ci.getName();
        }
        return "[VM]";
    }

    @Override
    public ClassInfo getClassInfo() {
        return this.ci;
    }

    public String getCompleteName() {
        return this.getClassName() + '.' + this.name + this.signature;
    }

    public String getBaseName() {
        return this.getClassName() + '.' + this.name;
    }

    public boolean isExecutable(ThreadInfo ti) {
        return this.canEnter(ti);
    }

    public boolean isCtor() {
        return this.name.equals("<init>");
    }

    public boolean isInternalMethod() {
        return this.name.equals("<clinit>") || this.uniqueName.equals("finalize()V");
    }

    public boolean isThreadEntry(ThreadInfo ti) {
        return this.uniqueName.equals("run()V") && ti.countStackFrames() == 1;
    }

    public String getFullName() {
        if (this.ci != null) {
            return this.ci.getName() + '.' + this.getUniqueName();
        }
        return this.name + this.signature;
    }

    public int getNumberOfInstructions() {
        return this.code.length;
    }

    public Instruction getInstruction(int i) {
        if (this.code == null) {
            return null;
        }
        if (i < 0 || i >= this.code.length) {
            return null;
        }
        return this.code[i];
    }

    public Instruction getInstructionAt(int position) {
        if (this.code == null) {
            return null;
        }
        int l = this.code.length;
        for (int i = 0; i < l; ++i) {
            if (this.code[i] == null || this.code[i].getPosition() != position) continue;
            return this.code[i];
        }
        throw new JPFException("instruction not found");
    }

    public Instruction[] getInstructions() {
        return this.code;
    }

    public int getLineNumber(Instruction pc) {
        if (this.lineNumbers == null) {
            if (pc == null) {
                return -1;
            }
            return pc.getPosition();
        }
        int idx = pc.getOffset();
        if (idx < 0) {
            idx = 0;
        }
        return this.lineNumbers[idx];
    }

    public int[] getLineNumbers() {
        return this.lineNumbers;
    }

    public boolean isMJI() {
        return (this.attrs & 1) != 0;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public static int getMaxLocals(Method m) {
        Code c = m.getCode();
        if (c == null) {
            return 0;
        }
        return c.getMaxLocals();
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public static int getMaxStack(Method m) {
        Code c = m.getCode();
        if (c == null) {
            return 0;
        }
        return c.getMaxStack();
    }

    public ExceptionHandler[] getExceptions() {
        return this.exceptions;
    }

    public String[] getLocalVariableNames() {
        return this.localVariableNames;
    }

    public String[] getLocalVariableTypes() {
        return this.localVariableTypes;
    }

    public MethodInfo getOverriddenMethodInfo() {
        ClassInfo sci;
        MethodInfo smi = null;
        if (this.ci != null && (sci = this.ci.getSuperClass()) != null) {
            smi = sci.getMethod(this.getUniqueName(), true);
        }
        return smi;
    }

    public String getName() {
        return this.name;
    }

    public String getJNIName() {
        return Types.getJNIMangledMethodName(null, this.name, this.signature);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public int getNumberOfArguments() {
        if (this.nArgs < 0) {
            this.nArgs = Types.getNumberOfArguments(this.signature);
        }
        return this.nArgs;
    }

    public int getNumberOfStackArguments() {
        int n = this.getNumberOfArguments();
        return this.isStatic() ? n : n + 1;
    }

    public int getNumberOfCallerStackSlots() {
        return Types.getNumberOfStackSlots(this.signature, this.isStatic());
    }

    public boolean isReferenceReturnType() {
        byte r = this.getReturnType();
        return r == 14 || r == 13;
    }

    public byte getReturnType() {
        if (this.returnType < 0) {
            this.returnType = Types.getReturnType(this.signature);
        }
        return this.returnType;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public boolean canEnter(ThreadInfo th) {
        if (this.isSynchronized()) {
            ElementInfo ei = this.getBlockedObject(th, true);
            return ei.canLock(th);
        }
        return true;
    }

    public ElementInfo getBlockedObject(ThreadInfo th, boolean isBeforeCall) {
        ElementInfo ei = null;
        if (this.isSynchronized()) {
            int objref = this.isStatic() ? this.ci.getClassObjectRef() : (isBeforeCall ? th.getCalleeThis(this) : th.getThis());
            DynamicArea da = JVM.getVM().getDynamicArea();
            ei = (ElementInfo)da.get(objref);
            assert (ei != null) : "inconsistent stack, no object or class ref: " + this.getCompleteName() + " (" + objref + ")";
        }
        return ei;
    }

    public void enter(ThreadInfo ti) {
        if (this.isSynchronized()) {
            ElementInfo ei = this.getBlockedObject(ti, false);
            ei.lock(ti);
            if (this.isStatic() && this.isClinit()) {
                this.ci.setInitializing(ti);
            }
        }
    }

    public void leave(ThreadInfo ti) {
        if (this.isSynchronized()) {
            ElementInfo ei = this.getBlockedObject(ti, false);
            ei.unlock(ti);
            if (this.isStatic() && this.isClinit()) {
                this.ci.setInitialized();
            }
        }
    }

    public Instruction execute(ThreadInfo ti) {
        if ((this.attrs & 1) != 0 || this.isNative()) {
            NativePeer nativePeer = this.ci.getNativePeer();
            if (nativePeer != null) {
                return nativePeer.executeMethod(ti, this);
            }
            return ti.createAndThrowException("java.lang.UnsatisfiedLinkError", this.ci.getName() + '.' + this.getUniqueName() + " (no peer)");
        }
        ti.pushFrame(new StackFrame(this, ti.getTopFrame()));
        this.enter(ti);
        return ti.getPC();
    }

    protected Instruction[] loadCode(Method m) {
        Code c = m.getCode();
        if (c == null) {
            return null;
        }
        InstructionList il = new InstructionList(c.getCode());
        InstructionHandle[] hs = il.getInstructionHandles();
        int length = hs.length;
        Instruction[] is = new Instruction[length];
        for (int i = 0; i < length; ++i) {
            is[i] = insnFactory.create(hs[i], i, this, m.getConstantPool());
            if (c.getLineNumberTable() == null) continue;
            is[i].setContext(this.ci.getName(), this.name, c.getLineNumberTable().getSourceLine(is[i].getPosition()), is[i].getPosition());
        }
        return is;
    }

    protected ExceptionHandler[] loadExceptions(Method m) {
        Code c = m.getCode();
        if (c == null) {
            return null;
        }
        CodeException[] ce = c.getExceptionTable();
        if (ce.length == 0) {
            return null;
        }
        int length = ce.length;
        ExceptionHandler[] eh = new ExceptionHandler[length];
        ConstantPool cp = m.getConstantPool();
        for (int i = 0; i < length; ++i) {
            int ct = ce[i].getCatchType();
            eh[i] = new ExceptionHandler(ct == 0 ? null : cp.getConstantString(ct, (byte)7).replace('/', '.'), ce[i].getStartPC(), ce[i].getEndPC(), ce[i].getHandlerPC());
        }
        return eh;
    }

    protected int[] loadLineNumbers(Method m) {
        Code c = m.getCode();
        if (c == null) {
            return null;
        }
        LineNumberTable lnt = c.getLineNumberTable();
        int length = this.code.length;
        int[] ln = new int[length];
        if (lnt == null) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            try {
                ln[i] = lnt.getSourceLine(this.code[i].getPosition());
                continue;
            }
            catch (RuntimeException e) {
                System.out.print("^");
            }
        }
        return ln;
    }

    protected String[] loadLocalVariableNames(Method m) {
        int i;
        Code c = m.getCode();
        if (c == null) {
            return null;
        }
        LocalVariableTable lvt = c.getLocalVariableTable();
        if (lvt == null) {
            if (!warnedLocalInfo && !this.ci.isSystemClass()) {
                Debug.println(1);
                Debug.println(1, "No local variable information available");
                Debug.println(1, "for " + this.getCompleteName());
                Debug.println(1, "Recompile with -g to include this information");
                Debug.println(1);
                warnedLocalInfo = true;
            }
            return null;
        }
        LocalVariable[] lv = lvt.getLocalVariableTable();
        int length = lv.length;
        String[] v = new String[c.getMaxLocals()];
        for (i = 0; i < length; ++i) {
            v[lv[i].getIndex()] = lv[i].getName();
        }
        for (i = 0; i < v.length; ++i) {
            if (v[i] != null) continue;
            v[i] = "?";
        }
        return v;
    }

    protected String[] loadLocalVariableTypes(Method m) {
        int i;
        Code c = m.getCode();
        if (c == null) {
            return null;
        }
        LocalVariableTable lvt = c.getLocalVariableTable();
        if (lvt == null) {
            if (!warnedLocalInfo && !this.ci.isSystemClass()) {
                Debug.println(1, "No local variable information available");
                Debug.println(1, "for " + this.getCompleteName());
                Debug.println(1, "Recompile with -g to include this information");
                Debug.println(1);
                warnedLocalInfo = true;
            }
            return null;
        }
        LocalVariable[] lv = lvt.getLocalVariableTable();
        int length = lv.length;
        String[] v = new String[c.getMaxLocals()];
        for (i = 0; i < length; ++i) {
            v[lv[i].getIndex()] = lv[i].getSignature();
        }
        for (i = 0; i < v.length; ++i) {
            if (v[i] != null) continue;
            v[i] = "?";
        }
        return v;
    }

    void setMJI(boolean isMJI) {
        this.attrs = isMJI ? (this.attrs |= 1) : (this.attrs &= 0xFFFFFFFE);
    }

    public String toString() {
        return "MethodInfo[" + this.getFullName() + ']';
    }

    static {
        EMPTY = new String[0];
        warnedLocalInfo = false;
    }
}

