/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.JPFListener;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ClinitRequired;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;

public class MJIEnv {
    public static final int NULL = -1;
    JVM vm;
    ClassInfo ci;
    MethodInfo mi;
    ThreadInfo ti;
    DynamicArea da;
    StaticArea sa;
    boolean repeat;
    Object returnAttr;
    String exception;
    String exceptionDetails;

    MJIEnv(ThreadInfo ti) {
        this.ti = ti;
        this.vm = ti.getVM();
        this.da = this.vm.getDynamicArea();
        this.sa = this.vm.getStaticArea();
    }

    public JVM getVM() {
        return this.vm;
    }

    public JPF getJPF() {
        return this.vm.getJPF();
    }

    public void addListener(JPFListener l) {
        this.vm.getJPF().addListener(l);
    }

    public void removeListener(JPFListener l) {
        this.vm.getJPF().removeListener(l);
    }

    public Config getConfig() {
        return this.vm.getConfig();
    }

    public void gc() {
        this.da.gc();
    }

    public void ignoreTransition() {
        this.getSystemState().setIgnored(true);
    }

    public boolean isArray(int objref) {
        return ((DynamicElementInfo)this.da.get(objref)).isArray();
    }

    public int getArrayLength(int objref) {
        if (this.isArray(objref)) {
            return ((DynamicElementInfo)this.da.get(objref)).arrayLength();
        }
        this.throwException("java.lang.IllegalArgumentException");
        return 0;
    }

    public String getArrayType(int objref) {
        return ((DynamicElementInfo)this.da.get(objref)).getArrayType();
    }

    public int getArrayTypeSize(int objref) {
        return Types.getTypeSize(this.getArrayType(objref));
    }

    public boolean hasAttrs(int objref) {
        if (objref != -1) {
            Object ei = this.da.get(objref);
            return ((ElementInfo)ei).hasAttrs();
        }
        return false;
    }

    public Object getFieldAttr(int objref, String fname) {
        Object ei = this.da.get(objref);
        FieldInfo fi = ((ElementInfo)ei).getFieldInfo(fname);
        return ((ElementInfo)ei).getFieldAttr(fi);
    }

    public Object getElementAttr(int objref, int idx) {
        Object ei = this.da.get(objref);
        return ((ElementInfo)ei).getElementAttr(idx);
    }

    public void setElementAttr(int objref, int idx, Object a) {
        Object ei = this.da.get(objref);
        ((ElementInfo)ei).setElementAttr(idx, a);
    }

    public void setBooleanField(int objref, String fname, boolean val) {
        this.setIntField(objref, fname, Types.booleanToInt(val));
    }

    public boolean getBooleanField(int objref, String fname) {
        return Types.intToBoolean(this.getIntField(objref, fname));
    }

    public boolean getBooleanArrayElement(int objref, int index) {
        return Types.intToBoolean(((DynamicElementInfo)this.da.get(objref)).getElement(index));
    }

    public void setBooleanArrayElement(int objref, int index, boolean value) {
        ((DynamicElementInfo)this.da.get(objref)).setElement(index, Types.booleanToInt(value));
    }

    public void setByteField(int objref, String fname, byte val) {
        this.setIntField(objref, fname, val);
    }

    public byte getByteField(int objref, String fname) {
        return (byte)this.getIntField(objref, fname);
    }

    public void setCharField(int objref, String fname, char val) {
        this.setIntField(objref, fname, val);
    }

    public char getCharField(int objref, String fname) {
        return (char)this.getIntField(objref, fname);
    }

    public void setDoubleField(int objref, String fname, double val) {
        this.setLongField(objref, fname, Types.doubleToLong(val));
    }

    public double getDoubleField(int objref, String fname) {
        return Types.longToDouble(this.getLongField(objref, fname));
    }

    public void setFloatField(int objref, String fname, float val) {
        this.setIntField(objref, fname, Types.floatToInt(val));
    }

    public float getFloatField(int objref, String fname) {
        return Types.intToFloat(this.getIntField(objref, fname));
    }

    public void setByteArrayElement(int objref, int index, byte value) {
        ((DynamicElementInfo)this.da.get(objref)).setElement(index, value);
    }

    public byte getByteArrayElement(int objref, int index) {
        return (byte)((DynamicElementInfo)this.da.get(objref)).getElement(index);
    }

    public void setCharArrayElement(int objref, int index, char value) {
        ((DynamicElementInfo)this.da.get(objref)).setElement(index, value);
    }

    public void setIntArrayElement(int objref, int index, int value) {
        ((DynamicElementInfo)this.da.get(objref)).setElement(index, value);
    }

    public void setShortArrayElement(int objref, int index, short value) {
        ((DynamicElementInfo)this.da.get(objref)).setElement(index, value);
    }

    public void setFloatArrayElement(int objref, int index, float value) {
        ((DynamicElementInfo)this.da.get(objref)).setElement(index, Types.floatToInt(value));
    }

    public float getFloatArrayElement(int objref, int index) {
        return Types.intToFloat(((DynamicElementInfo)this.da.get(objref)).getElement(index));
    }

    public short getShortArrayElement(int objref, int index) {
        return (short)((DynamicElementInfo)this.da.get(objref)).getElement(index);
    }

    public int getIntArrayElement(int objref, int index) {
        return ((DynamicElementInfo)this.da.get(objref)).getElement(index);
    }

    public char getCharArrayElement(int objref, int index) {
        return (char)((DynamicElementInfo)this.da.get(objref)).getElement(index);
    }

    public void setIntField(int objref, String fname, int val) {
        Object ei = this.da.get(objref);
        ((ElementInfo)ei).setIntField(fname, val);
    }

    public void setDeclaredIntField(int objref, String refType, String fname, int val) {
        Object ei = this.da.get(objref);
        ((ElementInfo)ei).setDeclaredIntField(fname, refType, val);
    }

    public int getIntField(int objref, String fname) {
        Object ei = this.da.get(objref);
        return ((ElementInfo)ei).getIntField(fname);
    }

    public int getDeclaredIntField(int objref, String refType, String fname) {
        Object ei = this.da.get(objref);
        return ((ElementInfo)ei).getDeclaredIntField(fname, refType);
    }

    public void setDeclaredReferenceField(int objref, String refType, String fname, int val) {
        Object ei = this.da.get(objref);
        ((ElementInfo)ei).setDeclaredReferenceField(fname, refType, val);
    }

    public void setReferenceField(int objref, String fname, int ref) {
        Object ei = this.da.get(objref);
        ((ElementInfo)ei).setReferenceField(fname, ref);
    }

    public int getReferenceField(int objref, String fname) {
        return this.getIntField(objref, fname);
    }

    public int getReferenceField(int objref, FieldInfo fi) {
        Object ei = this.da.get(objref);
        return ((ElementInfo)ei).getReferenceField(fi);
    }

    public boolean getBooleanValue(int objref) {
        return this.getBooleanField(objref, "value");
    }

    public byte getByteValue(int objref) {
        return this.getByteField(objref, "value");
    }

    public char getCharValue(int objref) {
        return this.getCharField(objref, "value");
    }

    public short getShortValue(int objref) {
        return this.getShortField(objref, "value");
    }

    public int getIntValue(int objref) {
        return this.getIntField(objref, "value");
    }

    public long getLongValue(int objref) {
        return this.getLongField(objref, "value");
    }

    public float getFloatValue(int objref) {
        return this.getFloatField(objref, "value");
    }

    public double getDoubleValue(int objref) {
        return this.getDoubleField(objref, "value");
    }

    public void setLongArrayElement(int objref, int index, long value) {
        ((DynamicElementInfo)this.da.get(objref)).setLongElement(index, value);
    }

    public long getLongArrayElement(int objref, int index) {
        return ((DynamicElementInfo)this.da.get(objref)).getLongElement(index);
    }

    public void setLongField(int objref, String fname, long val) {
        Object ei = this.da.get(objref);
        ((ElementInfo)ei).setLongField(fname, val);
    }

    public long getLongField(int objref, String fname) {
        Object ei = this.da.get(objref);
        return ((ElementInfo)ei).getLongField(fname);
    }

    public void setReferenceArrayElement(int objref, int index, int eRef) {
        ((DynamicElementInfo)this.da.get(objref)).setElement(index, eRef);
    }

    public int getReferenceArrayElement(int objref, int index) {
        return ((DynamicElementInfo)this.da.get(objref)).getElement(index);
    }

    public void setShortField(int objref, String fname, short val) {
        this.setIntField(objref, fname, val);
    }

    public short getShortField(int objref, String fname) {
        return (short)this.getIntField(objref, fname);
    }

    public String getTypeName(int objref) {
        return ((DynamicElementInfo)this.da.get(objref)).getType();
    }

    public boolean isInstanceOf(int objref, String clsName) {
        ClassInfo ci = this.getClassInfo(objref);
        return ci.isInstanceOf(clsName);
    }

    public void setStaticBooleanField(String clsName, String fname, boolean value) {
        this.setStaticIntField(clsName, fname, Types.booleanToInt(value));
    }

    public boolean getStaticBooleanField(String clsName, String fname) {
        return Types.intToBoolean(this.getStaticIntField(clsName, fname));
    }

    public void setStaticByteField(String clsName, String fname, byte value) {
        this.setStaticIntField(clsName, fname, (int)value);
    }

    public byte getStaticByteField(String clsName, String fname) {
        return (byte)this.getStaticIntField(clsName, fname);
    }

    public void setStaticCharField(String clsName, String fname, char value) {
        this.setStaticIntField(clsName, fname, (int)value);
    }

    public char getStaticCharField(String clsName, String fname) {
        return (char)this.getStaticIntField(clsName, fname);
    }

    public void setStaticDoubleField(String clsName, String fname, double val) {
        this.setStaticLongField(clsName, fname, Types.doubleToLong(val));
    }

    public double getStaticDoubleField(String clsName, String fname) {
        return Types.longToDouble(this.getStaticLongField(clsName, fname));
    }

    public void setStaticFloatField(String clsName, String fname, float value) {
        this.setStaticIntField(clsName, fname, Types.floatToInt(value));
    }

    public float getStaticFloatField(String clsName, String fname) {
        return Types.intToFloat(this.getStaticIntField(clsName, fname));
    }

    public void setStaticIntField(String clsName, String fname, int value) {
        ClassInfo ci = ClassInfo.getClassInfo(clsName);
        this.sa.get(ci.getName()).setIntField(fname, value);
    }

    public void setStaticIntField(int clsObjRef, String fname, int val) {
        try {
            ElementInfo cei = this.getClassElementInfo(clsObjRef);
            cei.setIntField(fname, val);
        }
        catch (Throwable x) {
            throw new JPFException("set static field failed: " + x.getMessage());
        }
    }

    public int getStaticIntField(String clsName, String fname) {
        ClassInfo ci = ClassInfo.getClassInfo(clsName);
        StaticElementInfo ei = this.sa.get(ci.getName());
        return ei.getIntField(fname);
    }

    public void setStaticLongField(String clsName, String fname, long value) {
        ClassInfo ci = ClassInfo.getClassInfo(clsName);
        this.sa.get(ci.getName()).setLongField(fname, value);
    }

    public long getStaticLongField(int clsRef, String fname) {
        ClassInfo ci = this.getReferredClassInfo(clsRef);
        return this.getStaticLongField(ci, fname);
    }

    public long getStaticLongField(String clsName, String fname) {
        ClassInfo ci = ClassInfo.getClassInfo(clsName);
        return this.getStaticLongField(ci, fname);
    }

    public long getStaticLongField(ClassInfo ci, String fname) {
        StaticElementInfo ei = this.sa.get(ci.getName());
        return ei.getLongField(fname);
    }

    public void setStaticReferenceField(String clsName, String fname, int objref) {
        ClassInfo ci = ClassInfo.getClassInfo(clsName);
        this.sa.get(ci.getName()).setReferenceField(fname, objref);
    }

    public int getStaticReferenceField(String clsName, String fname) {
        return this.getStaticIntField(clsName, fname);
    }

    public short getStaticShortField(String clsName, String fname) {
        return (short)this.getStaticIntField(clsName, fname);
    }

    public String getStringObject(int objref) {
        if (objref != -1) {
            ElementInfo ei = this.getElementInfo(objref);
            return ei.asString();
        }
        return null;
    }

    public Object[] getArgumentArray(int argRef) {
        if (argRef == -1) {
            return null;
        }
        int nArgs = this.getArrayLength(argRef);
        Object[] args = new Object[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            int aref = this.getReferenceArrayElement(argRef, i);
            ClassInfo ci = this.getClassInfo(aref);
            String clsName = ci.getName();
            if (clsName.equals("java.lang.Boolean")) {
                args[i] = new Boolean(this.getBooleanField(aref, "value"));
                continue;
            }
            if (clsName.equals("java.lang.Integer")) {
                args[i] = new Integer(this.getIntField(aref, "value"));
                continue;
            }
            if (clsName.equals("java.lang.Double")) {
                args[i] = new Double(this.getDoubleField(aref, "value"));
                continue;
            }
            if (!clsName.equals("java.lang.String")) continue;
            args[i] = this.getStringObject(aref);
        }
        return args;
    }

    public Boolean getBooleanObject(int objref) {
        return new Boolean(this.getBooleanField(objref, "value"));
    }

    public Byte getByteObject(int objref) {
        return new Byte(this.getByteField(objref, "value"));
    }

    public Character getCharObject(int objref) {
        return new Character(this.getCharField(objref, "value"));
    }

    public Integer getIntegerObject(int objref) {
        return new Integer(this.getIntField(objref, "value"));
    }

    public Long getLongObject(int objref) {
        return new Long(this.getLongField(objref, "value"));
    }

    public Float getFloatObject(int objref) {
        return new Float(this.getFloatField(objref, "value"));
    }

    public Double getDoubleObject(int objref) {
        return new Double(this.getDoubleField(objref, "value"));
    }

    public byte[] getByteArrayObject(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        byte[] a = ei.asByteArray();
        return a;
    }

    public char[] getCharArrayObject(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        char[] a = ei.asCharArray();
        return a;
    }

    public short[] getShortArrayObject(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        short[] a = ei.asShortArray();
        return a;
    }

    public int[] getIntArrayObject(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        int[] a = ei.asIntArray();
        return a;
    }

    public long[] getLongArrayObject(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        long[] a = ei.asLongArray();
        return a;
    }

    public float[] getFloatArrayObject(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        float[] a = ei.asFloatArray();
        return a;
    }

    public double[] getDoubleArrayObject(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        double[] a = ei.asDoubleArray();
        return a;
    }

    public double getDoubleArrayElement(int objref, int index) {
        return Types.longToDouble(((DynamicElementInfo)this.da.get(objref)).getLongElement(index));
    }

    public void setDoubleArrayElement(int objref, int index, double value) {
        ((DynamicElementInfo)this.da.get(objref)).setLongElement(index, Types.doubleToLong(value));
    }

    public boolean[] getBooleanArrayObject(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        boolean[] a = ei.asBooleanArray();
        return a;
    }

    public boolean canLock(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        return ei.canLock(this.ti);
    }

    public int newBooleanArray(int size) {
        return this.da.newArray("Z", size, this.ti);
    }

    public int newByteArray(int size) {
        return this.da.newArray("B", size, this.ti);
    }

    public int newByteArray(byte[] buf) {
        int ref = this.da.newArray("B", buf.length, this.ti);
        for (int i = 0; i < buf.length; ++i) {
            this.setByteArrayElement(ref, i, buf[i]);
        }
        return ref;
    }

    public int newCharArray(int size) {
        return this.da.newArray("C", size, this.ti);
    }

    public int newCharArray(char[] buf) {
        int ref = this.da.newArray("C", buf.length, this.ti);
        for (int i = 0; i < buf.length; ++i) {
            this.setCharArrayElement(ref, i, buf[i]);
        }
        return ref;
    }

    public int newDoubleArray(int size) {
        return this.da.newArray("D", size, this.ti);
    }

    public int newDoubleArray(double[] buf) {
        int ref = this.da.newArray("D", buf.length, this.ti);
        for (int i = 0; i < buf.length; ++i) {
            this.setDoubleArrayElement(ref, i, buf[i]);
        }
        return ref;
    }

    public int newFloatArray(int size) {
        return this.da.newArray("F", size, this.ti);
    }

    public int newIntArray(int size) {
        return this.da.newArray("I", size, this.ti);
    }

    public int newIntArray(int[] buf) {
        int ref = this.da.newArray("I", buf.length, this.ti);
        for (int i = 0; i < buf.length; ++i) {
            this.setIntArrayElement(ref, i, buf[i]);
        }
        return ref;
    }

    public int newLongArray(int size) {
        return this.da.newArray("J", size, this.ti);
    }

    public int newLongArray(int[] buf) {
        int ref = this.da.newArray("J", buf.length, this.ti);
        for (int i = 0; i < buf.length; ++i) {
            this.setLongArrayElement(ref, i, buf[i]);
        }
        return ref;
    }

    public int newObject(ClassInfo ci) {
        return this.da.newObject(ci, this.ti);
    }

    public int newObject(String clsName) {
        ClassInfo ci = ClassInfo.getClassInfo(clsName);
        if (ci != null) {
            return this.newObject(ci);
        }
        return -1;
    }

    public int newObjectArray(String elementClsName, int size) {
        if (!elementClsName.endsWith(";")) {
            elementClsName = Types.getTypeCode(elementClsName, false);
        }
        return this.da.newArray(elementClsName, size, this.ti);
    }

    public int newShortArray(int size) {
        return this.da.newArray("S", size, this.ti);
    }

    public int newString(String s) {
        if (s == null) {
            return -1;
        }
        return this.da.newString(s, this.ti);
    }

    public int newStringArray(String[] a) {
        int aref = this.newObjectArray("Ljava/lang/String;", a.length);
        for (int i = 0; i < a.length; ++i) {
            this.setReferenceArrayElement(aref, i, this.newString(a[i]));
        }
        return aref;
    }

    public int newString(int arrayRef) {
        String t = this.getArrayType(arrayRef);
        String s = null;
        if ("C".equals(t)) {
            char[] ca = this.getCharArrayObject(arrayRef);
            s = new String(ca);
        } else if ("B".equals(t)) {
            byte[] ba = this.getByteArrayObject(arrayRef);
            s = new String(ba);
        }
        if (s == null) {
            return -1;
        }
        return this.newString(s);
    }

    public String format(int fmtRef, int argRef) {
        String format = this.getStringObject(fmtRef);
        int len = this.getArrayLength(argRef);
        Object[] arg = new Object[len];
        for (int i = 0; i < len; ++i) {
            int ref = this.getReferenceArrayElement(argRef, i);
            String clsName = this.getClassName(ref);
            arg[i] = clsName.equals("java.lang.String") ? this.getStringObject(ref) : (clsName.equals("java.lang.Char") ? this.getCharObject(ref) : (clsName.equals("java.lang.Integer") ? this.getIntegerObject(ref) : (clsName.equals("java.lang.Long") ? this.getLongObject(ref) : (clsName.equals("java.lang.Float") ? this.getFloatObject(ref) : (clsName.equals("java.lang.Double") ? this.getDoubleObject(ref) : "??")))));
        }
        return String.format(format, arg);
    }

    public int newBoolean(boolean b) {
        return this.getStaticReferenceField("java.lang.Boolean", b ? "TRUE" : "FALSE");
    }

    public int newInteger(int n) {
        int r = this.da.newObject(ClassInfo.getClassInfo("java.lang.Integer"), this.ti);
        this.setIntField(r, "value", n);
        return r;
    }

    public int newLong(long l) {
        int r = this.da.newObject(ClassInfo.getClassInfo("java.lang.Long"), this.ti);
        this.setLongField(r, "value", l);
        return r;
    }

    public int newDouble(double d) {
        int r = this.da.newObject(ClassInfo.getClassInfo("java.lang.Double"), this.ti);
        this.setDoubleField(r, "value", d);
        return r;
    }

    public int newFloat(float f) {
        int r = this.da.newObject(ClassInfo.getClassInfo("java.lang.Float"), this.ti);
        this.setIntField(r, "value", Types.floatToInt(f));
        return r;
    }

    public int newByte(byte b) {
        int r = this.da.newObject(ClassInfo.getClassInfo("java.lang.Byte"), this.ti);
        this.setIntField(r, "value", b);
        return r;
    }

    public int newShort(short s) {
        int r = this.da.newObject(ClassInfo.getClassInfo("java.lang.Short"), this.ti);
        this.setIntField(r, "value", s);
        return r;
    }

    public int newCharacter(char c) {
        int r = this.da.newObject(ClassInfo.getClassInfo("java.lang.Character"), this.ti);
        this.setIntField(r, "value", c);
        return r;
    }

    public void notify(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        if (!ei.isLockedBy(this.ti)) {
            this.throwException("java.lang.IllegalMonitorStateException", "un-synchronized notify");
            return;
        }
        ei.notifies(this.getSystemState(), this.ti);
    }

    public void notifyAll(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        if (!ei.isLockedBy(this.ti)) {
            this.throwException("java.lang.IllegalMonitorStateException", "un-synchronized notifyAll");
            return;
        }
        ei.notifiesAll();
    }

    public void pinDown(int objref, boolean keepAlive) {
        ElementInfo ei = this.getElementInfo(objref);
        ei.pinDown(keepAlive);
    }

    public void repeatInvocation() {
        this.repeat = true;
    }

    public void setReturnAttribute(Object attr) {
        this.returnAttr = attr;
    }

    public Object[] getArgAttributes() {
        StackFrame caller = this.ti.getTopFrame();
        return caller.getArgumentAttrs(this.mi);
    }

    public Object getReturnAttribute() {
        return this.returnAttr;
    }

    public void throwException(String classname) {
        this.exception = Types.asTypeName(classname);
    }

    public void throwException(String classname, String details) {
        this.exception = Types.asTypeName(classname);
        this.exceptionDetails = details;
    }

    public void throwAssertion(String details) {
        this.throwException("java.lang.AssertionError", details);
    }

    public void wait(int objref, long timeout) {
        ElementInfo ei = this.getElementInfo(objref);
        if (!ei.isLockedBy(this.ti)) {
            this.throwException("java.lang.IllegalMonitorStateException", "un-synchronized wait");
            return;
        }
        ei.wait(this.ti, timeout);
    }

    void setCallEnvironment(MethodInfo mi) {
        this.mi = mi;
        if (mi != null) {
            this.ci = mi.getClassInfo();
        }
        this.repeat = false;
        this.exception = null;
        this.exceptionDetails = null;
        this.returnAttr = null;
    }

    void clearCallEnvironment() {
        this.setCallEnvironment(null);
    }

    ElementInfo getClassElementInfo(int clsObjRef) {
        Object ei = this.da.get(clsObjRef);
        int cref = ((ElementInfo)ei).getIntField("cref");
        Object cei = this.sa.get(cref);
        return cei;
    }

    ClassInfo getClassInfo() {
        return this.ci;
    }

    public ClassInfo getReferredClassInfo(int clsObjRef) {
        int idx = this.getIntField(clsObjRef, "cref");
        StaticArea sa = this.getStaticArea();
        Object sei = sa.get(idx);
        return ((ElementInfo)sei).getClassInfo();
    }

    public ClassInfo getClassInfo(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        if (ei != null) {
            return ei.getClassInfo();
        }
        return null;
    }

    public String getClassName(int objref) {
        return this.getClassInfo(objref).getName();
    }

    DynamicArea getDynamicArea() {
        return JVM.getVM().getDynamicArea();
    }

    ElementInfo getElementInfo(int objref) {
        return this.da.get(objref);
    }

    public int getStateId() {
        return JVM.getVM().getStateId();
    }

    String getException() {
        return this.exception;
    }

    String getExceptionDetails() {
        return this.exceptionDetails;
    }

    KernelState getKernelState() {
        return JVM.getVM().getKernelState();
    }

    MethodInfo getMethodInfo() {
        return this.mi;
    }

    Instruction getInstruction() {
        return this.ti.getPC();
    }

    boolean getRepeat() {
        return this.repeat;
    }

    StaticArea getStaticArea() {
        return this.ti.getVM().getStaticArea();
    }

    SystemState getSystemState() {
        return this.ti.getVM().getSystemState();
    }

    ThreadInfo getThreadInfo() {
        return this.ti;
    }

    void lockNotified(int objref) {
        ElementInfo ei = this.getElementInfo(objref);
        ei.lockNotified(this.ti);
    }

    void initAnnotationProxyField(int proxyRef, FieldInfo fi, Object v) {
        String fname = fi.getName();
        String ftype = fi.getType();
        if (v instanceof String) {
            this.setReferenceField(proxyRef, fname, this.newString((String)v));
        } else if (v instanceof Boolean) {
            this.setBooleanField(proxyRef, fname, (Boolean)v);
        } else if (v instanceof Integer) {
            this.setIntField(proxyRef, fname, (Integer)v);
        } else if (v instanceof Long) {
            this.setLongField(proxyRef, fname, (Long)v);
        } else if (v instanceof Float) {
            this.setFloatField(proxyRef, fname, ((Float)v).floatValue());
        } else if (v instanceof Short) {
            this.setShortField(proxyRef, fname, (Short)v);
        } else if (v instanceof Character) {
            this.setCharField(proxyRef, fname, ((Character)v).charValue());
        } else if (v instanceof Byte) {
            this.setByteField(proxyRef, fname, (Byte)v);
        } else if (v instanceof Double) {
            this.setDoubleField(proxyRef, fname, (Double)v);
        } else if (v instanceof FieldInfo) {
            FieldInfo efi = (FieldInfo)v;
            ClassInfo eci = efi.getClassInfo();
            if (!eci.isInitialized()) {
                throw new ClinitRequired(eci);
            }
            StaticElementInfo sei = this.sa.get(eci.getName());
            int eref = sei.getIntField(efi.getName());
            this.setReferenceField(proxyRef, fname, eref);
        } else if (v instanceof ClassInfo) {
            ClassInfo cci = (ClassInfo)v;
            if (!cci.isInitialized()) {
                throw new ClinitRequired(cci);
            }
            int cref = cci.getClassObjectRef();
            this.setReferenceField(proxyRef, fname, cref);
        } else if (v.getClass().isArray()) {
            Object[] a = (Object[])v;
            int aref = -1;
            if (ftype.equals("java.lang.String[]")) {
                aref = this.newObjectArray("Ljava/lang/String;", a.length);
                for (int i = 0; i < a.length; ++i) {
                    this.setReferenceArrayElement(aref, i, this.newString(a[i].toString()));
                }
            } else if (ftype.equals("int[]")) {
                aref = this.newIntArray(a.length);
                for (int i = 0; i < a.length; ++i) {
                    this.setIntArrayElement(aref, i, ((Number)a[i]).intValue());
                }
            } else if (ftype.equals("boolean[]")) {
                aref = this.newBooleanArray(a.length);
                for (int i = 0; i < a.length; ++i) {
                    this.setBooleanArrayElement(aref, i, (Boolean)a[i]);
                }
            } else if (ftype.equals("long[]")) {
                aref = this.newLongArray(a.length);
                for (int i = 0; i < a.length; ++i) {
                    this.setLongArrayElement(aref, i, ((Number)a[i]).longValue());
                }
            } else if (ftype.equals("double[]")) {
                aref = this.newDoubleArray(a.length);
                for (int i = 0; i < a.length; ++i) {
                    this.setDoubleArrayElement(aref, i, ((Number)a[i]).doubleValue());
                }
            } else if (ftype.equals("java.lang.Class[]")) {
                aref = this.newObjectArray("java.lang.Class", a.length);
                for (int i = 0; i < a.length; ++i) {
                    ClassInfo cci = (ClassInfo)a[i];
                    if (!cci.isInitialized()) {
                        throw new ClinitRequired(cci);
                    }
                    int cref = cci.getClassObjectRef();
                    this.setReferenceArrayElement(aref, i, cref);
                }
            }
            if (aref != -1) {
                this.setReferenceField(proxyRef, fname, aref);
            } else {
                this.throwException("AnnotationElement type not supported: " + ftype);
            }
        } else {
            this.throwException("AnnotationElement type not supported: " + ftype);
        }
    }

    int newAnnotationProxy(ClassInfo aciProxy, AnnotationInfo ai) {
        int proxyRef = this.newObject(aciProxy);
        for (AnnotationInfo.Entry e : ai.getEntries()) {
            Object v = e.getValue();
            String fname = e.getKey();
            FieldInfo fi = aciProxy.getInstanceField(fname);
            this.initAnnotationProxyField(proxyRef, fi, v);
        }
        return proxyRef;
    }

    int newAnnotationProxies(AnnotationInfo[] ai) {
        if (ai != null && ai.length > 0) {
            int aref = this.newObjectArray("Ljava/lang/annotation/Annotation;", ai.length);
            for (int i = 0; i < ai.length; ++i) {
                ClassInfo aci = ClassInfo.getClassInfo(ai[i].getName());
                ClassInfo aciProxy = ClassInfo.getAnnotationProxy(aci);
                aciProxy.loadAndInitialize(this.getThreadInfo());
                int ar = this.newAnnotationProxy(aciProxy, ai[i]);
                this.setReferenceArrayElement(aref, i, ar);
            }
            return aref;
        }
        int aref = this.getStaticReferenceField("java.lang.Class", "emptyAnnotations");
        if (aref == -1) {
            aref = this.newObjectArray("Ljava/lang/annotation/Annotation;", 0);
            this.setStaticReferenceField("java.lang.Class", "emptyAnnotations", aref);
        }
        return aref;
    }

    public void handleClinitRequest(ClassInfo ci) {
        ThreadInfo ti = this.getThreadInfo();
        Instruction insn = ti.getPC();
        insn.requiresClinitCalls(ti, ci);
        this.repeatInvocation();
    }
}

