/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import org.apache.bcel.classfile.ConstantValue;

public class LongFieldInfo
extends FieldInfo {
    long init;

    public LongFieldInfo(String name, String type, int modifiers, ConstantValue cv, ClassInfo ci, int idx, int off) {
        super(name, type, modifiers, cv, ci, idx, off);
        this.init = cv != null ? Long.parseLong(cv.toString()) : 0L;
    }

    @Override
    public void initialize(ElementInfo ei) {
        ei.getFields().setLongValue(ei, this.storageOffset, this.init);
    }

    @Override
    public int getStorageSize() {
        return 2;
    }

    @Override
    public String valueToString(Fields f) {
        long v = f.getLongValue(this.storageOffset);
        return Long.toString(v);
    }

    @Override
    public Object getValueObject(Fields f) {
        long v = f.getLongValue(this.storageOffset);
        return new Long(v);
    }
}

