/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.IncrementalChangeTracker;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.util.HashData;
import java.util.Stack;

public class KernelState {
    public StaticArea sa;
    public DynamicArea da;
    public ThreadList tl;
    private Stack<ChangeListener> listeners = new Stack();

    public KernelState(Config config) throws Config.Exception {
        Class[] argTypes = new Class[]{Config.class, KernelState.class};
        Object[] args = new Object[]{config, this};
        this.sa = config.getEssentialInstance("vm.static_area.class", StaticArea.class, argTypes, args);
        this.da = config.getEssentialInstance("vm.dynamic_area.class", DynamicArea.class, argTypes, args);
        this.tl = new ThreadList(config, this);
    }

    public void changed() {
        while (!this.listeners.empty()) {
            this.listeners.pop().kernelStateChanged(this);
        }
    }

    public void pushChangeListener(ChangeListener cl) {
        if (cl instanceof IncrementalChangeTracker && this.listeners.size() > 0) {
            for (ChangeListener l : this.listeners) {
                if (!(l instanceof IncrementalChangeTracker)) continue;
                throw new IllegalStateException("Only one IncrementalChangeTracker allowed!");
            }
        }
        this.listeners.push(cl);
    }

    boolean isDeadlocked() {
        return this.tl.isDeadlocked();
    }

    public boolean isTerminated() {
        return !this.tl.hasMoreThreadsToRun();
    }

    public int getThreadCount() {
        return this.tl.length();
    }

    @Deprecated
    public ThreadInfo getThreadInfo(int index) {
        return this.tl.get(index);
    }

    public void gc() {
        this.da.gc();
        this.da.cleanUpDanglingReferences();
        this.sa.cleanUpDanglingReferences();
    }

    public void hash(HashData hd) {
        this.da.hash(hd);
        this.sa.hash(hd);
        int l = this.tl.length();
        for (int i = 0; i < l; ++i) {
            this.tl.get(i).hash(hd);
        }
    }

    public ThreadList getThreadList() {
        return this.tl;
    }

    public static interface ChangeListener {
        public void kernelStateChanged(KernelState var1);
    }
}

