/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.SerializingStateSet;
import gov.nasa.jpf.util.LongVector;

public class JenkinsStateSet
extends SerializingStateSet {
    static final double MAX_LOAD = 0.7;
    static final int INIT_SIZE = 65536;
    int lastStateId = -1;
    LongVector fingerprints;
    int[] hashtable = new int[65536];
    int nextRehash = 45875;

    public JenkinsStateSet() {
        this.fingerprints = new LongVector(this.nextRehash / 2);
    }

    @Override
    public int size() {
        return this.lastStateId + 1;
    }

    static long longLookup3Hash(int[] val) {
        int i;
        int a = 1359984141;
        int b = -1530187559 + val.length;
        int c = -1640531527;
        for (i = 0; i < val.length - 2; i += 3) {
            a += val[i];
            a -= (c += val[i + 2]);
            a ^= c << 4 ^ c >>> 28;
            b -= a;
            b ^= a << 6 ^ a >>> 26;
            a += (c += (b += val[i + 1]));
            c -= b;
            c ^= b << 8 ^ b >>> 24;
            b += a;
            a -= c;
            a ^= c << 16 ^ c >>> 16;
            c += b;
            b -= a;
            b ^= a << 19 ^ a >>> 13;
            a += c;
            c -= b;
            c ^= b << 4 ^ b >>> 28;
            b += a;
        }
        switch (val.length - i) {
            case 2: {
                c += val[val.length - 2];
                b += val[val.length - 1];
                break;
            }
            case 1: {
                b += val[val.length - 1];
            }
        }
        c ^= b;
        a ^= (c -= b << 14 ^ b >>> 18);
        b ^= (a -= c << 11 ^ c >>> 21);
        c ^= (b -= a << 25 ^ a >>> 7);
        a ^= (c -= b << 16 ^ b >>> 16);
        b ^= (a -= c << 4 ^ c >>> 28);
        c ^= (b -= a << 14 ^ a >>> 18);
        return (long)(c -= b << 24 ^ b >>> 8) << 32 ^ (long)b ^ (long)a;
    }

    @Override
    public int add(int[] val) {
        long hash = JenkinsStateSet.longLookup3Hash(val);
        int mask = this.hashtable.length - 1;
        int idx = (int)(hash >> 32) & mask;
        int delta = (int)hash | 1;
        int oidx = idx;
        while (this.hashtable[idx] != 0) {
            int id = this.hashtable[idx] - 1;
            if (this.fingerprints.get(id) == hash) {
                return id;
            }
            idx = idx + delta & mask;
            assert (idx != oidx);
        }
        assert (this.hashtable[idx] == 0);
        if (this.lastStateId >= this.nextRehash) {
            this.hashtable = null;
            this.hashtable = new int[mask + 1 << 1];
            mask = this.hashtable.length - 1;
            this.nextRehash = (int)(0.7 * (double)mask);
            for (int i = 0; i <= this.lastStateId; ++i) {
                long h = this.fingerprints.get(i);
                idx = (int)(h >> 32) & mask;
                delta = (int)h | 1;
                while (this.hashtable[idx] != 0) {
                    idx = idx + delta & mask;
                }
                this.hashtable[idx] = i + 1;
            }
            idx = (int)(hash >> 32) & mask;
            delta = (int)hash | 1;
            while (this.hashtable[idx] != 0) {
                idx = idx + delta & mask;
            }
        }
        ++this.lastStateId;
        this.hashtable[idx] = this.lastStateId + 1;
        this.fingerprints.set(this.lastStateId, hash);
        return this.lastStateId;
    }

    public static void main(String[] args) {
        try {
            int i;
            int vlen = Integer.parseInt(args[0]);
            int adds = Integer.parseInt(args[1]);
            int queries = Integer.parseInt(args[2]);
            if (queries > adds) {
                queries = adds;
                System.err.println("Truncating queries to " + queries);
            }
            int[] v = new int[vlen];
            for (i = 0; i < vlen; ++i) {
                v[i] = i - 42;
            }
            JenkinsStateSet set = new JenkinsStateSet();
            for (i = 0; i < adds; ++i) {
                v[0] = i * 3;
                set.add(v);
                assert (set.size() == i + 1);
            }
            for (i = 0; i < queries; ++i) {
                v[0] = i * 3;
                set.add(v);
                assert (set.size() == adds);
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            System.err.println("args:  vector_length  #adds  #queries");
        }
    }
}

