/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.Backtracker;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ChoicePoint;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DirectCallStackFrame;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.ExceptionInfo;
import gov.nasa.jpf.jvm.IncrementalChangeTracker;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.NativePeer;
import gov.nasa.jpf.jvm.Path;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.StateRestorer;
import gov.nasa.jpf.jvm.StateSerializer;
import gov.nasa.jpf.jvm.StateSet;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.Step;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.jvm.UncaughtException;
import gov.nasa.jpf.jvm.VMListener;
import gov.nasa.jpf.jvm.VMListenerMulticaster;
import gov.nasa.jpf.jvm.VMState;
import gov.nasa.jpf.jvm.bytecode.FieldInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.choice.ThreadChoiceFromSet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class JVM {
    protected static Logger log = JPF.getLogger("gov.nasa.jpf.jvm.JVM");
    JPF jpf;
    protected static int error_id;
    protected static JVM jvm;
    protected SystemState ss;
    protected String mainClassName;
    protected String[] args;
    protected Path path;
    protected StringBuilder out;
    protected Transition lastTrailInfo;
    protected ClassInfo lastClassInfo;
    protected ThreadInfo lastThreadInfo;
    protected Instruction lastInstruction;
    protected Instruction nextInstruction;
    protected ElementInfo lastElementInfo;
    protected ChoiceGenerator lastChoiceGenerator;
    protected boolean isTraceReplay;
    protected StateSet stateSet;
    protected int newStateId;
    protected Backtracker backtracker;
    protected StateRestorer<?> restorer;
    protected StateSerializer serializer;
    protected VMListener listener;
    protected Config config;
    protected boolean runGc;
    protected boolean treeOutput;
    protected boolean pathOutput;
    protected boolean indentOutput;

    public JVM(JPF jpf, Config conf) throws Config.Exception {
        this.jpf = jpf;
        jvm = this;
        this.config = conf;
        this.runGc = this.config.getBoolean("vm.gc", true);
        this.treeOutput = this.config.getBoolean("vm.tree_output", true);
        this.indentOutput = this.config.getBoolean("vm.indent_output", false);
        this.initSubsystems(this.config);
        this.initFields(this.config);
    }

    public JPF getJPF() {
        return this.jpf;
    }

    public void initFields(Config config) throws Config.Exception {
        this.mainClassName = config.getTargetArg();
        this.args = config.getTargetArgParameters();
        this.path = new Path(this.mainClassName);
        this.out = null;
        this.ss = new SystemState(config, this);
        this.stateSet = config.getInstance("vm.storage.class", StateSet.class);
        if (this.stateSet != null) {
            this.stateSet.attach(this);
        }
        this.backtracker = config.getEssentialInstance("vm.backtracker.class", Backtracker.class);
        this.backtracker.attach(this);
    }

    protected void initSubsystems(Config config) throws Config.Exception {
        ClassInfo.init(config);
        ThreadInfo.init(config);
        MethodInfo.init(config);
        DynamicArea.init(config);
        StaticArea.init(config);
        NativePeer.init(config);
        FieldInstruction.init(config);
        ChoiceGenerator.init(config);
    }

    static boolean checkModelClassAccess() {
        ClassInfo ci = ClassInfo.getClassInfo("java.lang.Class");
        return ci.getDeclaredInstanceField("cref") != null;
    }

    static boolean checkClassName(String clsName) {
        if (!clsName.matches("[a-zA-Z_$][a-zA-Z_$0-9.]*")) {
            return false;
        }
        if (clsName.endsWith(".java")) {
            return false;
        }
        return !clsName.endsWith(".class");
    }

    public boolean initialize() {
        if (!JVM.checkClassName(this.mainClassName)) {
            log.severe("not a valid class name: " + this.mainClassName);
            return false;
        }
        List<ClassInfo> clinitQueue = this.registerStartupClasses();
        if (clinitQueue == null) {
            log.severe("error initializing startup classes (check vm.[boot]classpath)");
            return false;
        }
        if (!JVM.checkModelClassAccess()) {
            log.severe("error during VM runtime initialization: wrong model classes (check vm.[boot]classpath)");
            return false;
        }
        ThreadInfo main = this.createMainThread();
        this.pushMain(this.config);
        this.createStartupClassObjects(clinitQueue, main);
        this.pushClinits(clinitQueue, main);
        this.initSystemState(main);
        return true;
    }

    protected void initSystemState(ThreadInfo mainThread) {
        ThreadChoiceFromSet cg = new ThreadChoiceFromSet(this.getThreadList().getRunnableThreads(), true);
        this.ss.setNextChoiceGenerator(cg);
        this.ss.setStartThread(mainThread);
        this.ss.recordSteps(this.hasToRecordSteps());
        if (!this.pathOutput) {
            this.pathOutput = this.hasToRecordPathOutput();
        }
    }

    protected ThreadInfo createMainThread() {
        DynamicArea da = this.getDynamicArea();
        int tObjRef = da.newObject(ClassInfo.getClassInfo("java.lang.Thread"), null);
        int grpObjref = this.createSystemThreadGroup(tObjRef);
        Object ei = da.get(tObjRef);
        ((ElementInfo)ei).setReferenceField("group", grpObjref);
        ((ElementInfo)ei).setReferenceField("name", da.newString("main", null));
        ((ElementInfo)ei).setIntField("priority", 5);
        int permitRef = da.newObject(ClassInfo.getClassInfo("java.lang.Thread$Permit"), null);
        ((ElementInfo)ei).setReferenceField("permit", permitRef);
        ThreadInfo ti = ThreadInfo.createThreadInfo(this, tObjRef);
        ti.setPriority(5);
        ti.setName("main");
        ti.setStatus(1);
        return ti;
    }

    protected int createSystemThreadGroup(int mainThreadRef) {
        DynamicArea da = this.getDynamicArea();
        int ref = da.newObject(ClassInfo.getClassInfo("java.lang.ThreadGroup"), null);
        Object ei = da.get(ref);
        int grpName = da.newString("main", null);
        ((ElementInfo)ei).setReferenceField("name", grpName);
        ((ElementInfo)ei).setIntField("maxPriority", 10);
        int threadsRef = da.newArray("Ljava/lang/Thread;", 4, null);
        Object eiThreads = da.get(threadsRef);
        ((ElementInfo)eiThreads).setElement(0, mainThreadRef);
        ((ElementInfo)ei).setReferenceField("threads", threadsRef);
        ((ElementInfo)ei).setIntField("nthreads", 1);
        return ref;
    }

    void registerStartupClass(ClassInfo ci, List<ClassInfo> queue) {
        StaticArea sa = this.getStaticArea();
        if (!queue.contains(ci)) {
            if (ci.getSuperClass() != null) {
                this.registerStartupClass(ci.getSuperClass(), queue);
            }
            queue.add(ci);
            if (!sa.containsClass(ci.getName())) {
                sa.addStartupClass(ci);
            }
        }
    }

    protected List<ClassInfo> registerStartupClasses() {
        String[] startupClasses;
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>(32);
        for (String clsName : startupClasses = new String[]{"java.lang.Object", "java.lang.Class", "java.lang.ClassLoader", "boolean", "[Z", "byte", "[B", "char", "[C", "short", "[S", "int", "[I", "long", "[J", "float", "[F", "double", "[D", "void", "java.lang.Boolean", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.String", "java.lang.ThreadGroup", "java.lang.Thread", "java.io.PrintStream", "java.io.InputStream", "java.lang.System", this.mainClassName}) {
            ClassInfo ci = ClassInfo.getClassInfo(clsName);
            if (ci == null) {
                log.severe("can't find startup class: " + clsName);
                return null;
            }
            this.registerStartupClass(ci, queue);
        }
        return queue;
    }

    protected void createStartupClassObjects(List<ClassInfo> queue, ThreadInfo ti) {
        StaticArea sa = this.getStaticArea();
        for (ClassInfo ci : queue) {
            StaticElementInfo sei = sa.get(ci.getName());
            sei.createStartupClassObject(ci, ti);
        }
    }

    protected void pushClinits(List<ClassInfo> queue, ThreadInfo ti) {
        ListIterator<ClassInfo> it = queue.listIterator(queue.size());
        while (it.hasPrevious()) {
            ClassInfo ci = it.previous();
            MethodInfo mi = ci.getMethod("<clinit>()V", false);
            if (mi != null) {
                MethodInfo stub = mi.createDirectCallStub("[clinit]");
                DirectCallStackFrame frame = new DirectCallStackFrame(stub);
                ti.pushFrame(frame);
                continue;
            }
            ci.setInitialized();
        }
    }

    protected void pushMain(Config config) {
        DynamicArea da = this.ss.ks.da;
        ClassInfo ci = ClassInfo.getClassInfo(this.mainClassName);
        MethodInfo mi = ci.getMethod("main([Ljava/lang/String;)V", false);
        ThreadInfo ti = this.ss.getThreadInfo(0);
        if (mi == null || !mi.isStatic()) {
            throw new JPFException("no main() method in " + ci.getName());
        }
        ti.pushFrame(new StackFrame(mi, null));
        ti.setStatus(1);
        int argsObjref = da.newArray("Ljava/lang/String;", this.args.length, null);
        Object argsElement = this.ss.ks.da.get(argsObjref);
        for (int i = 0; i < this.args.length; ++i) {
            int stringObjref = da.newString(this.args[i], null);
            ((ElementInfo)argsElement).setElement(i, stringObjref);
        }
        ti.setLocalVariable(0, argsObjref, true);
    }

    public void addListener(VMListener newListener) {
        this.listener = VMListenerMulticaster.add(this.listener, newListener);
    }

    public boolean hasListenerOfType(Class<?> listenerCls) {
        return VMListenerMulticaster.containsType(this.listener, listenerCls);
    }

    public void removeListener(VMListener removeListener) {
        this.listener = VMListenerMulticaster.remove(this.listener, removeListener);
    }

    public void setTraceReplay(boolean isReplay) {
        this.isTraceReplay = isReplay;
    }

    public boolean isTraceReplay() {
        return this.isTraceReplay;
    }

    public boolean hasToRecordSteps() {
        return this.jpf.getReporter().hasToReportTrace() || this.config.getBoolean("vm.store_steps");
    }

    public boolean hasToRecordPathOutput() {
        return this.jpf.getReporter().hasToReportOutput();
    }

    protected void notifyChoiceGeneratorSet(ChoiceGenerator cg) {
        if (this.listener != null) {
            this.lastChoiceGenerator = cg;
            this.listener.choiceGeneratorSet(this);
            this.lastChoiceGenerator = null;
        }
    }

    protected void notifyChoiceGeneratorAdvanced(ChoiceGenerator cg) {
        if (this.listener != null) {
            this.lastChoiceGenerator = cg;
            this.listener.choiceGeneratorAdvanced(this);
            this.lastChoiceGenerator = null;
        }
    }

    protected void notifyChoiceGeneratorProcessed(ChoiceGenerator cg) {
        if (this.listener != null) {
            this.lastChoiceGenerator = cg;
            this.listener.choiceGeneratorProcessed(this);
            this.lastChoiceGenerator = null;
        }
    }

    protected void notifyExecuteInstruction(ThreadInfo ti, Instruction insn) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastInstruction = insn;
            this.listener.executeInstruction(this);
        }
    }

    protected void notifyInstructionExecuted(ThreadInfo ti, Instruction insn, Instruction nextInsn) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastInstruction = insn;
            this.nextInstruction = nextInsn;
            this.listener.instructionExecuted(this);
        }
    }

    protected void notifyThreadStarted(ThreadInfo ti) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.listener.threadStarted(this);
        }
    }

    protected void notifyThreadBlocked(ThreadInfo ti) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastElementInfo = ti.getLockObject();
            this.listener.threadBlocked(this);
        }
    }

    protected void notifyThreadWaiting(ThreadInfo ti) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.listener.threadWaiting(this);
        }
    }

    protected void notifyThreadNotified(ThreadInfo ti) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.listener.threadNotified(this);
        }
    }

    protected void notifyThreadInterrupted(ThreadInfo ti) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.listener.threadInterrupted(this);
        }
    }

    protected void notifyThreadTerminated(ThreadInfo ti) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.listener.threadTerminated(this);
        }
    }

    protected void notifyThreadScheduled(ThreadInfo ti) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.listener.threadScheduled(this);
        }
    }

    protected void notifyClassLoaded(ClassInfo ci) {
        if (this.listener != null) {
            this.lastClassInfo = ci;
            this.listener.classLoaded(this);
        }
    }

    protected void notifyObjectCreated(ThreadInfo ti, ElementInfo ei) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastElementInfo = ei;
            this.listener.objectCreated(this);
        }
    }

    protected void notifyObjectReleased(ElementInfo ei) {
        if (this.listener != null) {
            this.lastElementInfo = ei;
            this.listener.objectReleased(this);
        }
    }

    protected void notifyObjectLocked(ThreadInfo ti, ElementInfo ei) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastElementInfo = ei;
            this.listener.objectLocked(this);
        }
    }

    protected void notifyObjectUnlocked(ThreadInfo ti, ElementInfo ei) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastElementInfo = ei;
            this.listener.objectUnlocked(this);
        }
    }

    protected void notifyObjectWait(ThreadInfo ti, ElementInfo ei) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastElementInfo = ei;
            this.listener.objectWait(this);
        }
    }

    protected void notifyObjectNotifies(ThreadInfo ti, ElementInfo ei) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastElementInfo = ei;
            this.listener.objectNotify(this);
        }
    }

    protected void notifyObjectNotifiesAll(ThreadInfo ti, ElementInfo ei) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastElementInfo = ei;
            this.listener.objectNotifyAll(this);
        }
    }

    protected void notifyGCBegin() {
        if (this.listener != null) {
            this.listener.gcBegin(this);
        }
    }

    protected void notifyGCEnd() {
        if (this.listener != null) {
            this.listener.gcEnd(this);
        }
    }

    protected void notifyExceptionThrown(ThreadInfo ti, ElementInfo ei) {
        if (this.listener != null) {
            this.lastThreadInfo = ti;
            this.lastElementInfo = ei;
            this.listener.exceptionThrown(this);
            this.lastElementInfo = null;
            this.lastThreadInfo = null;
        }
    }

    public int getThreadNumber() {
        if (this.lastThreadInfo != null) {
            return this.lastThreadInfo.getIndex();
        }
        return -1;
    }

    public String getThreadName() {
        ThreadInfo ti = ThreadInfo.getCurrentThread();
        return ti.getName();
    }

    Instruction getInstruction() {
        ThreadInfo ti = ThreadInfo.getCurrentThread();
        return ti.getPC();
    }

    public int getAbstractionNonDeterministicThreadCount() {
        int n = 0;
        int imax = this.ss.getThreadCount();
        for (int i = 0; i < imax; ++i) {
            ThreadInfo th = this.ss.getThreadInfo(i);
            if (!th.isAbstractionNonDeterministic()) continue;
            ++n;
        }
        return n;
    }

    public int getAliveThreadCount() {
        return this.getThreadList().getLiveThreadCount();
    }

    public ExceptionInfo getPendingException() {
        return ThreadInfo.currentThread.getPendingException();
    }

    public boolean isBoringState() {
        return this.ss.isBoring();
    }

    public StaticElementInfo getClassReference(String name) {
        return this.ss.ks.sa.get(name);
    }

    public boolean hasPendingException() {
        return ThreadInfo.currentThread.pendingException != null;
    }

    public boolean isDeadlocked() {
        return this.ss.isDeadlocked();
    }

    public boolean isEndState() {
        return this.ss.isEndState();
    }

    public Exception getException() {
        return this.ss.getUncaughtException();
    }

    public boolean isInterestingState() {
        return this.ss.isInteresting();
    }

    public Step getLastStep() {
        Transition trail = this.ss.getTrail();
        if (trail != null) {
            return trail.getLastStep();
        }
        return null;
    }

    public Transition getLastTransition() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(this.path.size() - 1);
    }

    public ClassInfo getLastClassInfo() {
        return this.lastClassInfo;
    }

    public ThreadInfo getLastThreadInfo() {
        return this.lastThreadInfo;
    }

    public Instruction getLastInstruction() {
        return this.lastInstruction;
    }

    public Instruction getNextInstruction() {
        return this.nextInstruction;
    }

    public ElementInfo getLastElementInfo() {
        return this.lastElementInfo;
    }

    public ChoiceGenerator getLastChoiceGenerator() {
        return this.lastChoiceGenerator;
    }

    public ClassInfo getClassInfo() {
        return this.lastClassInfo;
    }

    public ClassInfo getClassInfo(int objref) {
        if (objref != -1) {
            return ((DynamicElementInfo)this.getDynamicArea().get(objref)).getClassInfo();
        }
        return null;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public ClassInfo getMainClassInfo() {
        return ClassInfo.getClassInfo(this.mainClassName);
    }

    public String[] getArgs() {
        return this.args;
    }

    public Path getPath() {
        return this.path;
    }

    public Transition getCurrentTransition() {
        return this.ss.getTrail();
    }

    public Path getClonedPath() {
        return this.path.clone();
    }

    public int getPathLength() {
        return this.path.size();
    }

    public int getRunnableThreadCount() {
        return this.ss.getRunnableThreadCount();
    }

    public ThreadList getThreadList() {
        return this.getKernelState().getThreadList();
    }

    public VMState getState() {
        return new VMState(this);
    }

    public SystemState getSystemState() {
        return this.ss;
    }

    public KernelState getKernelState() {
        return this.ss.ks;
    }

    public Config getConfig() {
        return this.config;
    }

    public Backtracker getBacktracker() {
        return this.backtracker;
    }

    public <T> StateRestorer<T> getRestorer() throws Config.Exception {
        if (this.restorer == null) {
            if (this.serializer instanceof StateRestorer) {
                this.restorer = (StateRestorer)((Object)this.serializer);
            } else if (this.stateSet instanceof StateRestorer) {
                this.restorer = (StateRestorer)((Object)this.stateSet);
            } else {
                this.restorer = this.config.getInstance("vm.restorer.class", StateRestorer.class);
                if (this.serializer instanceof IncrementalChangeTracker && this.restorer instanceof IncrementalChangeTracker) {
                    Config config = this.config;
                    config.getClass();
                    throw config.new Config.Exception("Incompatible serializer and restorer!");
                }
            }
            this.restorer.attach(this);
        }
        return this.restorer;
    }

    public StateSerializer getSerializer() throws Config.Exception {
        if (this.serializer == null) {
            this.serializer = this.config.getEssentialInstance("vm.serializer.class", StateSerializer.class);
            this.serializer.attach(this);
        }
        return this.serializer;
    }

    public StateSet getStateSet() {
        return this.stateSet;
    }

    public ChoiceGenerator getChoiceGenerator() {
        return this.ss.getChoiceGenerator();
    }

    public boolean isTerminated() {
        return this.ss.ks.isTerminated();
    }

    public void print(String s) {
        if (this.treeOutput) {
            System.out.print(s);
        }
        if (this.pathOutput) {
            this.appendOutput(s);
        }
    }

    public void println(String s) {
        if (this.treeOutput) {
            if (this.indentOutput) {
                StringBuilder indent = new StringBuilder();
                for (int i = 0; i <= this.path.size(); ++i) {
                    indent.append('|').append(i);
                }
                indent.append("|").append(s);
                System.out.println(indent);
            } else {
                System.out.println(s);
            }
        }
        if (this.pathOutput) {
            this.appendOutput(s);
            this.appendOutput('\n');
        }
    }

    public void print(boolean b) {
        if (this.treeOutput) {
            System.out.print(b);
        }
        if (this.pathOutput) {
            this.appendOutput(Boolean.toString(b));
        }
    }

    public void print(char c) {
        if (this.treeOutput) {
            System.out.print(c);
        }
        if (this.pathOutput) {
            this.appendOutput(c);
        }
    }

    public void print(int i) {
        if (this.treeOutput) {
            System.out.print(i);
        }
        if (this.pathOutput) {
            this.appendOutput(Integer.toString(i));
        }
    }

    public void print(long l) {
        if (this.treeOutput) {
            System.out.print(l);
        }
        if (this.pathOutput) {
            this.appendOutput(Long.toString(l));
        }
    }

    public void print(double d) {
        if (this.treeOutput) {
            System.out.print(d);
        }
        if (this.pathOutput) {
            this.appendOutput(Double.toString(d));
        }
    }

    public void print(float f) {
        if (this.treeOutput) {
            System.out.print(f);
        }
        if (this.pathOutput) {
            this.appendOutput(Float.toString(f));
        }
    }

    public void println() {
        if (this.treeOutput) {
            System.out.println();
        }
        if (this.pathOutput) {
            this.appendOutput('\n');
        }
    }

    void appendOutput(String s) {
        if (this.out == null) {
            this.out = new StringBuilder();
        }
        this.out.append(s);
    }

    void appendOutput(char c) {
        if (this.out == null) {
            this.out = new StringBuilder();
        }
        this.out.append(c);
    }

    public Instruction handleException(ThreadInfo ti, int xObjRef) {
        return null;
    }

    public void storeTrace(String fileName, String comment) {
        ChoicePoint.storeTrace(fileName, this.mainClassName, this.args, comment, this.ss.getChoiceGenerators());
    }

    public void storePathOutput() {
        this.pathOutput = true;
    }

    public ThreadInfo[] getLiveThreads() {
        int n = this.ss.getThreadCount();
        ThreadInfo[] list = new ThreadInfo[n];
        for (int i = 0; i < n; ++i) {
            list[i] = this.ss.getThreadInfo(i);
        }
        return list;
    }

    public void printLiveThreadStatus(PrintWriter pw) {
        int imax = this.ss.getThreadCount();
        int n = 0;
        for (int i = 0; i < imax; ++i) {
            ElementInfo ei;
            ThreadInfo ti = this.ss.getThreadInfo(i);
            List<StackFrame> stack = ti.getStack();
            if (stack.size() <= 0) continue;
            ++n;
            pw.println(ti.getStateDescription());
            LinkedList<ElementInfo> locks = ti.getLockedObjects();
            if (!locks.isEmpty()) {
                pw.print("  owned locks:");
                boolean first = true;
                for (ElementInfo e : locks) {
                    if (first) {
                        first = false;
                    } else {
                        pw.print(",");
                    }
                    pw.print(e);
                }
                pw.println();
            }
            if ((ei = ti.getLockObject()) != null) {
                if (ti.getStatus() == 4) {
                    pw.print("  waiting on: ");
                } else {
                    pw.print("  blocked on: ");
                }
                pw.println(ei);
            }
            pw.println("  call stack:");
            for (int j = stack.size() - 1; j >= 0; --j) {
                StackFrame frame = stack.get(j);
                if (frame.isDirectCallFrame()) continue;
                pw.print("\tat ");
                pw.println(frame.getStackTraceInfo());
            }
            pw.println();
        }
        if (n == 0) {
            pw.println("no live threads");
        }
    }

    void dumpThreadStates() {
        PrintWriter pw = new PrintWriter(System.out, true);
        this.printLiveThreadStatus(pw);
        pw.flush();
    }

    public boolean backtrack() {
        boolean success = this.backtracker.backtrack();
        if (success) {
            this.path.removeLast();
            this.lastTrailInfo = this.path.getLast();
            return this.ss.getId() != -1 || this.stateSet == null;
        }
        return false;
    }

    public void updatePath() {
        Transition t = this.ss.getTrail();
        Transition tLast = this.path.getLast();
        if (tLast != t) {
            if (this.out != null && this.out.length() > 0) {
                t.setOutput(this.out.toString());
                this.out.setLength(0);
            }
            this.path.add(t);
        }
    }

    public boolean forward() {
        try {
            block8: {
                block7: {
                    while (true) {
                        this.backtracker.pushKernelState();
                        this.lastTrailInfo = this.path.getLast();
                        if (!this.ss.nextSuccessor(this)) break block7;
                        if (!this.ss.isIgnored()) break;
                        this.backtracker.backtrackKernelState();
                    }
                    if (this.runGc && !this.hasPendingException()) {
                        this.ss.gcIfNeeded();
                    }
                    break block8;
                }
                this.backtracker.popKernelState();
                return false;
            }
            this.backtracker.pushSystemState();
            this.updatePath();
        }
        catch (UncaughtException e) {
            this.backtracker.pushSystemState();
            this.updatePath();
            return true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        if (this.stateSet != null) {
            this.newStateId = this.stateSet.size();
            int id = this.stateSet.addCurrent();
            this.ss.setId(id);
        } else {
            this.ss.setId(this.newStateId++);
        }
        return true;
    }

    public void printCurrentStackTrace() {
        ThreadInfo th = ThreadInfo.getCurrentThread();
        if (th != null) {
            th.printStackTrace();
        }
    }

    public void restoreState(VMState state) {
        if (state.path == null) {
            throw new JPFException("tried to restore partial VMState: " + state);
        }
        this.backtracker.restoreState(state.getBkState());
        this.path = state.path.clone();
    }

    public void activateGC() {
        this.ss.activateGC();
    }

    public void retainStateAttributes(boolean isRetained) {
        this.ss.retainAttributes(isRetained);
    }

    public void forceState() {
        this.ss.setForced(true);
    }

    public void ignoreState() {
        this.ss.setIgnored(true);
    }

    public boolean isNewState() {
        if (this.stateSet != null) {
            if (this.ss.isForced()) {
                return true;
            }
            if (this.ss.isIgnored()) {
                return false;
            }
            return this.newStateId == this.ss.getId();
        }
        return true;
    }

    public int getStateId() {
        return this.ss.getId();
    }

    public void addThread(ThreadInfo ti) {
        ThreadList tl = this.getThreadList();
        int idx = tl.add(ti);
        ti.setListInfo(tl, idx);
        this.getKernelState().changed();
    }

    public ThreadInfo createThread(int objRef) {
        ThreadInfo ti = ThreadInfo.createThreadInfo(this, objRef);
        return ti;
    }

    public static JVM getVM() {
        return jvm;
    }

    static void initStaticFields() {
        error_id = 0;
    }

    public DynamicArea getDynamicArea() {
        return this.ss.ks.da;
    }

    public ThreadInfo getCurrentThread() {
        return ThreadInfo.currentThread;
    }

    public StaticArea getStaticArea() {
        return this.ss.ks.sa;
    }

    public long getTime() {
        return 1L;
    }

    public void resetNextCG() {
        if (this.ss.nextCg != null) {
            this.ss.nextCg.reset();
        }
    }

    static {
        JVM.initStaticFields();
    }
}

