/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import org.apache.bcel.classfile.ConstantValue;

public class FloatFieldInfo
extends FieldInfo {
    float init;

    public FloatFieldInfo(String name, String type, int modifiers, ConstantValue cv, ClassInfo ci, int idx, int off) {
        super(name, type, modifiers, cv, ci, idx, off);
        this.init = cv != null ? Float.parseFloat(cv.toString()) : 0.0f;
    }

    @Override
    public void initialize(ElementInfo ei) {
        ei.getFields().setFloatValue(ei, this.storageOffset, this.init);
    }

    @Override
    public String valueToString(Fields f) {
        float v = f.getFloatValue(this.storageOffset);
        return Float.toString(v);
    }

    @Override
    public Object getValueObject(Fields f) {
        float v = f.getFloatValue(this.storageOffset);
        return new Float(v);
    }
}

