/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPF;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.EmptyFieldLockInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.util.logging.Logger;

public abstract class FieldLockInfo
implements Cloneable {
    static Logger log = JPF.getLogger("gov.nasa.jpf.jvm.FieldLockInfo");
    protected static final FieldLockInfo empty = new EmptyFieldLockInfo();
    ThreadInfo tiLastCheck;

    public abstract FieldLockInfo checkProtection(ThreadInfo var1, ElementInfo var2, FieldInfo var3);

    public abstract boolean isProtected();

    public abstract FieldLockInfo cleanUp();

    protected abstract int[] getCandidateLockSet();

    public boolean isFinal() {
        return this.isProtected();
    }

    public boolean needsPindown(ElementInfo ei) {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    void lockAssumptionFailed(ThreadInfo ti, ElementInfo ei, FieldInfo fi) {
        String src = ti.getMethod().getClassInfo().getSourceFileName();
        int line = ti.getLine();
        StringBuilder sb = new StringBuilder("unprotected field access of: ");
        sb.append(ei);
        sb.append('.');
        sb.append(fi.getName());
        sb.append(" in thread: ");
        sb.append(ti.getName());
        sb.append(" (");
        sb.append(src);
        sb.append(':');
        sb.append(line);
        sb.append(")\n[SEVERE].. last lock candidates: ");
        this.appendLockSet(sb, this.getCandidateLockSet());
        if (this.tiLastCheck != null) {
            sb.append(" set by ");
            sb.append(this.tiLastCheck);
        }
        sb.append("\n[SEVERE].. current locks: ");
        this.appendLockSet(sb, ti.getLockedObjectReferences());
        sb.append("\n[SEVERE].. if this is not a race, re-run with 'vm.por.sync_detection=false' or exclude field from checks");
        log.severe(sb.toString());
    }

    void appendLockSet(StringBuilder sb, int[] lockSet) {
        DynamicArea heap = DynamicArea.getHeap();
        if (lockSet == null || lockSet.length == 0) {
            sb.append("{}");
        } else {
            sb.append('{');
            int i = 0;
            while (i < lockSet.length) {
                int ref = lockSet[i];
                if (ref != -1) {
                    Object ei = heap.get(ref);
                    if (ei != null) {
                        sb.append(ei);
                    } else {
                        sb.append("?@");
                        sb.append(lockSet[i]);
                    }
                }
                if (++i >= lockSet.length) continue;
                sb.append(',');
            }
            sb.append('}');
        }
    }
}

