/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.Area;
import gov.nasa.jpf.jvm.ArrayFields;
import gov.nasa.jpf.jvm.ArrayIndexOutOfBoundsExecutiveException;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.FieldLockInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.Monitor;
import gov.nasa.jpf.jvm.Ref;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadChoiceGenerator;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.util.Debug;
import gov.nasa.jpf.util.HashData;
import java.io.PrintWriter;
import java.util.Vector;

public abstract class ElementInfo
implements Cloneable {
    protected Fields fields;
    protected Monitor monitor;
    protected Area<?> area;
    protected int index;
    public static final int ATTR_NONE = 0;
    public static final int ATTR_PROP_MASK = 65535;
    public static final int ATTR_TSHARED = 1;
    public static final int ATTR_IMMUTABLE = 2;
    public static final int ATTR_NO_PROMOTE = 4;
    public static final int ATTR_SINGLE_WRITER = 65536;
    public static final int ATTR_NO_PROPAGATE = 131072;
    public static final int ATTR_PROTECTED = 262144;
    public static final int ATTR_PINDOWN = 524288;
    protected int attributes;
    protected boolean fChanged = true;
    protected boolean mChanged = true;
    FieldLockInfo[] fLockInfo;

    public ElementInfo(Fields f, Monitor m) {
        this.fields = f;
        this.monitor = m;
        this.attributes = f.getClassInfo().getElementInfoAttrs();
    }

    protected ElementInfo() {
    }

    public String toString() {
        return this.getClassInfo().getName() + '@' + this.index;
    }

    public FieldLockInfo getFieldLockInfo(FieldInfo fi) {
        if (this.fLockInfo == null) {
            this.fLockInfo = new FieldLockInfo[this.getNumberOfFields()];
        }
        return this.fLockInfo[fi.getFieldIndex()];
    }

    public void setFieldLockInfo(FieldInfo fi, FieldLockInfo flInfo) {
        this.fLockInfo[fi.getFieldIndex()] = flInfo;
    }

    void cleanUp() {
        if (this.fLockInfo != null) {
            for (int i = 0; i < this.fLockInfo.length; ++i) {
                FieldLockInfo fli = this.fLockInfo[i];
                if (fli == null) continue;
                this.fLockInfo[i] = fli.cleanUp();
            }
        }
    }

    boolean hasRefField(int objRef) {
        return this.fields.hasRefField(objRef);
    }

    void setShared() {
        this.attributes |= 1;
    }

    void setShared(int attrMask) {
        this.attributes |= attrMask & 1;
    }

    void markRecursive(int tid, int attrMask) {
        DynamicArea heap = DynamicArea.getHeap();
        if (this.isArray()) {
            if (this.fields.isReferenceArray()) {
                int n = this.fields.arrayLength();
                for (int i = 0; i < n; ++i) {
                    heap.markRecursive(this.fields.getIntValue(i), tid, this.attributes, attrMask, null);
                }
            }
        } else {
            ClassInfo ci = this.getClassInfo();
            boolean isWeakRef = ci.isWeakReference();
            do {
                int n = ci.getNumberOfDeclaredInstanceFields();
                boolean isRef = isWeakRef && ci.isRefClass();
                for (int i = 0; i < n; ++i) {
                    FieldInfo fi = ci.getDeclaredInstanceField(i);
                    if (!fi.isReference()) continue;
                    if (i == 0 && isRef) {
                        heap.registerWeakReference(this.fields);
                        continue;
                    }
                    heap.markRecursive(this.fields.getReferenceValue(fi.getStorageOffset()), tid, this.attributes, attrMask, fi);
                }
            } while ((ci = ci.getSuperClass()) != null);
        }
    }

    void propagateAttributes(int refAttr, int attrMask) {
        this.attributes |= refAttr & attrMask & 0xFFFF;
    }

    int getAttributes() {
        return this.attributes;
    }

    public boolean isShared() {
        return (this.attributes & 1) != 0;
    }

    public boolean isImmutable() {
        return (this.attributes & 2) != 0;
    }

    public boolean isSchedulingRelevant() {
        return (this.attributes & 3) == 1;
    }

    protected boolean recycle() {
        if (this.hasVolatileFieldLockInfos()) {
            return false;
        }
        this.setArea(null);
        this.setIndex(-1);
        return true;
    }

    boolean hasVolatileFieldLockInfos() {
        if (this.fLockInfo != null) {
            for (int i = 0; i < this.fLockInfo.length; ++i) {
                FieldLockInfo fli = this.fLockInfo[i];
                if (fli == null || !fli.needsPindown(this)) continue;
                return true;
            }
        }
        return false;
    }

    protected void resurrect(Area<?> area, int index) {
        this.setArea(area);
        this.setIndex(index);
    }

    public boolean needsAttributePropagationFrom(ElementInfo ei) {
        int a = this.attributes;
        int o = ei.attributes;
        if (a != o) {
            if ((o & 0xFFFF) > (a & 0xFFFF)) {
                return true;
            }
            int i = 0;
            while (i < 16) {
                if ((o & 1) > (a & 1)) {
                    return true;
                }
                ++i;
                o >>= 1;
                a >>= 1;
            }
        }
        return false;
    }

    public void setArea(Area<?> newArea) {
        this.area = newArea;
    }

    public Area<?> getArea() {
        return this.area;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ElementInfo ei = (ElementInfo)other;
        return this.fields.equals(ei.fields);
    }

    public ClassInfo getClassInfo() {
        return this.fields.getClassInfo();
    }

    protected abstract FieldInfo getDeclaredFieldInfo(String var1, String var2);

    protected abstract ElementInfo getElementInfo(ClassInfo var1);

    protected abstract FieldInfo getFieldInfo(String var1);

    public boolean hasAttrs() {
        return this.fields.hasAttrs();
    }

    public void setFieldAttr(FieldInfo fi, Object attr) {
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        ei.cloneFields().setAttr(fi.getFieldIndex(), attr);
    }

    public void setFieldAttrNoClone(FieldInfo fi, Object attr) {
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        ei.fields.setAttr(fi.getFieldIndex(), attr);
    }

    public Object getFieldAttr(FieldInfo fi) {
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getAttr(fi.getFieldIndex());
    }

    public void setElementAttr(int idx, Object attr) {
        this.cloneFields().setAttr(idx, attr);
    }

    public void setElementAttrNoClone(int idx, Object attr) {
        this.fields.setAttr(idx, attr);
    }

    public Object getElementAttr(int idx) {
        return this.fields.getAttr(idx);
    }

    public abstract void setIntField(FieldInfo var1, int var2);

    public void setDeclaredIntField(String fname, String clsBase, int value) {
        this.setIntField(this.getDeclaredFieldInfo(clsBase, fname), value);
    }

    public void setBooleanField(String fname, boolean value) {
        this.setIntField(this.getFieldInfo(fname), value ? 1 : 0);
    }

    public void setIntField(String fname, int value) {
        this.setIntField(this.getFieldInfo(fname), value);
    }

    public void setDoubleField(String fname, double value) {
        this.setLongField(fname, Types.doubleToLong(value));
    }

    void updateReachability(int oldRef, int newRef) {
        ThreadInfo ti = ThreadInfo.getCurrentThread();
        if (ti == null || ti.isInCtor() || !ti.usePor()) {
            return;
        }
        if (oldRef != newRef) {
            Object nei;
            DynamicArea heap = DynamicArea.getHeap();
            if (this.isShared()) {
                Object nei2;
                Object oei;
                if (oldRef != -1 && !((ElementInfo)(oei = heap.get(oldRef))).isImmutable()) {
                    heap.analyzeHeap(false);
                    return;
                }
                if (newRef != -1 && !((ElementInfo)(nei2 = heap.get(newRef))).isShared() && !((ElementInfo)nei2).isImmutable()) {
                    ((ElementInfo)nei2).setShared();
                    heap.initGc();
                    ((ElementInfo)nei2).markRecursive(ti.getIndex(), 65535);
                }
            } else if (newRef != -1 && ((ElementInfo)(nei = heap.get(newRef))).isSchedulingRelevant()) {
                heap.analyzeHeap(false);
            }
        }
        if (oldRef != -1) {
            JVM.getVM().getSystemState().activateGC();
        }
    }

    public Object getFieldValueObject(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        if (fi != null) {
            return fi.getValueObject(this.fields);
        }
        return null;
    }

    public void setReferenceField(FieldInfo fi, int value) {
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        Fields f = ei.cloneFields();
        int off = fi.getStorageOffset();
        if (!fi.isReference()) {
            throw new JPFException("not a reference field: " + fi.getName());
        }
        int oldValue = f.getReferenceValue(off);
        f.setReferenceValue(this, off, value);
        this.updateReachability(oldValue, value);
    }

    public void setDeclaredReferenceField(String fname, String clsBase, int value) {
        this.setReferenceField(this.getDeclaredFieldInfo(clsBase, fname), value);
    }

    public void setReferenceField(String fname, int value) {
        this.setReferenceField(this.getFieldInfo(fname), value);
    }

    public int getDeclaredReferenceField(String fname, String clsBase) {
        FieldInfo fi = this.getDeclaredFieldInfo(clsBase, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        if (!fi.isReference()) {
            throw new JPFException("not a reference field: " + fi.getName());
        }
        return ei.fields.getIntValue(fi.getStorageOffset());
    }

    public int getReferenceField(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        if (!fi.isReference()) {
            throw new JPFException("not a reference field: " + fi.getName());
        }
        return ei.fields.getIntValue(fi.getStorageOffset());
    }

    public int getDeclaredIntField(String fname, String clsBase) {
        FieldInfo fi = this.getDeclaredFieldInfo(clsBase, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getIntValue(fi.getStorageOffset());
    }

    public int getIntField(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getIntValue(fi.getStorageOffset());
    }

    public void setDeclaredLongField(String fname, String clsBase, long value) {
        FieldInfo fi = this.getDeclaredFieldInfo(clsBase, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        ei.cloneFields().setLongValue(this, fi.getStorageOffset(), value);
    }

    public long getDeclaredLongField(String fname, String clsBase) {
        FieldInfo fi = this.getDeclaredFieldInfo(clsBase, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getLongValue(fi.getStorageOffset());
    }

    public long getLongField(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getLongValue(fi.getStorageOffset());
    }

    public boolean getDeclaredBooleanField(String fname, String refType) {
        FieldInfo fi = this.getDeclaredFieldInfo(refType, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getBooleanValue(fi.getStorageOffset());
    }

    public boolean getBooleanField(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getBooleanValue(fi.getStorageOffset());
    }

    public byte getDeclaredByteField(String fname, String refType) {
        FieldInfo fi = this.getDeclaredFieldInfo(refType, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getByteValue(fi.getStorageOffset());
    }

    public byte getByteField(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getByteValue(fi.getStorageOffset());
    }

    public char getDeclaredCharField(String fname, String refType) {
        FieldInfo fi = this.getDeclaredFieldInfo(refType, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getCharValue(fi.getStorageOffset());
    }

    public char getCharField(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getCharValue(fi.getStorageOffset());
    }

    public double getDeclaredDoubleField(String fname, String refType) {
        FieldInfo fi = this.getDeclaredFieldInfo(refType, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getDoubleValue(fi.getStorageOffset());
    }

    public double getDoubleField(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getDoubleValue(fi.getStorageOffset());
    }

    public float getDeclaredFloatField(String fname, String refType) {
        FieldInfo fi = this.getDeclaredFieldInfo(refType, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getFloatValue(fi.getStorageOffset());
    }

    public float getFloatField(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getFloatValue(fi.getStorageOffset());
    }

    public short getDeclaredShortField(String fname, String refType) {
        FieldInfo fi = this.getDeclaredFieldInfo(refType, fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getShortValue(fi.getStorageOffset());
    }

    public short getShortField(String fname) {
        FieldInfo fi = this.getFieldInfo(fname);
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        return ei.fields.getShortValue(fi.getStorageOffset());
    }

    private void checkFieldInfo(FieldInfo fi) {
        if (!this.getClassInfo().isInstanceOf(fi.getClassInfo())) {
            throw new JPFException("wrong FieldInfo : " + fi.getName() + " , no such field in " + this.getClassInfo().getName());
        }
    }

    public int getIntField(FieldInfo fi) {
        this.checkFieldInfo(fi);
        return this.fields.getIntValue(fi.getStorageOffset());
    }

    public int getReferenceField(FieldInfo fi) {
        return this.getIntField(fi);
    }

    public DynamicElementInfo getFieldDereference(FieldInfo fi) {
        assert (fi.isReference());
        return (DynamicElementInfo)this.area.ks.da.get(this.getIntField(fi));
    }

    public long getLongField(FieldInfo fi) {
        this.checkFieldInfo(fi);
        return this.fields.getLongValue(fi.getStorageOffset());
    }

    public void setLongField(FieldInfo fi, long value) {
        this.checkFieldInfo(fi);
        this.cloneFields().setLongValue(this, fi.getStorageOffset(), value);
    }

    public void setLongField(String fname, long value) {
        this.setLongField(this.getFieldInfo(fname), value);
    }

    public double getDoubleField(FieldInfo fi) {
        this.checkFieldInfo(fi);
        return this.fields.getDoubleValue(fi.getStorageOffset());
    }

    public float getFloatField(FieldInfo fi) {
        this.checkFieldInfo(fi);
        return this.fields.getFloatValue(fi.getStorageOffset());
    }

    public boolean getBooleanField(FieldInfo fi) {
        this.checkFieldInfo(fi);
        return this.fields.getBooleanValue(fi.getStorageOffset());
    }

    protected void checkArray(int index) {
        if (!this.isArray()) {
            throw new JPFException("cannot access non array objects by index");
        }
        if (index < 0 || index >= this.fields.size()) {
            throw new JPFException("illegal array offset: " + index);
        }
    }

    protected void checkLongArray(int index) {
        if (!this.isArray()) {
            throw new JPFException("cannot access non array objects by index");
        }
        if (index < 0 || index >= this.fields.size() - 1) {
            throw new JPFException("illegal long array offset: " + index);
        }
    }

    private boolean isReferenceArray() {
        return this.getClassInfo().isReferenceArray();
    }

    public void setElement(int fidx, int value) {
        this.checkArray(fidx);
        if (this.isReferenceArray()) {
            this.cloneFields().setReferenceValue(this, fidx, value);
        } else {
            this.cloneFields().setIntValue(this, fidx, value);
        }
    }

    public void setLongElement(int index, long value) {
        this.checkArray(index);
        this.cloneFields().setLongValue(this, index * 2, value);
    }

    public int getElement(int index) {
        this.checkArray(index);
        return this.fields.getIntValue(index);
    }

    public long getLongElement(int index) {
        this.checkArray(index);
        return this.fields.getLongValue(index * 2);
    }

    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public int getThisReference() {
        return this.index;
    }

    public int getLockCount() {
        return this.monitor.getLockCount();
    }

    public ThreadInfo getLockingThread() {
        return this.monitor.getLockingThread();
    }

    public boolean isLocked() {
        return this.monitor.getLockCount() > 0;
    }

    public boolean isArray() {
        return this.fields.isArray();
    }

    public String getArrayType() {
        if (!this.fields.isArray()) {
            throw new JPFException("object is not an array");
        }
        return Types.getArrayElementType(this.fields.getType());
    }

    public Object getBacktrackData() {
        return null;
    }

    public char getCharArrayElement(int index) {
        return (char)this.getElement(index);
    }

    public int getIntArrayElement(int findex) {
        return this.getElement(findex);
    }

    public long getLongArrayElement(int findex) {
        return this.getLongElement(findex);
    }

    public boolean[] asBooleanArray() {
        return this.fields.asBooleanArray();
    }

    public byte[] asByteArray() {
        return this.fields.asByteArray();
    }

    public short[] asShortArray() {
        return this.fields.asShortArray();
    }

    public char[] asCharArray() {
        return this.fields.asCharArray();
    }

    public int[] asIntArray() {
        return this.fields.asIntArray();
    }

    public long[] asLongArray() {
        return this.fields.asLongArray();
    }

    public float[] asFloatArray() {
        return this.fields.asFloatArray();
    }

    public double[] asDoubleArray() {
        return this.fields.asDoubleArray();
    }

    public boolean isNull() {
        return this.index == -1;
    }

    public ElementInfo getDeclaredObjectField(String fname, String referenceType) {
        return this.area.ks.da.get(this.getDeclaredIntField(fname, referenceType));
    }

    public ElementInfo getObjectField(String fname) {
        return this.area.ks.da.get(this.getIntField(fname));
    }

    public int getHeapSize() {
        return this.fields.getHeapSize();
    }

    public String getStringField(String fname) {
        int ref = this.getIntField(fname);
        if (ref != -1) {
            Object ei = this.area.ks.da.get(ref);
            if (ei == null) {
                System.out.println("OUTCH: " + ref + ", this: " + this.index);
                throw new NullPointerException();
            }
            return ((ElementInfo)ei).asString();
        }
        return "null";
    }

    public String getType() {
        return this.fields.getType();
    }

    public ThreadInfo[] getWaitingThreads() {
        int i;
        ThreadInfo[] locked = this.monitor.getLockedThreads();
        int n = 0;
        for (i = 0; i < locked.length; ++i) {
            if (!locked[i].isWaiting()) continue;
            ++n;
        }
        if (n == 0) {
            return Monitor.emptySet;
        }
        ThreadInfo[] waiters = new ThreadInfo[n];
        i = 0;
        int j = 0;
        while (j < n) {
            if (locked[i].isWaiting()) {
                waiters[j++] = locked[i];
            }
            ++i;
        }
        return waiters;
    }

    public int arrayLength() {
        return this.fields.arrayLength();
    }

    public String asString() {
        if (!this.fields.getClassInfo().isInstanceOf("java.lang.String")) {
            throw new JPFException("object is not of type java.lang.String");
        }
        int value = this.getDeclaredIntField("value", "java.lang.String");
        int length = this.getDeclaredIntField("count", "java.lang.String");
        int offset = this.getDeclaredIntField("offset", "java.lang.String");
        Object e = this.area.get(value);
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            sb.append((char)((ElementInfo)e).fields.getIntValue(i));
        }
        return sb.toString();
    }

    public boolean equalsString(String s) {
        if (!this.fields.getClassInfo().isInstanceOf("java.lang.String")) {
            return false;
        }
        int value = this.getDeclaredIntField("value", "java.lang.String");
        int length = this.getDeclaredIntField("count", "java.lang.String");
        int offset = this.getDeclaredIntField("offset", "java.lang.String");
        Object e = this.area.get(value);
        ArrayFields af = (ArrayFields)((ElementInfo)e).getFields();
        return af.equals(offset, length, s);
    }

    void updateLockingInfo() {
        ThreadInfo ti = this.monitor.getLockingThread();
        if (ti != null) {
            ti.addLockedObject(this);
        }
        if (this.monitor.hasLockedThreads()) {
            ThreadInfo[] lockedThreads = this.monitor.getLockedThreads();
            for (int i = 0; i < lockedThreads.length; ++i) {
                ti = lockedThreads[i];
                ti.setLockRef(this.index);
            }
        }
    }

    public boolean canLock(ThreadInfo th) {
        return this.monitor.canLock(th);
    }

    public void checkArrayBounds(int index) throws ArrayIndexOutOfBoundsExecutiveException {
        if (this.outOfBounds(index)) {
            throw new ArrayIndexOutOfBoundsExecutiveException(ThreadInfo.getCurrentThread().createAndThrowException("java.lang.ArrayIndexOutOfBoundsException", Integer.toString(index)));
        }
    }

    public void checkLongArrayBounds(int index) throws ArrayIndexOutOfBoundsExecutiveException {
        this.checkArrayBounds(index);
        this.checkArrayBounds(index + 1);
    }

    public Object clone() {
        try {
            ElementInfo ei = (ElementInfo)super.clone();
            if (ei.fChanged) {
                ei.fields = this.fields.clone();
            }
            if (ei.mChanged) {
                ei.monitor = this.monitor.clone();
            }
            ei.area = null;
            ei.index = -1;
            return ei;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new InternalError("should not happen");
        }
    }

    public void hash(HashData hd) {
        this.fields.hash(hd);
        this.monitor.hash(hd);
    }

    public int hashCode() {
        HashData hd = new HashData();
        this.hash(hd);
        return hd.getValue();
    }

    public boolean instanceOf(String type) {
        return Types.instanceOf(this.fields.getType(), type);
    }

    public abstract int getNumberOfFields();

    public abstract FieldInfo getFieldInfo(int var1);

    public void log() {
        if (this.fChanged) {
            Debug.println(2, "(fields have changed)");
        }
        int n = this.getNumberOfFields();
        for (int i = 0; i < n; ++i) {
            FieldInfo fi = this.getFieldInfo(i);
            Debug.println(2, fi.getName() + ": " + fi.valueToString(this.fields));
        }
        if (this.mChanged) {
            Debug.println(2, "(monitor has changed)");
        }
    }

    public void registerLockContender(ThreadInfo ti) {
        assert (ti.lockRef == -1 || ti.lockRef == this.index) : "thread " + ti + " trying to register for : " + this + " ,but already blocked on: " + this.area.get(ti.lockRef);
        this.setMonitorWithLocked(ti);
        ti.setLockRef(this.index);
    }

    public void unregisterLockContender(ThreadInfo ti) {
        this.setMonitorWithoutLocked(ti);
        ti.resetLockRef();
    }

    void blockLockContenders() {
        ThreadInfo[] lockedThreads = this.monitor.getLockedThreads();
        for (int i = 0; i < lockedThreads.length; ++i) {
            if (!lockedThreads[i].isRunnable()) continue;
            lockedThreads[i].setStatus(2);
        }
    }

    public void block(ThreadInfo ti) {
        assert (this.monitor.getLockingThread() != null && this.monitor.getLockingThread() != ti) : "attempt to block " + ti.getName() + " on unlocked or own locked object: " + this;
        this.setMonitorWithLocked(ti);
        ti.setLockRef(this.index);
        ti.setStatus(2);
    }

    public void lock(ThreadInfo ti) {
        assert (this.monitor.getLockingThread() == null || this.monitor.getLockingThread() == ti) : "locking: " + this + " by " + ti.getName() + " failed, lock owned by: " + this.monitor.getLockingThread().getName();
        this.setMonitorWithoutLocked(ti);
        this.monitor.setLockingThread(ti);
        this.monitor.incLockCount();
        ti.resetLockRef();
        if (ti.getStatus() == 3) {
            ti.setStatus(1);
        }
        if (this.monitor.getLockCount() == 1) {
            ti.addLockedObject(this);
        }
        this.blockLockContenders();
    }

    public void unlock(ThreadInfo ti) {
        assert (this.monitor.getLockCount() > 0 && this.monitor.getLockingThread() == ti) : "attempt of " + ti.getName() + " " + "to release non-owned lock for object: " + this;
        if (this.monitor.getLockCount() == 1) {
            ti.removeLockedObject(this);
            ThreadInfo[] lockedThreads = this.monitor.getLockedThreads();
            block4: for (int i = 0; i < lockedThreads.length; ++i) {
                switch (lockedThreads[i].getStatus()) {
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: {
                        lockedThreads[i].setStatus(3);
                        continue block4;
                    }
                    case 4: 
                    case 5: {
                        continue block4;
                    }
                    default: {
                        assert (false) : "Monitor.lockedThreads<->ThreadData.status inconsistency! " + lockedThreads[i].getStatusName();
                        continue block4;
                    }
                }
            }
            this.setMonitor();
            this.monitor.decLockCount();
            this.monitor.setLockingThread(null);
        } else {
            this.setMonitor();
            this.monitor.decLockCount();
        }
    }

    public void notifies(SystemState ss, ThreadInfo ti) {
        assert (this.monitor.getLockingThread() != null) : "notify on unlocked object: " + this;
        ThreadInfo[] locked = this.monitor.getLockedThreads();
        int nWaiters = 0;
        int iWaiter = 0;
        for (int i = 0; i < locked.length; ++i) {
            if (!locked[i].isWaiting()) continue;
            ++nWaiters;
            iWaiter = i;
        }
        if (nWaiters != 0) {
            if (nWaiters == 1) {
                locked[iWaiter].setStatus(6);
            } else {
                ChoiceGenerator<?> cg = ss.getChoiceGenerator();
                assert (cg != null && cg instanceof ThreadChoiceGenerator) : "notify " + this + " without ThreadChoiceGenerator: " + cg;
                ThreadInfo tiNotify = ((ThreadChoiceGenerator)cg).getNextChoice();
                tiNotify.setStatus(6);
            }
        }
        ti.getVM().notifyObjectNotifies(ti, this);
    }

    public void notifiesAll() {
        assert (this.monitor.getLockingThread() != null) : "notifyAll on unlocked object: " + this;
        ThreadInfo[] locked = this.monitor.getLockedThreads();
        for (int i = 0; i < locked.length; ++i) {
            locked[i].setStatus(6);
        }
        JVM.getVM().notifyObjectNotifiesAll(ThreadInfo.currentThread, this);
    }

    public void wait(ThreadInfo ti, long timeout) {
        assert (this.monitor.getLockingThread() == ti) : "wait on unlocked object: " + this;
        ti.setLockCount(this.monitor.getLockCount());
        this.setMonitorWithLocked(ti);
        this.monitor.setLockingThread(null);
        this.monitor.setLockCount(0);
        ti.removeLockedObject(this);
        ti.setLockRef(this.index);
        if (timeout == 0L) {
            ti.setStatus(4);
        } else {
            ti.setStatus(5);
        }
        ThreadInfo[] lockedThreads = this.monitor.getLockedThreads();
        for (int i = 0; i < lockedThreads.length; ++i) {
            switch (lockedThreads[i].getStatus()) {
                case 2: 
                case 6: 
                case 7: {
                    lockedThreads[i].setStatus(3);
                }
            }
        }
        ti.getVM().notifyObjectWait(ti, this);
    }

    public void lockNotified(ThreadInfo ti) {
        assert (ti.isUnblocked()) : "resume waiting thread " + ti.getName() + " which is not unblocked";
        this.setMonitorWithoutLocked(ti);
        this.monitor.setLockingThread(ti);
        this.monitor.setLockCount(ti.getLockCount());
        ti.setStatus(1);
        ti.setLockCount(0);
        ti.resetLockRef();
        this.blockLockContenders();
        ti.addLockedObject(this);
    }

    void dumpMonitor() {
        PrintWriter pw = new PrintWriter(System.out, true);
        pw.print("monitor ");
        this.monitor.printFields(pw);
        pw.flush();
    }

    public boolean outOfBounds(int index) {
        if (!this.fields.isArray()) {
            throw new JPFException("object is not an array");
        }
        return index < 0 || index >= this.fields.size();
    }

    public void pinDown(boolean keepAlive) {
        this.attributes = keepAlive ? (this.attributes |= 0x80000) : (this.attributes &= 0xFFF7FFFF);
    }

    public void restoreFields(Fields f) {
        this.fields = f;
    }

    public Fields getFields() {
        return this.fields;
    }

    public void restoreMonitor(Monitor m) {
        this.monitor = m;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void restoreAttributes(int a) {
        this.attributes = a;
    }

    public void markUnchanged() {
        this.fChanged = false;
        this.mChanged = false;
    }

    protected abstract Ref getRef();

    protected Fields cloneFields() {
        if (this.fChanged) {
            return this.fields;
        }
        this.fChanged = true;
        this.area.markChanged(this.index);
        this.fields = this.fields.clone();
        return this.fields;
    }

    void resetMonitorIndex() {
        this.mChanged = true;
        this.area.markChanged(this.index);
    }

    void setMonitor() {
        if (!this.mChanged) {
            this.resetMonitorIndex();
            this.monitor = this.monitor.clone();
        }
    }

    @Deprecated
    void setMonitorWithNoLocked() {
        if (this.mChanged) {
            this.monitor.resetLockedThreads();
        } else {
            this.resetMonitorIndex();
            this.monitor = this.monitor.cloneWithoutLocked();
        }
    }

    void setMonitorWithLocked(ThreadInfo ti) {
        if (this.mChanged) {
            this.monitor.addLocked(ti);
        } else {
            this.resetMonitorIndex();
            this.monitor = this.monitor.cloneWithLocked(ti);
        }
    }

    @Deprecated
    void setMonitorWithLocked(ThreadInfo[] ti) {
        if (this.mChanged) {
            this.monitor.setLocked(ti);
        } else {
            this.resetMonitorIndex();
            this.monitor = this.monitor.cloneWithLocked(ti);
        }
    }

    void setMonitorWithoutLocked(ThreadInfo ti) {
        if (this.mChanged) {
            this.monitor.removeLocked(ti);
        } else {
            this.resetMonitorIndex();
            this.monitor = this.monitor.cloneWithoutLocked(ti);
        }
    }

    boolean isLockedBy(ThreadInfo ti) {
        return this.monitor != null && this.monitor.getLockingThread() == ti;
    }

    void _printAttributes(String cls, String msg, int oldAttrs) {
        if (this.getClassInfo().getName().equals(cls)) {
            System.out.println(msg + " " + this + " attributes: " + Integer.toHexString(this.attributes) + " was: " + Integer.toHexString(oldAttrs));
        }
    }

    public Vector<String> linearize(Vector<String> result) {
        DynamicArea heap = DynamicArea.getHeap();
        if (this.isArray()) {
            if (this.fields.isReferenceArray()) {
                int n = this.fields.arrayLength();
                for (int i = 0; i < n; ++i) {
                    result = heap.linearize(this.fields.getIntValue(i), result);
                }
            }
        } else {
            ClassInfo ci = this.getClassInfo();
            do {
                int n = ci.getNumberOfDeclaredInstanceFields();
                for (int i = 0; i < n; ++i) {
                    FieldInfo fi = ci.getDeclaredInstanceField(i);
                    if (!fi.isReference()) continue;
                    if (i == 0 && ci.isWeakReference()) {
                        return result;
                    }
                    result = heap.linearize(this.fields.getReferenceValue(fi.getStorageOffset()), result);
                }
            } while ((ci = ci.getSuperClass()) != null);
        }
        return result;
    }

    void verifyLockInfo(ThreadList tl) {
        ThreadInfo ti = this.monitor.getLockingThread();
        if (ti != null) {
            assert (this.area.ks.tl.get(ti.index) == ti);
            assert (ti.lockedObjects.contains(this));
        }
        if (this.monitor.hasLockedThreads()) {
            ThreadInfo[] lockedThreads = this.monitor.getLockedThreads();
            for (int i = 0; i < lockedThreads.length; ++i) {
                ti = lockedThreads[i];
                assert (this.area.ks.tl.get(ti.index) == ti);
                assert (ti.lockRef == this.index);
            }
        }
    }
}

