/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;

public class DynamicFields
extends Fields {
    public DynamicFields(String t, ClassInfo ci) {
        super(t, ci, ci.getInstanceDataSize());
    }

    public FieldInfo getDeclaredFieldInfo(String fname) {
        return this.ci.getDeclaredInstanceField(fname);
    }

    public FieldInfo getFieldInfo(String fname) {
        return this.ci.getInstanceField(fname);
    }

    @Override
    public int getNumberOfFields() {
        return this.ci.getNumberOfInstanceFields();
    }

    @Override
    public FieldInfo getFieldInfo(int fieldIndex) {
        return this.ci.getInstanceField(fieldIndex);
    }

    @Override
    public String getLogChar() {
        return "#";
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DynamicFields)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected FieldInfo findFieldInfo(int storageOffset) {
        int length;
        for (int i = length = Math.min(storageOffset, this.ci.getNumberOfInstanceFields() - 1); i >= 0; --i) {
            FieldInfo fi = this.ci.getInstanceField(i);
            if (fi.getStorageOffset() != storageOffset) continue;
            return fi;
        }
        return null;
    }
}

