/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.Area;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.DynamicMapIndex;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.Monitor;
import gov.nasa.jpf.jvm.PredicateMap;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.INVOKECLINIT;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.util.Debug;
import gov.nasa.jpf.util.IntTable;
import gov.nasa.jpf.util.IntVector;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Vector;

public class DynamicArea
extends Area<DynamicElementInfo> {
    static DynamicArea heap;
    final BitSet isUsed = new BitSet();
    final BitSet isRoot = new BitSet();
    final IntVector refThread = new IntVector();
    final IntVector lastAttrs = new IntVector();
    boolean runFinalizer;
    boolean sweep;
    int markLevel;
    boolean outOfMemory;
    private ArrayList<Fields> weakRefs;
    private final IntTable<DynamicMapIndex> dynamicMap = new IntTable();
    HashMap<String, InternStringEntry> internStrings = new HashMap();
    private IntTable<String> object2Value;
    private int lincount;
    private PredicateMap pMap = null;

    public static void init(Config config) {
    }

    public DynamicArea(Config config, KernelState ks) {
        super(ks);
        this.runFinalizer = config.getBoolean("vm.finalize", true);
        this.sweep = config.getBoolean("vm.sweep", true);
        heap = this;
    }

    public static DynamicArea getHeap() {
        return heap;
    }

    public int getHeapSize() {
        int n = 0;
        for (DynamicElementInfo ei : this) {
            n += ei.getHeapSize();
        }
        return n;
    }

    public boolean getOutOfMemory() {
        return this.outOfMemory;
    }

    public void setOutOfMemory(boolean isOutOfMemory) {
        this.outOfMemory = isOutOfMemory;
    }

    public void setSweep(boolean b) {
        this.sweep = b;
    }

    public void gc() {
        this.analyzeHeap(this.sweep);
    }

    public void analyzeHeap(boolean sweep) {
        ElementInfo ei;
        int i;
        int length = this.elements.size();
        this.weakRefs = null;
        JVM.getVM().notifyGCBegin();
        this.initGc();
        for (i = 0; i < length; ++i) {
            ei = (ElementInfo)this.elements.get(i);
            if (ei == null) continue;
            this.lastAttrs.set(i, ei.attributes);
            ei.attributes &= 0xFFFF0000;
            if ((ei.attributes & 0x80000) == 0) continue;
            this.markPinnedDown(i);
        }
        this.ks.tl.markRoots();
        this.ks.sa.markRoots();
        for (i = 0; i < length; ++i) {
            if (!this.isRoot.get(i)) continue;
            this.markRecursive(i);
        }
        if (sweep && this.runFinalizer) {
            for (i = 0; i < length; ++i) {
                ei = (ElementInfo)this.elements.get(i);
                if (ei != null && this.isUsed.get(i)) continue;
            }
        }
        int count = 0;
        for (i = 0; i < length; ++i) {
            ei = (ElementInfo)this.elements.get(i);
            if (ei == null) continue;
            if (this.isUsed.get(i)) {
                if (this.lastAttrs.get(i) == ei.attributes) continue;
                this.markChanged(i);
                continue;
            }
            if (!sweep) continue;
            ++count;
            JVM.getVM().notifyObjectReleased(ei);
            this.remove(i, false);
        }
        if (sweep) {
            this.ks.tl.sweepTerminated(this.isUsed);
            this.checkWeakRefs();
        }
        JVM.getVM().notifyGCEnd();
    }

    void initGc() {
        this.isRoot.clear();
        this.isUsed.clear();
    }

    void logMark(FieldInfo fi, ElementInfo ei, int tid, int attrMask) {
        for (int i = 0; i <= this.markLevel; ++i) {
            System.out.print("    ");
        }
        if (fi != null) {
            System.out.print('\'');
            System.out.print(fi.getName());
            System.out.print("': ");
        }
        System.out.print(ei);
        System.out.print(" ,attr:");
        System.out.print(Integer.toHexString(ei.attributes));
        System.out.print(" ,mask:");
        System.out.print(Integer.toHexString(attrMask));
        System.out.print(" ,thread:");
        System.out.print(tid);
        System.out.print("/");
        System.out.print(this.refThread.get(ei.index));
        System.out.print(" ");
        if (this.isRoot.get(ei.index)) {
            System.out.print("R");
        }
        if (this.isUsed.get(ei.index)) {
            System.out.print("V");
        }
        System.out.println();
    }

    void markRecursive(int objref) {
        int tid = this.refThread.get(objref);
        ElementInfo ei = (ElementInfo)this.elements.get(objref);
        int attrMask = 65535;
        this.markLevel = 0;
        ei.markRecursive(tid, attrMask);
    }

    void markRecursive(int objref, int refTid, int refAttr, int attrMask, FieldInfo fi) {
        if (objref == -1) {
            return;
        }
        ElementInfo ei = (ElementInfo)this.elements.get(objref);
        if (fi != null) {
            attrMask &= fi.getAttributes();
        }
        ++this.markLevel;
        if (this.isUsed.get(objref)) {
            int attrs = ei.getAttributes();
            if (!ei.isShared() && refTid != this.refThread.get(objref)) {
                ei.setShared(attrMask);
            }
            ei.propagateAttributes(refAttr, attrMask);
            if (ei.getAttributes() != attrs) {
                if (this.isRoot.get(objref)) {
                    this.isRoot.clear(objref);
                }
                ei.markRecursive(refTid, attrMask);
            }
        } else {
            this.isUsed.set(objref);
            this.refThread.set(objref, refTid);
            ei.propagateAttributes(refAttr, attrMask);
            ei.markRecursive(refTid, attrMask);
        }
        --this.markLevel;
    }

    void markThreadRoot(int objref, int tid) {
        if (objref == -1) {
            return;
        }
        if (this.isRoot.get(objref)) {
            int rt = this.refThread.get(objref);
            if (rt != tid && rt != -1) {
                ((DynamicElementInfo)this.elements.get(objref)).setShared();
            }
        } else {
            this.isRoot.set(objref);
            this.refThread.set(objref, tid);
            this.isUsed.set(objref);
        }
    }

    void markStaticRoot(int objref) {
        if (objref == -1) {
            return;
        }
        this.isRoot.set(objref);
        this.refThread.set(objref, -1);
        this.isUsed.set(objref);
        ((DynamicElementInfo)this.elements.get(objref)).setShared();
    }

    void markPinnedDown(int objref) {
        this.isRoot.set(objref);
        this.refThread.set(objref, -1);
        this.isUsed.set(objref);
    }

    public boolean isSchedulingRelevantObject(int objRef) {
        if (objRef == -1) {
            return false;
        }
        return ((DynamicElementInfo)this.elements.get(objRef)).isSchedulingRelevant();
    }

    public void log() {
        Debug.println(2, "DA");
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i) == null) continue;
            ((DynamicElementInfo)this.elements.get(i)).log();
        }
    }

    public int newArray(String elementType, int nElements, ThreadInfo ti) {
        String type = "[" + elementType;
        ClassInfo ci = ClassInfo.getClassInfo(type);
        if (!ci.isInitialized()) {
            StaticArea sa = StaticArea.getStaticArea();
            sa.addClass(ci, ti);
            ci.setInitialized();
        }
        int idx = this.indexFor(ti);
        Fields f = ci.createArrayFields(type, nElements, Types.getTypeSize(elementType), Types.isReference(elementType));
        Monitor m = new Monitor();
        DynamicElementInfo e = new DynamicElementInfo(f, m);
        this.add(idx, e);
        if (ti != null) {
            JVM.getVM().notifyObjectCreated(ti, (ElementInfo)this.elements.get(idx));
        }
        return idx;
    }

    public int newObject(ClassInfo ci, ThreadInfo th) {
        Fields f = ci.createInstanceFields();
        Monitor m = new Monitor();
        DynamicElementInfo dei = new DynamicElementInfo(f, m);
        int index = this.indexFor(th);
        this.add(index, dei);
        ci.initializeInstanceData(dei);
        if (th != null) {
            JVM.getVM().notifyObjectCreated(th, dei);
        }
        return index;
    }

    public int newString(String str, ThreadInfo th) {
        int length = str.length();
        int index = this.newObject(ClassInfo.stringClassInfo, th);
        int value = this.newArray("C", length, th);
        Object e = this.get(index);
        ((ElementInfo)e).setReferenceField("value", value);
        ((ElementInfo)e).setIntField("offset", 0);
        ((ElementInfo)e).setIntField("count", length);
        e = this.get(value);
        for (int i = 0; i < length; ++i) {
            ((ElementInfo)e).setElement(i, str.charAt(i));
        }
        return index;
    }

    boolean checkInternStringEntry(InternStringEntry e) {
        int vref;
        Object ei = this.get(e.ref);
        return ei != null && ((ElementInfo)ei).getClassInfo() == ClassInfo.stringClassInfo && (ei = this.get(vref = ((ElementInfo)ei).getReferenceField("value"))) != null && ((ElementInfo)ei).getFields() == e.fValue;
    }

    public int newInternString(String str, ThreadInfo ti) {
        int ref = -1;
        InternStringEntry e = this.internStrings.get(str);
        if (e == null || !this.checkInternStringEntry(e)) {
            ref = this.newString(str, ti);
            Object ei = this.get(ref);
            ((ElementInfo)ei).pinDown(true);
            int vref = ((ElementInfo)ei).getReferenceField("value");
            ei = this.get(vref);
            this.internStrings.put(str, new InternStringEntry(str, ref, ((ElementInfo)ei).getFields()));
            return ref;
        }
        return e.ref;
    }

    void checkWeakRefs() {
        if (this.weakRefs != null) {
            int len = this.weakRefs.size();
            for (int i = 0; i < len; ++i) {
                ElementInfo ei;
                Fields f = this.weakRefs.get(i);
                int ref = f.getIntValue(0);
                if (ref == -1 || (ei = (ElementInfo)this.elements.get(ref)) != null && !ei.isNull()) continue;
                f.setReferenceValue(ei, 0, -1);
            }
            this.weakRefs = null;
        }
    }

    @Override
    DynamicElementInfo createElementInfo() {
        return new DynamicElementInfo();
    }

    void registerWeakReference(Fields f) {
        if (this.weakRefs == null) {
            this.weakRefs = new ArrayList();
        }
        this.weakRefs.add(f);
    }

    public int getNext(ClassInfo ci, int idx) {
        int n = this.elements.size();
        for (int i = idx; i < n; ++i) {
            ElementInfo ei = (ElementInfo)this.elements.get(i);
            if (ei == null || !ei.getClassInfo().isInstanceOf(ci)) continue;
            return i;
        }
        return -1;
    }

    private int indexFor(ThreadInfo th) {
        int index;
        Instruction pc = null;
        if (th != null) {
            int pos = th.countStackFrames();
            while (pc instanceof INVOKECLINIT && pos > 0) {
                pc = th.getPC(--pos);
            }
        }
        DynamicMapIndex dmi = new DynamicMapIndex(pc, th == null ? 0 : th.index, 0);
        while (true) {
            int newIdx = this.dynamicMap.nextPoolVal();
            IntTable.Entry<DynamicMapIndex> e = this.dynamicMap.pool(dmi);
            index = e.val;
            if (index == newIdx || this.elements.get(index) == null) break;
            dmi.next();
        }
        return index;
    }

    public Vector<String> linearizeRoot(int objref) {
        this.object2Value = new IntTable();
        this.lincount = 0;
        Vector<String> result = new Vector<String>();
        return this.linearize(objref, result);
    }

    public Vector<String> linearizeRoot(int objref, PredicateMap obj) {
        this.object2Value = new IntTable();
        this.lincount = 0;
        Vector<String> result = new Vector<String>();
        this.pMap = obj;
        return this.linearize(objref, result);
    }

    public Vector<String> linearize(int objref, Vector<String> result) {
        PredicateMap mapObj = this.pMap;
        if (objref == -1) {
            result.addElement("-1");
            return result;
        }
        if (mapObj == null) {
            mapObj = new StructureMap();
        }
        mapObj.setRef(objref);
        String refRep = "" + mapObj.getRef();
        if (this.object2Value.hasEntry(refRep)) {
            String objRep = "" + this.object2Value.get((String)refRep).val;
            result.addElement(objRep);
            return result;
        }
        this.object2Value.add(refRep, this.lincount);
        mapObj.evaluate();
        String objRep = "" + this.lincount + mapObj.getRep();
        ++this.lincount;
        result.addElement(objRep);
        ElementInfo ei = (ElementInfo)this.elements.get(objref);
        return ei.linearize(result);
    }

    void verifyLockInfo() {
        for (DynamicElementInfo dei : this.elements) {
            if (dei == null) continue;
            dei.verifyLockInfo(this.ks.tl);
        }
    }

    static class StructureMap
    extends PredicateMap {
        StructureMap() {
        }

        @Override
        public void evaluate() {
        }

        @Override
        public String getRep() {
            return "";
        }
    }

    static class InternStringEntry {
        String str;
        int ref;
        Fields fValue;

        InternStringEntry(String str, int ref, Fields fValue) {
            this.str = str;
            this.ref = ref;
            this.fValue = fValue;
        }
    }
}

