/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import org.apache.bcel.classfile.ConstantValue;

public class DoubleFieldInfo
extends FieldInfo {
    double init;

    public DoubleFieldInfo(String name, String type, int modifiers, ConstantValue cv, ClassInfo ci, int idx, int off) {
        super(name, type, modifiers, cv, ci, idx, off);
        this.init = cv != null ? Double.parseDouble(cv.toString()) : 0.0;
    }

    @Override
    public void initialize(ElementInfo ei) {
        ei.getFields().setDoubleValue(ei, this.storageOffset, this.init);
    }

    @Override
    public int getStorageSize() {
        return 2;
    }

    @Override
    public String valueToString(Fields f) {
        double d = f.getDoubleValue(this.storageOffset);
        return Double.toString(d);
    }

    @Override
    public Object getValueObject(Fields f) {
        double d = f.getDoubleValue(this.storageOffset);
        return new Double(d);
    }
}

