/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.SchedulerFactory;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.jvm.choice.ThreadChoiceFromSet;

public class DefaultSchedulerFactory
implements SchedulerFactory {
    protected JVM vm;
    protected SystemState ss;
    boolean breakAll;

    public DefaultSchedulerFactory(Config config, JVM vm, SystemState ss) {
        this.vm = vm;
        this.ss = ss;
        this.breakAll = config.getBoolean("cg.threads.break_all", false);
    }

    protected ThreadInfo[] filter(ThreadInfo[] list) {
        return list;
    }

    protected ChoiceGenerator<ThreadInfo> getRunnableCG() {
        ThreadInfo[] choices = this.getRunnablesIfChoices();
        if (choices != null) {
            return new ThreadChoiceFromSet(choices, true);
        }
        return null;
    }

    protected ChoiceGenerator<ThreadInfo> getSyncCG(ElementInfo ei, ThreadInfo ti) {
        return this.getRunnableCG();
    }

    protected ThreadInfo[] getRunnables() {
        ThreadList tl = this.vm.getThreadList();
        return this.filter(tl.getRunnableThreads());
    }

    protected ThreadInfo[] getRunnablesIfChoices() {
        ThreadList tl = this.vm.getThreadList();
        if (tl.getRunnableThreadCount() > 1) {
            return this.filter(tl.getRunnableThreads());
        }
        return null;
    }

    protected ThreadInfo[] getRunnablesWith(ThreadInfo ti) {
        ThreadList tl = this.vm.getThreadList();
        return this.filter(tl.getRunnableThreadsWith(ti));
    }

    protected ThreadInfo[] getRunnablesWithout(ThreadInfo ti) {
        ThreadList tl = this.vm.getThreadList();
        return this.filter(tl.getRunnableThreadsWithout(ti));
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createSyncMethodEnterCG(ElementInfo ei, ThreadInfo ti) {
        return this.createMonitorEnterCG(ei, ti);
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createSyncMethodExitCG(ElementInfo ei, ThreadInfo ti) {
        return null;
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createMonitorEnterCG(ElementInfo ei, ThreadInfo ti) {
        if (ti.isBlocked()) {
            if (this.ss.isAtomic()) {
                this.ss.setBlockedInAtomicSection();
            }
            return new ThreadChoiceFromSet(this.getRunnables(), true);
        }
        if (this.ss.isAtomic()) {
            return null;
        }
        return this.getSyncCG(ei, ti);
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createMonitorExitCG(ElementInfo ei, ThreadInfo ti) {
        return null;
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createWaitCG(ElementInfo ei, ThreadInfo ti, long timeOut) {
        if (this.ss.isAtomic()) {
            this.ss.setBlockedInAtomicSection();
        }
        return new ThreadChoiceFromSet(this.getRunnables(), true);
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createNotifyCG(ElementInfo ei, ThreadInfo ti) {
        if (this.ss.isAtomic()) {
            return null;
        }
        ThreadInfo[] waiters = ei.getWaitingThreads();
        if (waiters.length < 2) {
            return null;
        }
        return new ThreadChoiceFromSet(waiters, false);
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createNotifyAllCG(ElementInfo ei, ThreadInfo ti) {
        return null;
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createSharedFieldAccessCG(ElementInfo ei, ThreadInfo ti) {
        if (this.ss.isAtomic()) {
            return null;
        }
        return this.getSyncCG(ei, ti);
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createSharedArrayAccessCG(ElementInfo ei, ThreadInfo ti) {
        if (this.ss.isAtomic()) {
            return null;
        }
        return this.getSyncCG(ei, ti);
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createThreadStartCG(ThreadInfo newThread) {
        if (this.breakAll) {
            if (this.ss.isAtomic()) {
                return null;
            }
            return this.getRunnableCG();
        }
        return null;
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createThreadYieldCG(ThreadInfo yieldThread) {
        if (this.breakAll) {
            if (this.ss.isAtomic()) {
                return null;
            }
            return this.getRunnableCG();
        }
        return null;
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createInterruptCG(ThreadInfo interruptedThread) {
        if (this.ss.isAtomic()) {
            return null;
        }
        return this.getRunnableCG();
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createThreadSleepCG(ThreadInfo sleepThread, long millis, int nanos) {
        if (this.breakAll) {
            if (this.ss.isAtomic()) {
                return null;
            }
            return this.createThreadYieldCG(sleepThread);
        }
        return null;
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createThreadTerminateCG(ThreadInfo terminateThread) {
        ThreadList tl = this.vm.getThreadList();
        if (tl.hasAnyAliveThread()) {
            return new ThreadChoiceFromSet(this.getRunnablesWithout(terminateThread), true);
        }
        return null;
    }
}

