/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.Backtracker;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.StateRestorer;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.util.StackNode;

public class DefaultBacktracker<KState>
implements Backtracker {
    protected StackNode<KState> kstack;
    protected StackNode<Object> sstack;
    protected SystemState ss;
    protected StateRestorer<KState> restorer;

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        this.ss = jvm.getSystemState();
        this.restorer = jvm.getRestorer();
    }

    @Override
    public void backtrackKernelState() {
        Object data = this.kstack.data;
        this.kstack = this.kstack.next;
        this.restorer.restore(data);
    }

    public void backtrackSystemState() {
        Object o = this.sstack.data;
        this.sstack = this.sstack.next;
        this.ss.backtrackTo(o);
    }

    @Override
    public boolean backtrack() {
        if (this.sstack != null) {
            this.backtrackKernelState();
            this.backtrackSystemState();
            return true;
        }
        return false;
    }

    @Override
    public void popKernelState() {
        this.kstack = this.kstack.next;
    }

    @Override
    public void pushKernelState() {
        this.kstack = new StackNode<KState>(this.restorer.getRestorableData(), this.kstack);
    }

    @Override
    public void pushSystemState() {
        this.sstack = new StackNode<Object>(this.ss.getBacktrackData(), this.sstack);
    }

    @Override
    public void restoreState(Backtracker.State state) {
        ((StateImpl)state).restore();
    }

    @Override
    public Backtracker.State getState() {
        return new StateImpl();
    }

    class StateImpl
    implements Backtracker.State {
        final StackNode<KState> savedKstack;
        final StackNode<Object> savedSstack;
        final KState kcur;
        final Object scur;

        StateImpl() {
            this.savedKstack = DefaultBacktracker.this.kstack;
            this.savedSstack = DefaultBacktracker.this.sstack;
            this.kcur = DefaultBacktracker.this.restorer.getRestorableData();
            this.scur = DefaultBacktracker.this.ss.getBacktrackData();
        }

        void restore() {
            DefaultBacktracker.this.kstack = this.savedKstack;
            DefaultBacktracker.this.sstack = this.savedSstack;
            DefaultBacktracker.this.restorer.restore(this.kcur);
            DefaultBacktracker.this.ss.restoreTo(this.scur);
        }
    }
}

