/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.Attributor;
import gov.nasa.jpf.util.StringSetMatcher;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class DefaultAttributor
implements Attributor {
    static StringSetMatcher neverBreak;
    static StringSetMatcher breakShared;

    public DefaultAttributor(Config conf) {
        String[] val = conf.getStringArray("vm.por.field_boundaries.never");
        if (val != null) {
            neverBreak = new StringSetMatcher(val);
        }
        if (conf.getBoolean("vm.por.field_boundaries") && (val = conf.getStringArray("vm.por.field_boundaries.break")) != null) {
            breakShared = new StringSetMatcher(val);
        }
    }

    @Override
    public boolean isMethodAtomic(JavaClass jc, Method mth, String uniqueName) {
        if (jc.getPackageName().startsWith("java.")) {
            String clsName = jc.getClassName();
            return !(clsName.equals("java.lang.Object") ? uniqueName.startsWith("wait(") || uniqueName.equals("notify()V") : clsName.equals("java.lang.Thread") && uniqueName.equals("join()V"));
        }
        return false;
    }

    @Override
    public int getObjectAttributes(JavaClass jc) {
        String clsName = jc.getClassName();
        if (clsName.equals("java.lang.String") || clsName.equals("java.lang.Integer") || clsName.equals("java.lang.Long") || clsName.equals("java.lang.Class")) {
            return 2;
        }
        return 0;
    }

    @Override
    public int getFieldAttributes(JavaClass jc, Field f) {
        int attr = 65535;
        String fid = jc.getClassName() + '.' + f.getName();
        if (fid.equals("java.lang.ThreadGroup.threads")) {
            attr &= 0xFFFFFFFE;
        }
        if (f.isFinal()) {
            attr |= 2;
        }
        if (neverBreak != null && neverBreak.matchesAny(fid)) {
            attr |= 0x10000;
        }
        if (breakShared != null && breakShared.matchesAny(fid)) {
            attr |= 0x20000;
        }
        return attr;
    }
}

