/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ArrayOffset;
import gov.nasa.jpf.jvm.CachingSerializerDeserializer;
import gov.nasa.jpf.jvm.CollapsePools;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadData;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.Misc;
import java.util.Iterator;

public class CollapsingSerializer
extends CachingSerializerDeserializer {
    protected final CollapsePools.AllIndexed pool = new CollapsePools.AllIndexed();
    protected static final int daDelta = 3;
    protected static final int[] daZeros = new int[3];
    protected static final int saDelta = 5;
    protected static final int[] saZeros = new int[5];

    @Override
    protected void updateThreadCache(ThreadInfo ti, CachingSerializerDeserializer.TCacheEntry entry) {
        int firstChanged;
        IntVector cache = entry.cache;
        int length = ti.stack.size();
        if (ti.tdChanged || ti != entry.ti) {
            cache.set(0, this.pool.getThreadDataIndex(ti));
        }
        cache.set(1, length);
        int cStart = 2;
        if (ti == entry.ti) {
            firstChanged = ti.hasChanged.isEmpty() ? length : ti.hasChanged.nextSetBit(0);
        } else {
            firstChanged = 0;
            entry.ti = ti;
        }
        cache.setSize(2 + firstChanged);
        for (int i = firstChanged; i < length; ++i) {
            cache.add(this.pool.getStackFrameIndex(ti.stack.get(i)));
        }
        ti.markUnchanged();
    }

    @Override
    protected void updateDynamicAreaCache(DynamicArea area) {
        if (area.anyChanged()) {
            int length = area.getLength();
            this.daCache.set(0, length);
            int i = 0;
            while ((i = area.getNextChanged(i)) >= 0) {
                int j = i * 3 + 1;
                DynamicElementInfo ei = (DynamicElementInfo)area.get(i);
                if (ei != null) {
                    this.daCache.set(j + 0, this.pool.getFieldsIndex(ei));
                    this.daCache.set(j + 1, this.pool.getMonitorIndex(ei));
                    this.daCache.set(j + 2, ei.getAttributes());
                    ei.markUnchanged();
                } else {
                    IntVector.copy(daZeros, 0, this.daCache, j, 3);
                }
                ++i;
            }
            this.daCache.setSize(length * 3 + 1);
            area.markUnchanged();
        }
    }

    @Override
    protected void updateStaticAreaCache(StaticArea area) {
        if (area.anyChanged()) {
            int length = area.getLength();
            this.saCache.set(0, length);
            int i = 0;
            while ((i = area.getNextChanged(i)) >= 0) {
                int j = i * 5 + 1;
                StaticElementInfo ei = (StaticElementInfo)area.get(i);
                if (ei != null) {
                    this.saCache.set(j + 0, this.pool.getFieldsIndex(ei));
                    this.saCache.set(j + 1, this.pool.getMonitorIndex(ei));
                    this.saCache.set(j + 2, ei.getAttributes());
                    this.saCache.set(j + 3, ei.getClassObjectRef());
                    this.saCache.set(j + 4, ei.getStatus());
                    ei.markUnchanged();
                } else {
                    IntVector.copy(saZeros, 0, this.saCache, j, 5);
                }
                ++i;
            }
            this.saCache.setSize(length * 5 + 1);
            area.markUnchanged();
        }
    }

    @Override
    protected ThreadInfo restoreThreadInfo(final ArrayOffset storing, CachingSerializerDeserializer.TCacheEntry entry) {
        int tdIdx = storing.get();
        ThreadData td = this.pool.getThreadDataAt(tdIdx);
        int objRef = td.objref;
        ThreadInfo ti = ThreadInfo.threadInfos.get(objRef);
        ti.resetVolatiles();
        ti.restoreThreadData(td);
        final int length = storing.get();
        Iterator<StackFrame> iter = new Iterator<StackFrame>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < length;
            }

            @Override
            public StackFrame next() {
                ++this.i;
                return CollapsingSerializer.this.pool.getStackFrameAt(storing.get());
            }

            @Override
            public void remove() {
            }
        };
        ti.replaceStackFrames(Misc.iterableFromIterator(iter));
        ti.markUnchanged();
        int dataLen = length + 2;
        entry.ti = ti;
        entry.cache.clear();
        entry.cache.append(storing.data, storing.offset - dataLen, dataLen);
        return ti;
    }

    @Override
    protected void doRestore(DynamicArea a, ArrayOffset storing) {
        int length = storing.get();
        this.daCache.clear();
        this.daCache.add(length);
        this.daCache.append(storing.data, storing.offset, length * 3);
        a.resetVolatiles();
        a.removeAllFrom(length);
        for (int i = 0; i < length; ++i) {
            if (storing.peek() != 0) {
                DynamicElementInfo ei = (DynamicElementInfo)a.ensureAndGet(i);
                ei.fields = this.pool.getFieldsAt(storing.get());
                ei.monitor = this.pool.getMonitorAt(storing.get());
                ei.attributes = storing.get();
                ei.markUnchanged();
                ei.updateLockingInfo();
                continue;
            }
            a.remove(i, true);
            storing.advance(3);
        }
        a.restoreVolatiles();
        a.markUnchanged();
    }

    @Override
    protected void doRestore(StaticArea a, ArrayOffset storing) {
        int length = storing.get();
        this.saCache.clear();
        this.saCache.add(length);
        this.saCache.append(storing.data, storing.offset, length * 5);
        a.resetVolatiles();
        a.removeAllFrom(length);
        for (int i = 0; i < length; ++i) {
            if (storing.peek() != 0) {
                StaticElementInfo ei = (StaticElementInfo)a.ensureAndGet(i);
                ei.fields = this.pool.getFieldsAt(storing.get());
                ei.monitor = this.pool.getMonitorAt(storing.get());
                ei.attributes = storing.get();
                ei.classObjectRef = storing.get();
                ei.status = storing.get();
                ei.markUnchanged();
                ei.updateLockingInfo();
                continue;
            }
            a.remove(i, true);
            storing.advance(5);
        }
        a.restoreVolatiles();
        a.markUnchanged();
    }
}

