/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.Monitor;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.ThreadData;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.util.HashPool;
import gov.nasa.jpf.util.IntTable;
import gov.nasa.jpf.util.WeakPool;

abstract class CollapsePools {
    CollapsePools() {
    }

    static class AllIndexed {
        private HashPool<ThreadData> threadDataPool = new HashPool(8).addNull();
        private HashPool<Monitor> monitorPool = new HashPool(8).addNull();
        private HashPool<StackFrame> stackFramePool = new HashPool(11).addNull();
        private HashPool<Fields> fieldsPool = new HashPool(11).addNull();

        AllIndexed() {
        }

        public StackFrame poolStackFrame(StackFrame o) {
            return this.stackFramePool.get(o);
        }

        public Fields poolFields(Fields o) {
            return this.fieldsPool.get(o);
        }

        public ThreadData poolThreadData(ThreadData o) {
            return this.threadDataPool.get(o);
        }

        public Monitor poolMonitor(Monitor o) {
            return this.monitorPool.get(o);
        }

        public int getFieldsIndex(ElementInfo ei) {
            IntTable.Entry<Fields> entry = this.fieldsPool.getEntry(ei.getFields());
            ei.restoreFields((Fields)entry.key);
            return entry.val;
        }

        public int getStackFrameIndex(StackFrame sf) {
            return this.stackFramePool.getIndex(sf);
        }

        public int getThreadDataIndex(ThreadInfo ti) {
            IntTable.Entry<ThreadData> e = this.threadDataPool.getEntry(ti.threadData);
            ti.threadData = (ThreadData)e.key;
            return e.val;
        }

        public int getMonitorIndex(ElementInfo ei) {
            IntTable.Entry<Monitor> entry = this.monitorPool.getEntry(ei.getMonitor());
            ei.restoreMonitor((Monitor)entry.key);
            return entry.val;
        }

        public Fields getFieldsAt(int idx) {
            return this.fieldsPool.getObject(idx);
        }

        public StackFrame getStackFrameAt(int idx) {
            return this.stackFramePool.getObject(idx);
        }

        public ThreadData getThreadDataAt(int idx) {
            return this.threadDataPool.getObject(idx);
        }

        public Monitor getMonitorAt(int idx) {
            return this.monitorPool.getObject(idx);
        }
    }

    static class AllWeak {
        private WeakPool<StackFrame> stackFramePool = new WeakPool(11);
        private WeakPool<Fields> fieldsPool = new WeakPool(11);
        private WeakPool<ThreadData> threadDataPool = new WeakPool(8);
        private WeakPool<Monitor> monitorPool = new WeakPool(8);

        AllWeak() {
        }

        public StackFrame poolStackFrame(StackFrame o) {
            return this.stackFramePool.pool(o);
        }

        public Fields poolFields(Fields o) {
            return this.fieldsPool.pool(o);
        }

        public ThreadData poolThreadData(ThreadData o) {
            return this.threadDataPool.pool(o);
        }

        public Monitor poolMonitor(Monitor o) {
            return this.monitorPool.pool(o);
        }
    }
}

