/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.JPFListener;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.Attributor;
import gov.nasa.jpf.jvm.CodeBuilder;
import gov.nasa.jpf.jvm.DirectCallStackFrame;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.FieldsFactory;
import gov.nasa.jpf.jvm.InfoObject;
import gov.nasa.jpf.jvm.InstructionFactory;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.MethodLocator;
import gov.nasa.jpf.jvm.NativePeer;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.ALOAD;
import gov.nasa.jpf.jvm.bytecode.GETFIELD;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.util.ObjVector;
import gov.nasa.jpf.util.Source;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.util.ClassPath;

public class ClassInfo
extends InfoObject
implements Iterable<MethodInfo> {
    public static final int UNINITIALIZED = -1;
    public static final int INITIALIZED = -2;
    static Logger logger = JPF.getLogger("gov.nasa.jpf.jvm.ClassInfo");
    static Config config;
    protected static ClassPath modelClassPath;
    protected static final ClassLoader thisClassLoader;
    protected static final ObjVector<ClassInfo> loadedClasses;
    protected static Attributor attributor;
    protected static FieldsFactory fieldsFactory;
    static ClassInfo classClassInfo;
    static ClassInfo objectClassInfo;
    static ClassInfo stringClassInfo;
    static ClassInfo weakRefClassInfo;
    static ClassInfo refClassInfo;
    static ClassInfo enumClassInfo;
    static FieldInfo[] emptyFields;
    static HashSet<String> autoloadAnnotations;
    static HashSet<String> autoloaded;
    protected String name;
    protected boolean isClass = true;
    protected boolean isWeakReference = false;
    protected boolean isArray = false;
    protected boolean isEnum = false;
    protected boolean isReferenceArray = false;
    protected boolean isAbstract = false;
    protected boolean isBuiltin = false;
    int modifiers;
    protected MethodInfo finalizer = null;
    protected int elementInfoAttrs = 0;
    protected Map<String, MethodInfo> methods;
    protected FieldInfo[] iFields;
    protected int instanceDataSize;
    protected int instanceDataOffset;
    protected int nInstanceFields;
    protected FieldInfo[] sFields;
    protected int staticDataSize;
    StaticElementInfo sei;
    protected ClassInfo superClass;
    protected Set<String> interfaces;
    protected Set<String> allInterfaces;
    protected String packageName;
    protected String sourceFileName;
    protected int uniqueId;
    private NativePeer nativePeer;
    protected Source source;
    static String[] assertionPatterns;
    boolean enableAssertions;
    static ConstantPool cpCache;
    static ConstantPoolGen cpgCache;

    static boolean init(Config config) throws Config.Exception {
        ClassInfo.config = config;
        loadedClasses.clear();
        classClassInfo = null;
        objectClassInfo = null;
        stringClassInfo = null;
        weakRefClassInfo = null;
        ClassInfo.setSourceRoots(config);
        ClassInfo.buildModelClassPath(config);
        attributor = config.getEssentialInstance("vm.attributor.class", Attributor.class);
        fieldsFactory = config.getEssentialInstance("vm.fields_factory.class", FieldsFactory.class);
        assertionPatterns = config.getStringArray("vm.enable_assertions");
        autoloadAnnotations = config.getNonEmptyStringSet("jpf.listener.autoload");
        if (autoloadAnnotations != null) {
            autoloaded = new HashSet();
            if (logger.isLoggable(Level.INFO)) {
                for (String s : autoloadAnnotations) {
                    logger.info("watching for autoload annotation @" + s);
                }
            }
        }
        return true;
    }

    public static ClassPath getModelClassPath() {
        return modelClassPath;
    }

    private ClassInfo() {
    }

    protected ClassInfo(String builtinClassName, int uniqueId) {
        this.isArray = builtinClassName.charAt(0) == '[';
        this.isReferenceArray = this.isArray && builtinClassName.endsWith(";");
        this.isBuiltin = true;
        this.name = builtinClassName;
        logger.log(Level.FINE, "generating builtin class: %1$s", this.name);
        this.packageName = "";
        this.sourceFileName = null;
        this.source = null;
        this.iFields = emptyFields;
        this.sFields = emptyFields;
        if (this.isArray) {
            this.superClass = objectClassInfo;
            this.interfaces = ClassInfo.loadArrayInterfaces();
            this.methods = this.loadArrayMethods();
        } else {
            this.superClass = null;
            this.interfaces = ClassInfo.loadBuiltinInterfaces(this.name);
            this.methods = this.loadBuiltinMethods(this.name);
        }
        this.enableAssertions = true;
        this.uniqueId = uniqueId;
        loadedClasses.set(uniqueId, this);
    }

    ClassInfo(ClassInfo annotationCls, String name, int uniqueId) {
        this.name = name;
        this.isClass = true;
        this.superClass = ClassInfo.getClassInfo("gov.nasa.jpf.AnnotationProxyBase");
        this.interfaces = new HashSet<String>();
        this.interfaces.add(annotationCls.name);
        this.packageName = annotationCls.packageName;
        this.sourceFileName = annotationCls.sourceFileName;
        this.sFields = new FieldInfo[0];
        this.staticDataSize = 0;
        this.methods = new HashMap<String, MethodInfo>();
        this.iFields = new FieldInfo[annotationCls.methods.size()];
        this.nInstanceFields = this.iFields.length;
        int idx = 0;
        int off = 0;
        for (MethodInfo mi : annotationCls.getDeclaredMethodInfos()) {
            String mname = mi.getName();
            String mtype = mi.getReturnTypeName();
            FieldInfo fi = FieldInfo.create(mname, mtype, 0, null, this, idx, off);
            this.iFields[idx++] = fi;
            off += fi.getStorageSize();
            InstructionFactory insnFactory = MethodInfo.getInstructionFactory();
            CodeBuilder cb = new CodeBuilder();
            ALOAD aload = (ALOAD)insnFactory.create(this, "ALOAD");
            cb.append(aload);
            aload.initialize(0);
            GETFIELD getfield = (GETFIELD)insnFactory.create(this, "GETFIELD");
            getfield.initialize(mname, name);
            cb.append(getfield);
            if (fi.isReference()) {
                cb.append(insnFactory.create(this, "ARETURN"));
            } else if (fi.getStorageSize() == 1) {
                cb.append(insnFactory.create(this, "IRETURN"));
            } else {
                cb.append(insnFactory.create(this, "LRETURN"));
            }
            MethodInfo pmi = new MethodInfo(mi.getUniqueName(), 1, 2, 1, cb.getCode());
            pmi.setClassInfo(this);
            this.methods.put(pmi.getUniqueName(), pmi);
        }
        this.instanceDataSize = this.computeInstanceDataSize();
        this.instanceDataOffset = 0;
        this.uniqueId = uniqueId;
        loadedClasses.set(uniqueId, this);
    }

    protected ClassInfo(JavaClass jc, int uniqueId) {
        this.initialize(jc, uniqueId);
    }

    protected void initialize(JavaClass jc, int uniqueId) {
        this.name = jc.getClassName();
        logger.log(Level.FINE, "loading class: %1$s", this.name);
        this.uniqueId = uniqueId;
        loadedClasses.set(uniqueId, this);
        if (objectClassInfo == null && this.name.equals("java.lang.Object")) {
            objectClassInfo = this;
        } else if (classClassInfo == null && this.name.equals("java.lang.Class")) {
            classClassInfo = this;
        } else if (stringClassInfo == null && this.name.equals("java.lang.String")) {
            stringClassInfo = this;
        } else if (weakRefClassInfo == null && this.name.equals("java.lang.ref.WeakReference")) {
            weakRefClassInfo = this;
        } else if (refClassInfo == null && this.name.equals("java.lang.ref.Reference")) {
            refClassInfo = this;
        } else if (enumClassInfo == null && this.name.equals("java.lang.Enum")) {
            enumClassInfo = this;
        }
        this.modifiers = jc.getModifiers();
        this.isClass = jc.isClass();
        this.superClass = this.loadSuperClass(jc);
        this.interfaces = ClassInfo.loadInterfaces(jc);
        this.packageName = jc.getPackageName();
        this.iFields = this.loadInstanceFields(jc);
        this.instanceDataSize = this.computeInstanceDataSize();
        this.instanceDataOffset = this.computeInstanceDataOffset();
        this.nInstanceFields = this.superClass != null ? this.superClass.nInstanceFields + this.iFields.length : this.iFields.length;
        this.sFields = this.loadStaticFields(jc);
        this.staticDataSize = this.computeStaticDataSize();
        this.methods = this.loadMethods(jc);
        this.nativePeer = NativePeer.getNativePeer(this);
        this.sourceFileName = this.computeSourceFileName(jc);
        this.source = null;
        this.isWeakReference = this.isWeakReference0();
        this.finalizer = this.getFinalizer0();
        this.isAbstract = jc.isAbstract();
        this.isEnum = this.isEnum0();
        this.elementInfoAttrs = this.loadElementInfoAttrs(jc);
        this.enableAssertions = this.getAssertionStatus();
        this.loadAnnotations(jc.getAnnotationEntries());
        this.processJPFConfigAnnotation();
        this.loadAnnotationListeners();
        JVM.getVM().notifyClassLoaded(this);
    }

    String computeSourceFileName(JavaClass jc) {
        char sep = File.separatorChar;
        String sfn = jc.getSourceFileName();
        if (sfn.equalsIgnoreCase("<Unknown>") || sfn.equalsIgnoreCase("Unknown")) {
            sfn = this.name.replace('.', sep);
            int idx = sfn.indexOf(36);
            if (idx > 0) {
                sfn = sfn.substring(0, idx);
            }
            sfn = sfn + ".java";
            return sfn;
        }
        if (this.packageName.length() > 0) {
            sfn = this.packageName.replace('.', sep) + sep + sfn;
        }
        return sfn;
    }

    void processJPFConfigAnnotation() {
        AnnotationInfo ai = this.getAnnotation("gov.nasa.jpf.JPFConfig");
        if (ai != null) {
            for (String s : ai.getValueAsStringArray()) {
                config.parse(s);
            }
        }
    }

    void loadAnnotationListeners() {
        if (autoloadAnnotations != null) {
            int i;
            this.autoloadListeners(this.annotations);
            for (i = 0; i < this.sFields.length; ++i) {
                this.autoloadListeners(this.sFields[i].getAnnotations());
            }
            for (i = 0; i < this.iFields.length; ++i) {
                this.autoloadListeners(this.iFields[i].getAnnotations());
            }
        }
    }

    void autoloadListeners(AnnotationInfo[] annos) {
        if (annos != null && autoloadAnnotations != null) {
            for (AnnotationInfo ai : annos) {
                String aName = ai.getName();
                if (!autoloadAnnotations.contains(aName) || autoloaded.contains(aName)) continue;
                autoloaded.add(aName);
                String key = "jpf.listener." + aName;
                String defClsName = aName + "Checker";
                try {
                    JPFListener listener = config.getInstance(key, JPFListener.class, defClsName);
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("autoload annotation listener: @" + aName + " => " + listener.getClass().getName());
                    }
                    JVM.getVM().getJPF().addUniqueTypeListener(listener);
                }
                catch (Config.Exception cx) {
                    logger.warning("no autoload listener class for annotation " + aName + " : " + cx.getMessage());
                    autoloadAnnotations.remove(aName);
                }
            }
            if (autoloadAnnotations.isEmpty()) {
                autoloadAnnotations = null;
            }
        }
    }

    @Override
    public ClassInfo getClassInfo() {
        return this;
    }

    boolean getAssertionStatus() {
        if (assertionPatterns == null || assertionPatterns.length == 0) {
            return false;
        }
        if ("*".equals(assertionPatterns[0])) {
            return true;
        }
        for (int i = 0; i < assertionPatterns.length; ++i) {
            if (!this.name.matches(assertionPatterns[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isReferenceArray() {
        return this.isReferenceArray;
    }

    public static synchronized ClassInfo getClassInfo(String className) {
        if (className == null) {
            return null;
        }
        String typeName = Types.getCanonicalTypeName(className);
        int idx = JVM.getVM().getStaticArea().indexFor(typeName);
        ClassInfo ci = loadedClasses.get(idx);
        if (ci != null) {
            return ci;
        }
        if (ClassInfo.isBuiltinClass(typeName)) {
            return new ClassInfo(typeName, idx);
        }
        JavaClass clazz = ClassInfo.getJavaClass(className);
        if (clazz != null) {
            return new ClassInfo(clazz, idx);
        }
        return null;
    }

    public static ClassInfo getAnnotationProxy(ClassInfo ciAnnotation) {
        String cname;
        int idx;
        ClassInfo ci;
        StaticArea sa = JVM.getVM().getStaticArea();
        if (!ciAnnotation.isInitialized()) {
            ThreadInfo ti = ThreadInfo.getCurrentThread();
            if (!sa.containsClass(ciAnnotation.getName())) {
                sa.addClass(ciAnnotation, ti);
                ciAnnotation.setInitialized();
            }
        }
        if ((ci = loadedClasses.get(idx = sa.indexFor(cname = ciAnnotation.getName() + "$Proxy"))) != null) {
            return ci;
        }
        return new ClassInfo(ciAnnotation, cname, idx);
    }

    static InputStream getClassFileStream(String className) {
        String slashName = className.replace('.', '/');
        InputStream is = null;
        try {
            ClassPath.ClassFile file = modelClassPath.getClassFile(slashName, ".class");
            if (file != null) {
                is = file.getInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (is == null) {
            is = thisClassLoader.getResourceAsStream(slashName + ".class");
        }
        if (is == null) {
            return null;
        }
        return is;
    }

    static JavaClass getJavaClass(String className) {
        InputStream is = ClassInfo.getClassFileStream(className);
        if (is != null) {
            try {
                ClassParser parser = new ClassParser(is, className);
                JavaClass clazz = parser.parse();
                return clazz;
            }
            catch (IOException e) {
                throw new JPFException("error reading classfile: " + className);
            }
        }
        return null;
    }

    public void reload() {
        if (!ClassInfo.isBuiltinClass(this.name)) {
            JavaClass jc = ClassInfo.getJavaClass(this.name);
            this.initialize(jc, this.uniqueId);
        }
    }

    public boolean areAssertionsEnabled() {
        return this.enableAssertions;
    }

    public boolean hasInstanceFields() {
        return this.instanceDataSize > 0;
    }

    public int getClassObjectRef() {
        return this.sei != null ? this.sei.getClassObjectRef() : -1;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public MethodInfo getMethod(String uniqueName, boolean isRecursiveLookup) {
        MethodInfo mi = this.methods.get(uniqueName);
        if (mi == null && isRecursiveLookup && this.superClass != null) {
            mi = this.superClass.getMethod(uniqueName, true);
        }
        return mi;
    }

    public MethodInfo getReflectionMethod(String fullName, boolean isRecursiveLookup) {
        for (Map.Entry<String, MethodInfo> e : this.methods.entrySet()) {
            String name = e.getKey();
            if (!name.startsWith(fullName)) continue;
            return e.getValue();
        }
        if (isRecursiveLookup && this.superClass != null) {
            return this.superClass.getReflectionMethod(fullName, true);
        }
        return null;
    }

    public void matchMethods(MethodLocator loc) {
        for (MethodInfo mi : this.methods.values()) {
            if (!loc.match(mi)) continue;
            return;
        }
        if (this.superClass != null) {
            this.superClass.matchMethods(loc);
        }
    }

    public void matchDeclaredMethods(MethodLocator loc) {
        for (MethodInfo mi : this.methods.values()) {
            if (!loc.match(mi)) continue;
            return;
        }
    }

    @Override
    public Iterator<MethodInfo> iterator() {
        return new Iterator<MethodInfo>(){
            ClassInfo ci;
            Iterator<MethodInfo> it;
            {
                this.ci = ClassInfo.this;
                this.it = this.ci.methods.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.it.hasNext()) {
                    return true;
                }
                if (this.ci.superClass != null) {
                    this.ci = this.ci.superClass;
                    this.it = this.ci.methods.values().iterator();
                    return this.it.hasNext();
                }
                return false;
            }

            @Override
            public MethodInfo next() {
                if (this.hasNext()) {
                    return this.it.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("can't remove methods");
            }
        };
    }

    public FieldInfo getStaticField(String fName) {
        FieldInfo fi;
        ClassInfo c = this;
        while (c != null) {
            fi = c.getDeclaredStaticField(fName);
            if (fi != null) {
                return fi;
            }
            c = c.superClass;
        }
        for (String interface_name : this.getAllInterfaces()) {
            fi = ClassInfo.getClassInfo(interface_name).getDeclaredStaticField(fName);
            if (fi == null) continue;
            return fi;
        }
        return null;
    }

    public Object getStaticFieldValueObject(String id) {
        for (ClassInfo c = this; c != null; c = c.getSuperClass()) {
            StaticElementInfo sei = c.getStaticElementInfo();
            Object v = sei.getFieldValueObject(id);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public FieldInfo[] getDeclaredStaticFields() {
        return this.sFields;
    }

    public FieldInfo[] getDeclaredInstanceFields() {
        return this.iFields;
    }

    public FieldInfo getDeclaredStaticField(String fName) {
        for (int i = 0; i < this.sFields.length; ++i) {
            if (!this.sFields[i].getName().equals(fName)) continue;
            return this.sFields[i];
        }
        return null;
    }

    public FieldInfo getInstanceField(String fName) {
        ClassInfo c = this;
        while (c != null) {
            FieldInfo fi = c.getDeclaredInstanceField(fName);
            if (fi != null) {
                return fi;
            }
            c = c.superClass;
        }
        return null;
    }

    public FieldInfo getDeclaredInstanceField(String fName) {
        for (int i = 0; i < this.iFields.length; ++i) {
            if (!this.iFields[i].getName().equals(fName)) continue;
            return this.iFields[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        int i = this.name.lastIndexOf(46);
        return this.name.substring(i + 1);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public int getFieldAttrs(int fieldIndex) {
        return 0;
    }

    public int getElementInfoAttrs() {
        return this.elementInfoAttrs;
    }

    public Source getSource() {
        if (this.source == null) {
            this.source = this.loadSource();
        }
        return this.source;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public FieldInfo getStaticField(int index) {
        return this.sFields[index];
    }

    public String getStaticFieldName(int index) {
        return this.getStaticField(index).getName();
    }

    public boolean isStaticMethodAbstractionDeterministic(ThreadInfo th, MethodInfo mi) {
        return true;
    }

    public ClassInfo getSuperClass() {
        return this.superClass;
    }

    public ClassInfo getSuperClass(String clsName) {
        if (clsName.equals(this.name)) {
            return this;
        }
        if (this.superClass != null) {
            return this.superClass.getSuperClass(clsName);
        }
        return null;
    }

    public boolean isSystemClass() {
        return this.name.startsWith("java.") || this.name.startsWith("javax.");
    }

    public boolean isBoxClass() {
        String rawType;
        return this.name.startsWith("java.lang.") && ((rawType = this.name.substring(10)).startsWith("Boolean") || rawType.startsWith("Byte") || rawType.startsWith("Character") || rawType.startsWith("Integer") || rawType.startsWith("Float") || rawType.startsWith("Long") || rawType.startsWith("Double"));
    }

    public String getType() {
        return "L" + this.name.replace('.', '/') + ";";
    }

    public boolean isWeakReference() {
        return this.isWeakReference;
    }

    public boolean isRefClass() {
        return this == refClassInfo;
    }

    public boolean isPrimitive() {
        return this.superClass == null && this != objectClassInfo;
    }

    boolean hasRefField(int ref, Fields fv) {
        ClassInfo c = this;
        do {
            FieldInfo[] fia = c.iFields;
            for (int i = 0; i < fia.length; ++i) {
                FieldInfo fi = c.iFields[i];
                if (!fi.isReference() || fv.getIntValue(fi.getStorageOffset()) != ref) continue;
                return true;
            }
        } while ((c = c.superClass) != null);
        return false;
    }

    boolean hasImmutableInstances() {
        return (this.elementInfoAttrs & 2) != 0;
    }

    public NativePeer getNativePeer() {
        return this.nativePeer;
    }

    public boolean isInstanceOf(String cname) {
        if (this.isPrimitive()) {
            return Types.getJNITypeCode(this.name).equals(cname);
        }
        cname = Types.getCanonicalTypeName(cname);
        ClassInfo c = this;
        while (c != null) {
            if (c.name.equals(cname)) {
                return true;
            }
            c = c.superClass;
        }
        return this.getAllInterfaces().contains(cname);
    }

    public boolean isInstanceOf(ClassInfo ci) {
        return this.isInstanceOf(ci.name);
    }

    public static void reset() {
        loadedClasses.clear();
        classClassInfo = null;
        objectClassInfo = null;
        stringClassInfo = null;
    }

    public static int getNumberOfLoadedClasses() {
        return loadedClasses.size();
    }

    static String getDefaultBootClassPath() {
        StringBuilder sb = new StringBuilder("build");
        sb.append(File.separatorChar);
        sb.append("env");
        sb.append(File.separatorChar);
        sb.append("jpf");
        sb.append(File.pathSeparatorChar);
        sb.append("lib");
        sb.append(File.separatorChar);
        sb.append("env_jpf.jar");
        return sb.toString();
    }

    static String getDefaultClassPath() {
        return null;
    }

    public static String[] getClassPathElements() {
        String cp = modelClassPath.toString();
        return cp.split("[:;]");
    }

    protected static void buildModelClassPath(Config config) {
        StringBuilder buf = new StringBuilder(128);
        char sep = File.pathSeparatorChar;
        String param = config.getExpandedString("vm.bootclasspath");
        String v = param == null ? ClassInfo.getDefaultBootClassPath() : param;
        buf.append(v);
        param = config.getExpandedString("vm.classpath");
        v = param == null ? ClassInfo.getDefaultClassPath() : param;
        if (v != null) {
            buf.append(sep);
            buf.append(v);
        }
        if (buf.length() > 0) {
            String ps = config.asPlatformPath(buf.toString());
            buf = new StringBuilder(ps);
            buf.append(sep);
        }
        buf.append(System.getProperty("java.class.path"));
        if (buf.length() > 0) {
            buf.append(sep);
        }
        buf.append(System.getProperty("sun.boot.class.path"));
        String cp = config.asPlatformPath(buf.toString());
        modelClassPath = new ClassPath(cp);
    }

    protected static Set<String> loadArrayInterfaces() {
        HashSet<String> interfaces = new HashSet<String>();
        interfaces.add("java.lang.Cloneable");
        interfaces.add("java.io.Serializable");
        return Collections.unmodifiableSet(interfaces);
    }

    protected static Set<String> loadBuiltinInterfaces(String type) {
        return Collections.unmodifiableSet(new HashSet(0));
    }

    protected static Set<String> loadInterfaces(JavaClass jc) {
        String[] interfaceNames = jc.getInterfaceNames();
        HashSet<String> interfaces = new HashSet<String>();
        int l = interfaceNames.length;
        for (int i = 0; i < l; ++i) {
            interfaces.add(interfaceNames[i]);
        }
        return Collections.unmodifiableSet(interfaces);
    }

    FieldInfo[] loadInstanceFields(JavaClass jc) {
        int i;
        Field[] fields = jc.getFields();
        int off = this.superClass != null ? this.superClass.instanceDataSize : 0;
        int n = 0;
        for (i = 0; i < fields.length; ++i) {
            if (fields[i].isStatic()) continue;
            ++n;
        }
        int idx = this.superClass != null ? this.superClass.nInstanceFields : 0;
        FieldInfo[] ifa = new FieldInfo[n];
        int j = 0;
        for (i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (f.isStatic()) continue;
            FieldInfo fi = FieldInfo.create(f, this, idx, off);
            ifa[j++] = fi;
            off += fi.getStorageSize();
            ++idx;
            if (attributor == null) continue;
            fi.setAttributes(attributor.getFieldAttributes(jc, f));
        }
        return ifa;
    }

    int computeInstanceDataOffset() {
        if (this.superClass == null) {
            return 0;
        }
        return this.superClass.getInstanceDataSize();
    }

    int getInstanceDataOffset() {
        return this.instanceDataOffset;
    }

    ClassInfo getClassBase(String clsBase) {
        if (clsBase == null || this.name.equals(clsBase)) {
            return this;
        }
        if (this.superClass != null) {
            return this.superClass.getClassBase(clsBase);
        }
        return null;
    }

    int computeInstanceDataSize() {
        int n = this.getDataSize(this.iFields);
        ClassInfo c = this.superClass;
        while (c != null) {
            n += c.getDataSize(c.iFields);
            c = c.superClass;
        }
        return n;
    }

    public int getInstanceDataSize() {
        return this.instanceDataSize;
    }

    int getDataSize(FieldInfo[] fields) {
        int n = 0;
        for (int i = 0; i < fields.length; ++i) {
            n += fields[i].getStorageSize();
        }
        return n;
    }

    public int getNumberOfDeclaredInstanceFields() {
        return this.iFields.length;
    }

    public FieldInfo getDeclaredInstanceField(int i) {
        return this.iFields[i];
    }

    public int getNumberOfInstanceFields() {
        return this.nInstanceFields;
    }

    public FieldInfo getInstanceField(int i) {
        int idx = i - (this.nInstanceFields - this.iFields.length);
        if (idx >= 0) {
            return idx < this.iFields.length ? this.iFields[idx] : null;
        }
        return this.superClass != null ? this.superClass.getInstanceField(i) : null;
    }

    FieldInfo[] loadStaticFields(JavaClass jc) {
        int i;
        Field[] fields = jc.getFields();
        int off = 0;
        int n = 0;
        for (i = 0; i < fields.length; ++i) {
            if (!fields[i].isStatic()) continue;
            ++n;
        }
        FieldInfo[] sfa = new FieldInfo[n];
        int idx = 0;
        for (i = 0; i < fields.length; ++i) {
            FieldInfo fi;
            Field f = fields[i];
            if (!f.isStatic()) continue;
            sfa[idx] = fi = FieldInfo.create(f, this, idx, off);
            ++idx;
            off += fi.getStorageSize();
            if (attributor == null) continue;
            fi.setAttributes(attributor.getFieldAttributes(jc, f));
        }
        return sfa;
    }

    public int getStaticDataSize() {
        return this.staticDataSize;
    }

    int computeStaticDataSize() {
        return this.getDataSize(this.sFields);
    }

    public int getNumberOfStaticFields() {
        return this.sFields.length;
    }

    protected Source loadSource() {
        return Source.getSource(this.sourceFileName);
    }

    static boolean isBuiltinClass(String cname) {
        char c = cname.charAt(0);
        if (c == '[' || cname.endsWith("[]")) {
            return true;
        }
        return Character.isLowerCase(c) && ("int".equals(cname) || "byte".equals(cname) || "boolean".equals(cname) || "double".equals(cname) || "long".equals(cname) || "char".equals(cname) || "short".equals(cname) || "float".equals(cname) || "void".equals(cname));
    }

    static void setSourceRoots(Config config) {
        Source.init(config);
    }

    Set<String> getAllInterfaces() {
        if (this.allInterfaces == null) {
            HashSet<String> set = new HashSet<String>();
            ClassInfo ci = this;
            while (ci != null) {
                this.loadInterfaceRec(set, ci);
                ci = ci.superClass;
            }
            this.allInterfaces = Collections.unmodifiableSet(set);
        }
        return this.allInterfaces;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public ClassInfo getComponentClassInfo() {
        if (this.isArray()) {
            String cn = this.name.substring(1);
            if (cn.charAt(0) != '[') {
                cn = Types.getTypeName(cn);
            }
            ClassInfo cci = ClassInfo.getClassInfo(cn);
            return cci;
        }
        return null;
    }

    Map<String, MethodInfo> getDeclaredMethods() {
        return this.methods;
    }

    public MethodInfo[] getDeclaredMethodInfos() {
        MethodInfo[] a = new MethodInfo[this.methods.size()];
        this.methods.values().toArray(a);
        return a;
    }

    public MethodInfo getFinalizer() {
        return this.finalizer;
    }

    public MethodInfo getClinit() {
        for (MethodInfo mi : this.methods.values()) {
            if (!"<clinit>".equals(mi.getName())) continue;
            return mi;
        }
        return null;
    }

    public boolean hasCtors() {
        for (MethodInfo mi : this.methods.values()) {
            if (!"<init>".equals(mi.getName())) continue;
            return true;
        }
        return false;
    }

    public int createClassObject(ThreadInfo th, int cref) {
        DynamicArea da = DynamicArea.getHeap();
        int objref = da.newObject(classClassInfo, th);
        int cnref = da.newInternString(this.name, th);
        Object e = da.get(objref);
        try {
            ((ElementInfo)e).setReferenceField("name", cnref);
            ((ElementInfo)e).setIntField("cref", cref);
        }
        catch (Exception x) {
            if (classClassInfo == null) {
                logger.severe("FATAL ERROR: wrong java.lang.Class version (wrong 'vm.classpath' property)");
            }
            return -1;
        }
        return objref;
    }

    public static String findResource(String resourceName) {
        try {
            for (String cpe : ClassInfo.getClassPathElements()) {
                if (cpe.endsWith(".jar")) {
                    JarFile jar = new JarFile(cpe);
                    JarEntry e = jar.getJarEntry(resourceName);
                    if (e == null) continue;
                    File f = new File(cpe);
                    return "jar:" + f.toURI().toURL().toString() + "!/" + resourceName;
                }
                File f = new File(cpe, resourceName);
                if (!f.exists()) continue;
                return f.toURI().toURL().toString();
            }
        }
        catch (MalformedURLException mfx) {
            return null;
        }
        catch (IOException iox) {
            return null;
        }
        return null;
    }

    public boolean isInitializing() {
        return this.sei != null && this.sei.getStatus() >= 0;
    }

    public boolean isInitialized() {
        return this.sei != null && this.sei.getStatus() == -2;
    }

    public boolean needsInitialization() {
        return this.sei == null || this.sei.getStatus() == -1;
    }

    public void setInitializing(ThreadInfo ti) {
        this.sei.setStatus(ti.getIndex());
    }

    public void setInitialized() {
        this.sei.setStatus(-2);
    }

    public void loadAndInitialize(ThreadInfo ti) {
        StaticArea sa = ti.getVM().getStaticArea();
        if (!sa.containsClass(this.name)) {
            sa.addClass(this, ti);
            this.setInitialized();
        }
    }

    public int loadAndInitialize(ThreadInfo ti, Instruction continuation) {
        ClassInfo ci;
        StaticArea sa = ti.getVM().getStaticArea();
        int pushedFrames = 0;
        for (ci = this; ci != null; ci = ci.getSuperClass()) {
            if (!this.initialize(sa, ci, ti, continuation)) continue;
            continuation = null;
            ++pushedFrames;
        }
        for (String ifc : this.getAllInterfaces()) {
            ci = ClassInfo.getClassInfo(ifc);
            if (!this.initialize(sa, ci, ti, continuation)) continue;
            continuation = null;
            ++pushedFrames;
        }
        return pushedFrames;
    }

    protected boolean initialize(StaticArea sa, ClassInfo ci, ThreadInfo ti, Instruction continuation) {
        int stat;
        StaticElementInfo ei = ci.getStaticElementInfo();
        if (ei == null) {
            sa.addClass(ci, ti);
            ei = ci.getStaticElementInfo();
            assert (ei != null) : "static init failed: " + ci.getName();
        }
        if ((stat = ei.getStatus()) != -2 && stat != ti.getIndex()) {
            MethodInfo mi = ci.getMethod("<clinit>()V", false);
            if (mi != null) {
                MethodInfo stub = mi.createDirectCallStub("[clinit]");
                DirectCallStackFrame sf = new DirectCallStackFrame(stub, continuation);
                ti.pushFrame(sf);
                return true;
            }
            ci.setInitialized();
        }
        return false;
    }

    protected void setStaticElementInfo(StaticElementInfo sei) {
        this.sei = sei;
    }

    public StaticElementInfo getStaticElementInfo() {
        return this.sei;
    }

    Fields createArrayFields(String type, int nElements, int typeSize, boolean isReferenceArray) {
        return fieldsFactory.createArrayFields(type, this, nElements, typeSize, isReferenceArray);
    }

    Fields createStaticFields() {
        return fieldsFactory.createStaticFields(this);
    }

    void initializeStaticData(ElementInfo ei) {
        Fields f = ei.getFields();
        for (int i = 0; i < this.sFields.length; ++i) {
            FieldInfo fi = this.sFields[i];
            fi.initialize(ei);
        }
    }

    public Fields createInstanceFields() {
        return fieldsFactory.createInstanceFields(this);
    }

    void initializeInstanceData(ElementInfo ei) {
        if (this.superClass != null) {
            this.superClass.initializeInstanceData(ei);
        }
        for (int i = 0; i < this.iFields.length; ++i) {
            FieldInfo fi = this.iFields[i];
            fi.initialize(ei);
        }
    }

    Map<String, MethodInfo> loadArrayMethods() {
        return new HashMap<String, MethodInfo>(0);
    }

    Map<String, MethodInfo> loadBuiltinMethods(String type) {
        return new HashMap<String, MethodInfo>(0);
    }

    void loadInterfaceRec(Set<String> set, ClassInfo ci) {
        if (ci != null) {
            for (String iname : ci.interfaces) {
                set.add(iname);
                ci = ClassInfo.getClassInfo(iname);
                this.loadInterfaceRec(set, ci);
            }
        }
    }

    public static ConstantPoolGen getConstantPoolGen(ConstantPool cp) {
        if (cp != cpCache) {
            cpCache = cp;
            cpgCache = new ConstantPoolGen(cp);
        }
        return cpgCache;
    }

    static void resetCPCache() {
        cpCache = null;
        cpgCache = null;
    }

    Map<String, MethodInfo> loadMethods(JavaClass jc) {
        Method[] ms = jc.getMethods();
        LinkedHashMap<String, MethodInfo> map = new LinkedHashMap<String, MethodInfo>(ms.length);
        for (int i = 0; i < ms.length; ++i) {
            MethodInfo mi = new MethodInfo(ms[i], this);
            String id = mi.getUniqueName();
            map.put(id, mi);
            if (attributor != null) {
                mi.setAtomic(attributor.isMethodAtomic(jc, ms[i], id));
            }
            if (autoloadAnnotations == null) continue;
            this.autoloadListeners(mi.getAnnotations());
        }
        ClassInfo.resetCPCache();
        return map;
    }

    ClassInfo loadSuperClass(JavaClass jc) {
        if (this == objectClassInfo) {
            return null;
        }
        String superName = jc.getSuperclassName();
        return ClassInfo.getClassInfo(superName);
    }

    int loadElementInfoAttrs(JavaClass jc) {
        int attrs = 0;
        if (attributor != null) {
            attrs = attributor.getObjectAttributes(jc);
        }
        if (!this.isArray && this.instanceDataSize == 0) {
            attrs |= 2;
        }
        return attrs;
    }

    public String toString() {
        return "ClassInfo[name=" + this.name + "]";
    }

    private MethodInfo getFinalizer0() {
        MethodInfo mi = this.getMethod("finalize()V", true);
        if (mi != null && mi.getClassInfo() != objectClassInfo) {
            return mi;
        }
        return null;
    }

    private boolean isWeakReference0() {
        ClassInfo ci = this;
        while (ci != objectClassInfo) {
            if (ci == weakRefClassInfo) {
                return true;
            }
            ci = ci.superClass;
        }
        return false;
    }

    private boolean isEnum0() {
        ClassInfo ci = this;
        while (ci != objectClassInfo) {
            if (ci == enumClassInfo) {
                return true;
            }
            ci = ci.superClass;
        }
        return false;
    }

    static {
        thisClassLoader = ClassInfo.class.getClassLoader();
        loadedClasses = new ObjVector(100);
        emptyFields = new FieldInfo[0];
    }
}

