/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.HashMap;

public class ChoicePoint {
    String cgClassName;
    int choice;
    ChoicePoint next;
    ChoicePoint prev;

    ChoicePoint(String cgClassName, int choice, ChoicePoint prev) {
        this.cgClassName = cgClassName;
        this.choice = choice;
        if (prev != null) {
            this.prev = prev;
            prev.next = this;
        }
    }

    public String getCgClassName() {
        return this.cgClassName;
    }

    public int getChoice() {
        return this.choice;
    }

    public ChoicePoint getNext() {
        return this.next;
    }

    public ChoicePoint getPrevious() {
        return this.prev;
    }

    public static void storeTrace(String fileName, String mainClass, String[] args, String comment, ChoiceGenerator[] trace) {
        if (fileName != null) {
            try {
                int i;
                FileWriter fw = new FileWriter(fileName);
                PrintWriter pw = new PrintWriter(fw);
                if (comment != null) {
                    pw.print("/* ");
                    pw.print(comment);
                    pw.println(" */");
                }
                pw.print("application: ");
                pw.println(mainClass);
                for (i = 0; i < args.length; ++i) {
                    pw.print(' ');
                    pw.print(args[i]);
                }
                pw.println();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                int clsId = 0;
                for (i = 0; i < trace.length; ++i) {
                    String cgClsName = trace[i].getClass().getName();
                    pw.print('[');
                    pw.print(i);
                    pw.print("] ");
                    Integer ref = (Integer)map.get(cgClsName);
                    if (ref == null) {
                        pw.print(cgClsName);
                        map.put(cgClsName, clsId++);
                    } else {
                        pw.print('#');
                        pw.print(ref);
                    }
                    pw.print(" ");
                    pw.println(trace[i].getProcessedNumberOfChoices());
                }
                pw.close();
                fw.close();
            }
            catch (Throwable t) {
                throw new JPFException(t);
            }
        }
    }

    static StreamTokenizer createScanner(String fileName) {
        StreamTokenizer scanner = null;
        if (fileName == null) {
            return null;
        }
        File f = new File(fileName);
        if (f.exists()) {
            try {
                FileReader fr = new FileReader(f);
                scanner = new StreamTokenizer(fr);
                scanner.slashSlashComments(true);
                scanner.slashStarComments(true);
                scanner.resetSyntax();
                scanner.wordChars(97, 122);
                scanner.wordChars(65, 90);
                scanner.wordChars(160, 255);
                scanner.whitespaceChars(0, 32);
                scanner.quoteChar(34);
                scanner.quoteChar(39);
                scanner.wordChars(48, 57);
                scanner.wordChars(58, 58);
                scanner.wordChars(46, 46);
                scanner.wordChars(35, 35);
                scanner.nextToken();
            }
            catch (IOException iox) {
                throw new JPFException("cannot read tracefile: " + fileName);
            }
            return scanner;
        }
        return null;
    }

    static void match(StreamTokenizer scanner, String s) throws IOException {
        if (scanner.ttype != -3 || !scanner.sval.equals(s)) {
            throw new JPFException("tracefile error - expected " + s + ", got: " + scanner.sval);
        }
        scanner.nextToken();
    }

    static String matchString(StreamTokenizer scanner) throws IOException {
        if (scanner.ttype == -3) {
            String s = scanner.sval;
            if (s.length() == 0) {
                throw new JPFException("tracefile error - non-empty string expected");
            }
            scanner.nextToken();
            return s;
        }
        throw new JPFException("tracefile error - word expected, got: " + scanner.sval);
    }

    static void matchChar(StreamTokenizer scanner, char c) throws IOException {
        if (scanner.ttype != c) {
            throw new JPFException("tracefile error - char '" + c + "' expected, got: " + scanner.sval);
        }
        scanner.nextToken();
    }

    static int matchNumber(StreamTokenizer scanner) throws IOException {
        try {
            if (scanner.ttype == -3) {
                int n = Integer.parseInt(scanner.sval);
                scanner.nextToken();
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new JPFException("tracefile error - number expected, got: " + scanner.sval);
    }

    public static ChoicePoint readTrace(String fileName, String mainClass, String[] args) {
        ChoicePoint firstCp = null;
        ChoicePoint cp = null;
        StreamTokenizer scanner = ChoicePoint.createScanner(fileName);
        if (scanner == null) {
            return null;
        }
        try {
            ChoicePoint.match(scanner, "application:");
            ChoicePoint.match(scanner, mainClass);
            for (int i = 0; i < args.length; ++i) {
                ChoicePoint.match(scanner, args[i]);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            int clsId = 0;
            while (scanner.ttype != -1) {
                ChoicePoint.matchChar(scanner, '[');
                ChoicePoint.matchNumber(scanner);
                ChoicePoint.matchChar(scanner, ']');
                String cpClass = ChoicePoint.matchString(scanner);
                if (cpClass.charAt(0) == '#') {
                    if ((cpClass = (String)map.get(cpClass)) == null) {
                        throw new JPFException("tracefile error - unknown ChoicePoint class id: " + cpClass);
                    }
                } else {
                    String id = "#" + clsId++;
                    map.put(id, cpClass);
                }
                int choiceIndex = ChoicePoint.matchNumber(scanner) - 1;
                cp = new ChoicePoint(cpClass, choiceIndex, cp);
                if (firstCp != null) continue;
                firstCp = cp;
            }
        }
        catch (IOException iox) {
            throw new JPFException("tracefile read error: " + iox.getMessage());
        }
        return firstCp;
    }
}

