/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ChoiceGenerator;

public class BooleanChoiceGenerator
extends ChoiceGenerator<Boolean> {
    static boolean falseFirst = true;
    int count = -1;
    boolean next;

    public BooleanChoiceGenerator(Config conf, String id) {
        super(id);
        this.next = falseFirst = conf.getBoolean("cg.boolean.false_first", true);
    }

    @Override
    public boolean hasMoreChoices() {
        return !this.isDone && this.count < 1;
    }

    @Override
    public Boolean getNextChoice() {
        return this.next ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Class<Boolean> getChoiceType() {
        return Boolean.class;
    }

    @Override
    public void advance() {
        if (this.count < 1) {
            ++this.count;
            this.next = !this.next;
        }
    }

    @Override
    public void reset() {
        this.count = -1;
        this.next = falseFirst;
    }

    @Override
    public int getTotalNumberOfChoices() {
        return 2;
    }

    @Override
    public int getProcessedNumberOfChoices() {
        return this.count + 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        if (this.count < 1) {
            sb.append('>');
            sb.append(this.next);
            sb.append(',');
            sb.append(!this.next);
        } else {
            sb.append(!this.next);
            sb.append(',');
            sb.append('>');
            sb.append(this.next);
        }
        sb.append(']');
        return sb.toString();
    }

    public BooleanChoiceGenerator randomize() {
        this.next = random.nextBoolean();
        return this;
    }
}

