/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Types;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.EnumElementValue;
import org.apache.bcel.classfile.SimpleElementValue;

public class AnnotationInfo {
    String name;
    Entry[] entries;

    public AnnotationInfo(String name, Entry[] entries) {
        this.name = name;
        this.entries = entries;
    }

    public AnnotationInfo(AnnotationEntry ae) {
        this.name = Types.getCanonicalTypeName(ae.getAnnotationType());
        ElementValuePair[] evp = ae.getElementValuePairs();
        this.entries = new Entry[evp.length];
        for (int i = 0; i < evp.length; ++i) {
            this.entries[i] = new Entry(evp[i].getNameString(), AnnotationInfo.getValueObject(evp[i].getValue()));
        }
    }

    static Object getValueObject(ElementValue ev) {
        switch (ev.getElementValueType()) {
            case 73: {
                return new Integer(((SimpleElementValue)ev).getValueInt());
            }
            case 74: {
                return new Long(((SimpleElementValue)ev).getValueLong());
            }
            case 68: {
                return new Double(((SimpleElementValue)ev).getValueDouble());
            }
            case 70: {
                return new Float(((SimpleElementValue)ev).getValueFloat());
            }
            case 83: {
                return new Short(((SimpleElementValue)ev).getValueShort());
            }
            case 67: {
                return new Character(((SimpleElementValue)ev).getValueChar());
            }
            case 66: {
                return new Byte(((SimpleElementValue)ev).getValueByte());
            }
            case 90: {
                return ((SimpleElementValue)ev).getValueBoolean();
            }
            case 115: {
                return ((SimpleElementValue)ev).getValueString();
            }
            case 91: {
                ElementValue[] a = ((ArrayElementValue)ev).getElementValuesArray();
                Object[] arr = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    arr[i] = AnnotationInfo.getValueObject(a[i]);
                }
                return arr;
            }
            case 101: {
                EnumElementValue eev = (EnumElementValue)ev;
                String etype = Types.getTypeName(eev.getEnumTypeString());
                String eval = eev.getEnumValueString();
                ClassInfo eci = ClassInfo.getClassInfo(etype);
                FieldInfo efi = eci.getStaticField(eval);
                return efi;
            }
            case 99: {
                ClassElementValue cev = (ClassElementValue)ev;
                String cname = Types.getTypeName(cev.getClassString());
                ClassInfo ci = ClassInfo.getClassInfo(cname);
                return ci;
            }
        }
        return ev.stringifyValue();
    }

    public String getName() {
        return this.name;
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public Object value() {
        return this.getValue("value");
    }

    public String valueAsString() {
        Object v = this.value();
        return v != null ? v.toString() : null;
    }

    public String getValueAsString(String key) {
        Object v = this.getValue(key);
        return v != null ? v.toString() : null;
    }

    public String[] getValueAsStringArray() {
        Object v = this.value();
        if (v != null && v instanceof Object[]) {
            Object[] va = (Object[])v;
            String[] a = new String[va.length];
            for (int i = 0; i < a.length; ++i) {
                if (va[i] == null) continue;
                a[i] = va[i].toString();
            }
            return a;
        }
        return null;
    }

    public String[] getValueAsStringArray(String key) {
        Object v = this.getValue(key);
        if (v != null && v instanceof Object[]) {
            Object[] va = (Object[])v;
            String[] a = new String[va.length];
            for (int i = 0; i < a.length; ++i) {
                if (va[i] == null) continue;
                a[i] = va[i].toString();
            }
            return a;
        }
        return null;
    }

    public boolean getValueAsBoolean(String key) {
        Object v = this.getValue(key);
        return v != null && v instanceof Boolean ? (Boolean)v : false;
    }

    public Object getValue(String key) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.entries[i].getKey().equals(key)) continue;
            return this.entries[i].getValue();
        }
        return null;
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.name);
        sb.append('[');
        for (int i = 0; i < this.entries.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.entries[i].getKey());
            sb.append('=');
            sb.append(this.entries[i].getValue());
        }
        sb.append(']');
        return sb.toString();
    }

    class Entry {
        String key;
        Object value;

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class Enum {
        String type;
        String field;

        Enum(String t, String f) {
            this.type = t;
            this.field = f;
        }
    }
}

