/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.StateSerializer;

public abstract class AbstractSerializer
implements StateSerializer,
KernelState.ChangeListener {
    protected int[] cached = null;
    protected KernelState ks = null;

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        this.ks = jvm.getKernelState();
    }

    public int getCurrentStateVectorLength() {
        return this.cached.length;
    }

    @Override
    public int[] getStoringData() {
        if (this.cached == null) {
            this.cached = this.computeStoringData();
            this.ks.pushChangeListener(this);
        }
        return this.cached;
    }

    @Override
    public void kernelStateChanged(KernelState same) {
        this.cached = null;
    }

    protected abstract int[] computeStoringData();
}

