/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.StateRestorer;

public abstract class AbstractRestorer<Saved>
implements StateRestorer<Saved>,
KernelState.ChangeListener {
    protected Saved cached = null;
    protected KernelState ks = null;

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        this.ks = jvm.getKernelState();
    }

    @Override
    public Saved getRestorableData() {
        if (this.cached == null) {
            this.cached = this.computeRestorableData();
            this.ks.pushChangeListener(this);
        }
        return this.cached;
    }

    @Override
    public void restore(Saved data) {
        this.doRestore(data);
        if (this.cached == null) {
            this.ks.pushChangeListener(this);
        }
        this.cached = data;
    }

    @Override
    public void kernelStateChanged(KernelState same) {
        this.cached = null;
    }

    protected abstract Saved computeRestorableData();

    protected abstract void doRestore(Saved var1);
}

