/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf;

import gov.nasa.jpf.ConfigChangeListener;
import gov.nasa.jpf.util.ObjArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;

public class Config
extends Properties {
    static final String TARGET_KEY = "target";
    static final String TARGET_ARGS_KEY = "target_args";
    public static final String LIST_SEPARATOR = ",";
    static final String DELIMS = "[,]+";
    static final Class<?>[] CONFIG_ARGTYPES = new Class[]{Config.class};
    static final Class<?>[] NO_ARGTYPES = new Class[0];
    static final Object[] NO_ARGS = new Object[0];
    ClassLoader loader = Config.class.getClassLoader();
    String fileName;
    Object source;
    boolean gotProperties;
    List<ConfigChangeListener> changeListeners;
    String[] freeArgs;
    HashMap<String, Object> singletons;
    final Object[] CONFIG_ARGS = new Object[]{this};
    static final String PATH_SEPARATORS = "[,;]+";

    private Config(String alternatePath, Class<?> codeBase) {
        this.gotProperties = this.loadFile("default.properties", alternatePath, codeBase);
        this.normalizeValues();
    }

    public Config(String[] args, String fileName, String alternatePath, Class<?> codeBase) {
        super(new Config(alternatePath, codeBase == null ? (codeBase = Config.getCallerClass(1)) : codeBase));
        this.fileName = fileName;
        this.gotProperties = this.loadFile(fileName, alternatePath, codeBase);
        this.expandAppends();
        if (args != null) {
            this.processArgs(args);
            this.expandAppends();
        } else {
            this.freeArgs = new String[0];
        }
        this.normalizeValues();
    }

    public boolean gotDefaultProperties() {
        if (this.defaults != null && this.defaults instanceof Config) {
            return ((Config)this.defaults).gotProperties();
        }
        return false;
    }

    public boolean gotProperties() {
        return this.gotProperties;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSourceName() {
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof File) {
            return ((File)this.source).getAbsolutePath();
        }
        if (this.source instanceof URL) {
            return this.source.toString();
        }
        return this.source.toString();
    }

    public void setCurrentClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getCurrentClassLoader() {
        return this.loader;
    }

    public String getDefaultsSourceName() {
        if (this.defaults != null && this.defaults instanceof Config) {
            return ((Config)this.defaults).getSourceName();
        }
        return null;
    }

    public Object getSource() {
        return this.source;
    }

    public String[] getArgs() {
        return this.freeArgs;
    }

    public void addChangeListener(ConfigChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ConfigChangeListener>();
            this.changeListeners.add(l);
        } else if (!this.changeListeners.contains(l)) {
            this.changeListeners.add(l);
        }
    }

    public void removeChangeListener(ConfigChangeListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(l);
            if (this.changeListeners.size() == 0) {
                this.changeListeners = null;
            }
        }
    }

    public Exception exception(String msg) {
        return new Exception(msg);
    }

    public void throwException(String msg) throws Exception {
        throw new Exception(msg);
    }

    public static String makePropertyList(Iterable<?> collection) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (Object o : collection) {
            if (i++ > 0) {
                sb.append(':');
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public static Class<?> getCallerClass(int up) {
        int idx = up + 1;
        StackTraceElement[] st = new Throwable().getStackTrace();
        if (up < 0 || idx >= st.length) {
            return null;
        }
        try {
            return Class.forName(st[idx].getClassName());
        }
        catch (Throwable t) {
            return null;
        }
    }

    boolean loadFile(String fileName, String alternatePath, Class<?> codeBase) {
        InputStream is = null;
        try {
            File f = new File(fileName);
            if (!f.exists() && !f.isAbsolute() && alternatePath != null) {
                f = new File(alternatePath, fileName);
            }
            if (f.exists()) {
                this.source = f;
                is = new FileInputStream(f);
            } else {
                Class<Object> clazz = codeBase != null ? codeBase : Config.class;
                is = clazz.getResourceAsStream(fileName);
                if (is != null) {
                    this.source = clazz.getResource(fileName);
                }
            }
            if (is != null) {
                this.load(is);
                is.close();
                return true;
            }
        }
        catch (IOException iex) {
            return false;
        }
        return false;
    }

    void processArgs(String[] args) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a == null) continue;
            if (a.charAt(0) == '+') {
                int idx = a.indexOf("=");
                if (idx > 0) {
                    String key = a.substring(1, idx).trim();
                    String val = a.substring(idx + 1).trim();
                    if (key.endsWith("+")) {
                        this.expandAppend(key.substring(0, key.length() - 1), val);
                        continue;
                    }
                    this.setProperty(key, val);
                    continue;
                }
                this.setProperty(a.substring(1), "");
                continue;
            }
            list.add(a);
        }
        int n = list.size();
        this.freeArgs = new String[n];
        for (i = 0; i < n; ++i) {
            this.freeArgs[i] = (String)list.get(i);
        }
    }

    public int getNonOptionArgIndex() {
        if (this.freeArgs == null || this.freeArgs.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.freeArgs.length; ++i) {
            char c;
            String a = this.freeArgs[i];
            if (a == null || (c = a.charAt(0)) == '-') continue;
            return i;
        }
        return -1;
    }

    public String getTargetArg() {
        int i = this.getNonOptionArgIndex();
        if (i < 0) {
            return this.getString(TARGET_KEY);
        }
        return this.freeArgs[i];
    }

    public String[] getTargetArgParameters() {
        int i = this.getNonOptionArgIndex();
        if (i >= this.freeArgs.length - 1) {
            String[] a = this.getStringArray(TARGET_ARGS_KEY);
            if (a != null) {
                return a;
            }
            return new String[0];
        }
        int n = this.freeArgs.length - (i + 1);
        String[] a = new String[n];
        System.arraycopy(this.freeArgs, i + 1, a, 0, n);
        return a;
    }

    public String getArg(int i) {
        if (this.freeArgs == null) {
            return null;
        }
        if (this.freeArgs.length - 1 < i) {
            return null;
        }
        if (i < 0) {
            return null;
        }
        return this.freeArgs[i];
    }

    public void setArgs(String[] args) {
        this.freeArgs = args;
    }

    void expandAppend(String key, String value) {
        String v0 = this.getProperty(key);
        String v = v0 != null ? v0 + value : value;
        this.put(key, v);
    }

    public void expandAppends() {
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            if (!k.endsWith("+")) continue;
            this.expandAppend(k.substring(0, k.length() - 1), this.getProperty(k));
        }
    }

    public void normalizeValues() {
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            String v = this.getProperty(k);
            String nv = this.normalize(v);
            if (nv == v) continue;
            this.put(k, nv);
        }
    }

    String normalize(String v) {
        if ("true".equalsIgnoreCase(v = v.trim()) || "t".equalsIgnoreCase(v) || "yes".equalsIgnoreCase(v) || "y".equalsIgnoreCase(v)) {
            v = "true";
        } else if ("false".equalsIgnoreCase(v) || "f".equalsIgnoreCase(v) || "no".equalsIgnoreCase(v) || "n".equalsIgnoreCase(v)) {
            v = "false";
        }
        return v;
    }

    public boolean getBoolean(String key) {
        String v = this.getProperty(key);
        return v != null && "true".equals(v);
    }

    public boolean getBoolean(String key, boolean def) {
        String v = this.getProperty(key);
        if (v != null) {
            return "true".equals(v);
        }
        return def;
    }

    public String[] getStringEnumeration(String baseKey, int maxSize) {
        String[] arr = new String[maxSize];
        int max = -1;
        StringBuilder sb = new StringBuilder(baseKey);
        sb.append('.');
        int len = baseKey.length() + 1;
        for (int i = 0; i < maxSize; ++i) {
            sb.setLength(len);
            sb.append(i);
            String v = this.getString(sb.toString());
            if (v == null) continue;
            arr[i] = v;
            max = i;
        }
        if (max >= 0) {
            if (++max < maxSize) {
                String[] a = new String[max];
                System.arraycopy(arr, 0, a, 0, max);
                return a;
            }
            return arr;
        }
        return null;
    }

    public int[] getIntArray(String key) throws Exception {
        String v = this.getProperty(key);
        if (v != null) {
            int i;
            String[] sa = v.split("[:;, ]+");
            int[] a = new int[sa.length];
            try {
                for (i = 0; i < sa.length; ++i) {
                    a[i] = Integer.parseInt(sa[i]);
                }
                return a;
            }
            catch (NumberFormatException nfx) {
                throw new Exception("illegal int[] element in '" + key + "' = \"" + sa[i] + '\"');
            }
        }
        return null;
    }

    public long getDuration(String key, long defValue) {
        String v = this.getProperty(key);
        if (v != null) {
            long d = 0L;
            if (v.indexOf(58) > 0) {
                String[] a = v.split(":");
                if (a.length > 3) {
                    return defValue;
                }
                int m = 1000;
                int i = a.length - 1;
                while (i >= 0) {
                    try {
                        int n = Integer.parseInt(a[i]);
                        d += (long)(m * n);
                    }
                    catch (NumberFormatException nfx) {
                        return defValue;
                    }
                    --i;
                    m *= 60;
                }
            } else {
                try {
                    d = Long.parseLong(v);
                }
                catch (NumberFormatException nfx) {
                    return defValue;
                }
            }
            return d;
        }
        return defValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defValue) {
        String v = this.getProperty(key);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException nfx) {
                return defValue;
            }
        }
        return defValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defValue) {
        String v = this.getProperty(key);
        if (v != null) {
            try {
                return Long.parseLong(v);
            }
            catch (NumberFormatException nfx) {
                return defValue;
            }
        }
        return defValue;
    }

    public long[] getLongArray(String key) throws Exception {
        String v = this.getProperty(key);
        if (v != null) {
            int i;
            String[] sa = v.split("[:;, ]+");
            long[] a = new long[sa.length];
            try {
                for (i = 0; i < sa.length; ++i) {
                    a[i] = Long.parseLong(sa[i]);
                }
                return a;
            }
            catch (NumberFormatException nfx) {
                throw new Exception("illegal long[] element in " + key + " = " + sa[i]);
            }
        }
        return null;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defValue) {
        String v = this.getProperty(key);
        if (v != null) {
            try {
                return Double.parseDouble(v);
            }
            catch (NumberFormatException nfx) {
                return defValue;
            }
        }
        return defValue;
    }

    public double[] getDoubleArray(String key) throws Exception {
        String v = this.getProperty(key);
        if (v != null) {
            int i;
            String[] sa = v.split("[:;, ]+");
            double[] a = new double[sa.length];
            try {
                for (i = 0; i < sa.length; ++i) {
                    a[i] = Double.parseDouble(sa[i]);
                }
                return a;
            }
            catch (NumberFormatException nfx) {
                throw new Exception("illegal double[] element in " + key + " = " + sa[i]);
            }
        }
        return null;
    }

    public String getString(String key) {
        return this.getProperty(key);
    }

    public String getString(String key, String defValue) {
        String s = this.getProperty(key);
        if (s != null) {
            return s;
        }
        return defValue;
    }

    public String expandString(String s) {
        int i;
        int j = 0;
        if (s == null || s.length() == 0) {
            return s;
        }
        while ((i = s.indexOf("${", j)) >= 0) {
            j = s.indexOf(125, i);
            if (j <= 0) continue;
            String k = s.substring(i + 2, j);
            String v = this.getString(k);
            if (v == null) {
                v = System.getProperty(k);
            }
            if (v != null) {
                s = s.substring(0, i) + v + s.substring(j + 1, s.length());
                j = i + v.length();
                continue;
            }
            s = s.substring(0, i) + s.substring(j + 1, s.length());
            j = i;
        }
        return s;
    }

    public String getExpandedString(String key) {
        return this.expandString(this.getString(key));
    }

    public long getMemorySize(String key, long defValue) {
        String v = this.getProperty(key);
        long sz = defValue;
        if (v != null) {
            int n = v.length() - 1;
            try {
                char c = v.charAt(n);
                sz = c == 'M' || c == 'm' ? Long.parseLong(v.substring(0, n)) << 20 : (c == 'K' || c == 'k' ? Long.parseLong(v.substring(0, n)) << 10 : Long.parseLong(v));
            }
            catch (NumberFormatException nfx) {
                return defValue;
            }
        }
        return sz;
    }

    public HashSet<String> getStringSet(String key) {
        String v = this.getProperty(key);
        if (v != null) {
            HashSet<String> hs = new HashSet<String>();
            for (String s : v.split(DELIMS)) {
                hs.add(s);
            }
            return hs;
        }
        return null;
    }

    public HashSet<String> getNonEmptyStringSet(String key) {
        HashSet<String> hs = this.getStringSet(key);
        if (hs != null && hs.isEmpty()) {
            return null;
        }
        return hs;
    }

    public String[] asExpandedStringArray(String v) {
        if ((v = this.expandString(v)) != null) {
            return v.split(DELIMS);
        }
        return null;
    }

    public String[] getExpandedStringArray(String key) {
        String v = this.getExpandedString(key);
        if (v != null) {
            return v.split(DELIMS);
        }
        return null;
    }

    public String[] getStringArray(String key) {
        String v = this.getProperty(key);
        if (v != null) {
            return v.split(DELIMS);
        }
        return null;
    }

    public String[] getStringArray(String key, String[] def) {
        String v = this.getProperty(key);
        if (v != null) {
            return v.split(DELIMS);
        }
        return def;
    }

    String getIdPart(String key) {
        int i;
        String v = this.getProperty(key);
        if (v != null && v.length() > 0 && (i = v.indexOf(64)) >= 0) {
            return v.substring(i + 1);
        }
        return null;
    }

    public Class<?> asClass(String v) throws Exception {
        if (v != null && v.length() > 0) {
            v = this.stripId(v);
            v = this.expandClassName(v);
            try {
                return this.loader.loadClass(v);
            }
            catch (ClassNotFoundException cfx) {
                throw new Exception("class not found " + v);
            }
            catch (ExceptionInInitializerError ix) {
                throw new Exception("class initialization of " + v + " failed: " + ix, ix);
            }
        }
        return null;
    }

    public <T> Class<? extends T> getClass(String key, Class<T> type) throws Exception {
        Class<?> cls = this.asClass(this.getProperty(key));
        if (cls != null) {
            if (type.isAssignableFrom(cls)) {
                return cls.asSubclass(type);
            }
            throw new Exception("classname entry for: \"" + key + "\" not of type: " + type.getName());
        }
        return null;
    }

    public Class<?> getClass(String key) throws Exception {
        return this.asClass(this.getProperty(key));
    }

    public Class<?> getEssentialClass(String key) throws Exception {
        Class<?> cls = this.getClass(key);
        if (cls == null) {
            throw new Exception("no classname entry for: \"" + key + "\"");
        }
        return cls;
    }

    String stripId(String v) {
        int i = v.indexOf(64);
        if (i >= 0) {
            return v.substring(0, i);
        }
        return v;
    }

    String getId(String v) {
        int i = v.indexOf(64);
        if (i >= 0) {
            return v.substring(i + 1);
        }
        return null;
    }

    String expandClassName(String clsName) {
        if (clsName.charAt(0) == '.') {
            return "gov.nasa.jpf" + clsName;
        }
        return clsName;
    }

    public Class<?>[] getClasses(String key) throws Exception {
        String[] v = this.getStringArray(key);
        if (v != null) {
            int n = v.length;
            Class[] a = new Class[n];
            for (int i = 0; i < n; ++i) {
                String clsName = this.expandClassName(v[i]);
                try {
                    clsName = this.stripId(clsName);
                    a[i] = this.loader.loadClass(clsName);
                    continue;
                }
                catch (ClassNotFoundException cnfx) {
                    throw new Exception("class not found " + v[i]);
                }
                catch (ExceptionInInitializerError ix) {
                    throw new Exception("class initialization of " + v[i] + " failed: " + ix, ix);
                }
            }
            return a;
        }
        return null;
    }

    String[] getIds(String key) {
        int i;
        String v = this.getProperty(key);
        if (v != null && (i = v.indexOf(64)) >= 0) {
            String[] a = v.split(DELIMS);
            String[] ids = new String[a.length];
            for (i = 0; i < a.length; ++i) {
                ids[i] = this.getId(a[i]);
            }
            return ids;
        }
        return null;
    }

    public <T> ObjArray<T> getInstances(String key, Class<T> type) throws Exception {
        Class[] argTypes = new Class[]{Config.class};
        Object[] args = new Object[]{this};
        return this.getInstances(key, type, argTypes, args);
    }

    public <T> ObjArray<T> getInstances(String key, Class<T> type, Class<?>[] argTypes, Object[] args) throws Exception {
        Class<?>[] c = this.getClasses(key);
        if (c != null) {
            String[] ids = this.getIds(key);
            ObjArray<T> a = new ObjArray<T>(c.length);
            for (int i = 0; i < c.length; ++i) {
                String id = ids != null ? ids[i] : null;
                T listener = this.getInstance(key, c[i], type, argTypes, args, id);
                if (listener == null) continue;
                a.set(i, listener);
            }
            return a;
        }
        return null;
    }

    public <T> T getInstance(String key, Class<T> type, String defClsName) throws Exception {
        Class<?>[] argTypes = CONFIG_ARGTYPES;
        Object[] args = this.CONFIG_ARGS;
        Class<?> cls = this.getClass(key);
        String id = this.getIdPart(key);
        if (cls == null) {
            try {
                cls = this.loader.loadClass(defClsName);
            }
            catch (ClassNotFoundException cfx) {
                throw new Exception("class not found " + defClsName);
            }
            catch (ExceptionInInitializerError ix) {
                throw new Exception("class initialization of " + defClsName + " failed: " + ix, ix);
            }
        }
        return this.getInstance(key, cls, type, argTypes, args, id);
    }

    public <T> T getInstance(String key, Class<T> type) throws Exception {
        Class<?>[] argTypes = CONFIG_ARGTYPES;
        Object[] args = this.CONFIG_ARGS;
        return this.getInstance(key, type, argTypes, args);
    }

    public <T> T getInstance(String key, Class<T> type, Class<?>[] argTypes, Object[] args) throws Exception {
        Class<?> cls = this.getClass(key);
        String id = this.getIdPart(key);
        if (cls != null) {
            return this.getInstance(key, cls, type, argTypes, args, id);
        }
        return null;
    }

    public <T> T getInstance(String key, Class<T> type, Object arg1, Object arg2) throws Exception {
        Class[] argTypes = new Class[]{arg1.getClass(), arg2.getClass()};
        Object[] args = new Object[]{arg1, arg2};
        return this.getInstance(key, type, argTypes, args);
    }

    public <T> T getEssentialInstance(String key, Class<T> type) throws Exception {
        Class[] argTypes = new Class[]{Config.class};
        Object[] args = new Object[]{this};
        return this.getEssentialInstance(key, type, argTypes, args);
    }

    public <T> T getEssentialInstance(String key, Class<T> type, Object arg1, Object arg2) throws Exception {
        Class[] argTypes = new Class[]{arg1.getClass(), arg2.getClass()};
        Object[] args = new Object[]{arg1, arg2};
        return this.getEssentialInstance(key, type, argTypes, args);
    }

    public <T> T getEssentialInstance(String key, Class<T> type, Class<?>[] argTypes, Object[] args) throws Exception {
        Class<?> cls = this.getEssentialClass(key);
        String id = this.getIdPart(key);
        return this.getInstance(key, cls, type, argTypes, args, id);
    }

    public <T> T getInstance(String id, String clsName, Class<T> type) throws Exception {
        Class<?>[] argTypes = CONFIG_ARGTYPES;
        Object[] args = this.CONFIG_ARGS;
        Class<?> cls = this.asClass(clsName);
        if (cls != null) {
            return this.getInstance(id, cls, type, argTypes, args, id);
        }
        return null;
    }

    <T> T getInstance(String key, Class<?> cls, Class<T> type, Class<?>[] argTypes, Object[] args, String id) throws Exception {
        Object o = null;
        Constructor<?> ctor = null;
        if (cls == null) {
            return null;
        }
        if (id != null) {
            if (this.singletons == null) {
                this.singletons = new HashMap();
            } else {
                o = type.cast(this.singletons.get(id));
            }
        }
        while (o == null) {
            try {
                ctor = cls.getConstructor(argTypes);
                o = ctor.newInstance(args);
            }
            catch (NoSuchMethodException nmx) {
                if (argTypes.length > 1 || argTypes.length == 1 && argTypes[0] != Config.class) {
                    argTypes = CONFIG_ARGTYPES;
                    args = this.CONFIG_ARGS;
                    continue;
                }
                if (argTypes.length > 0) {
                    argTypes = NO_ARGTYPES;
                    args = NO_ARGS;
                    continue;
                }
                throw new Exception(key, cls, "no suitable ctor found");
            }
            catch (IllegalAccessException iacc) {
                throw new Exception(key, cls, "\n> ctor not accessible: " + this.getMethodSignature(ctor));
            }
            catch (IllegalArgumentException iarg) {
                throw new Exception(key, cls, "\n> illegal constructor arguments: " + this.getMethodSignature(ctor));
            }
            catch (InvocationTargetException ix) {
                Throwable tx = ix.getTargetException();
                if (tx instanceof Exception) {
                    throw new Exception(tx.getMessage() + "\n> used within \"" + key + "\" instantiation of " + cls);
                }
                throw new Exception(key, cls, "\n> exception in " + this.getMethodSignature(ctor) + ":\n>> " + tx, tx);
            }
            catch (InstantiationException ivt) {
                throw new Exception(key, cls, "\n> abstract class cannot be instantiated");
            }
            catch (ExceptionInInitializerError eie) {
                throw new Exception(key, cls, "\n> static initialization failed:\n>> " + eie.getException(), eie.getException());
            }
        }
        if (!type.isInstance(o)) {
            throw new Exception(key, cls, "\n> instance not of type: " + type.getName());
        }
        if (id != null) {
            this.singletons.put(id, o);
        }
        return type.cast(o);
    }

    String getMethodSignature(Constructor<?> ctor) {
        StringBuilder sb = new StringBuilder(ctor.getName());
        sb.append('(');
        Class<?>[] argTypes = ctor.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(argTypes[i].getName());
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean hasArg(String regex) {
        if (this.freeArgs == null) {
            return false;
        }
        for (int i = 0; i < this.freeArgs.length; ++i) {
            if (!this.freeArgs[i].matches(regex)) continue;
            return true;
        }
        return false;
    }

    public boolean hasValue(String key) {
        String v = this.getProperty(key);
        return v != null && v.length() > 0;
    }

    public boolean hasValueIgnoreCase(String key, String value) {
        String v = this.getProperty(key);
        if (v != null) {
            return v.equalsIgnoreCase(value);
        }
        return false;
    }

    public int getChoiceIndexIgnoreCase(String key, String[] choices) {
        String v = this.getProperty(key);
        if (v != null && choices != null) {
            for (int i = 0; i < choices.length; ++i) {
                if (!v.equalsIgnoreCase(choices[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public String asCanonicalWindowsPath(String p) {
        boolean changed = false;
        p = this.expandString(p);
        int n = p.length();
        char[] buf = new char[n];
        p.getChars(0, n, buf, 0);
        for (int i = 0; i < n; ++i) {
            int i1;
            char c = buf[i];
            if (c == '/' || c == '\\') {
                if (c == '/') {
                    buf[i] = 92;
                    changed = true;
                }
                i1 = i + 1;
                c = buf[i1];
                while (i1 < n && (c == '/' || c == '\\')) {
                    System.arraycopy(buf, i + 2, buf, i1, n - (i + 2));
                    --n;
                    changed = true;
                    c = buf[i1];
                }
            } else if (c == ':') {
                i1 = i + 1;
                if (!(i1 >= n || buf[i1] != '\\' && buf[i1] != '/' || i <= 0 || i != 1 && buf[i - 2] != ';')) continue;
                buf[i] = 59;
                changed = true;
            } else if (c == ',') {
                buf[i] = 59;
                changed = true;
            }
            if (buf[i] != ';' || (i1 = i + 1) >= n) continue;
            c = buf[i1];
            while (c == ':' || c == ';' || c == ',') {
                System.arraycopy(buf, i + 2, buf, i1, n - (i + 2));
                --n;
                changed = true;
                c = buf[i1];
            }
        }
        if (changed) {
            p = new String(buf, 0, n);
        }
        return p;
    }

    public String asCanonicalUnixPath(String p) {
        boolean changed = false;
        p = this.expandString(p);
        int n = p.length();
        char[] buf = new char[n];
        p.getChars(0, n, buf, 0);
        for (int i = 0; i < n; ++i) {
            int i1;
            char c = buf[i];
            if (c == '/' || c == '\\') {
                if (c == '\\') {
                    buf[i] = 47;
                    changed = true;
                }
                i1 = i + 1;
                c = buf[i1];
                while (i1 < n && (c == '/' || c == '\\')) {
                    System.arraycopy(buf, i + 2, buf, i1, n - (i + 2));
                    --n;
                    changed = true;
                    c = buf[i1];
                }
            } else if (c == ':') {
                i1 = i + 1;
                if (i1 < n && buf[i1] == '\\' && i > 0 && (i == 1 || buf[i - 2] == ':')) {
                    System.arraycopy(buf, i1, buf, i - 1, n - i1);
                    n -= 2;
                    changed = true;
                }
            } else if (c == ';') {
                buf[i] = 58;
                changed = true;
            } else if (c == ',') {
                buf[i] = 58;
                changed = true;
            }
            if (buf[i] != ':' || (i1 = i + 1) >= n) continue;
            c = buf[i1];
            while (c == ':' || c == ';' || c == ',') {
                System.arraycopy(buf, i + 2, buf, i1, n - (i + 2));
                --n;
                changed = true;
                c = buf[i1];
            }
        }
        if (changed) {
            p = new String(buf, 0, n);
        }
        return p;
    }

    public String asPlatformPath(String p) {
        p = File.separatorChar == '/' ? this.asCanonicalUnixPath(p) : this.asCanonicalWindowsPath(p);
        return p;
    }

    public File[] getPathArray(String key) {
        String[] pe;
        String v = this.getProperty(key);
        if (v != null && (pe = v.split(PATH_SEPARATORS)) != null && pe.length > 0) {
            File[] files = new File[pe.length];
            for (int i = 0; i < files.length; ++i) {
                String path = this.asPlatformPath(pe[i]);
                files[i] = new File(path);
            }
            return files;
        }
        return null;
    }

    public File getPath(String key) {
        String v = this.getProperty(key);
        if (v != null) {
            return new File(this.asPlatformPath(v));
        }
        return null;
    }

    public ClassLoader getClassLoader(String classpathKey) throws Exception {
        ClassLoader currentLoader = Config.class.getClassLoader();
        File[] pathElements = this.getPathArray(classpathKey);
        if (pathElements != null && pathElements.length > 0) {
            try {
                URL[] urls = new URL[pathElements.length];
                for (int i = 0; i < pathElements.length; ++i) {
                    urls[i] = pathElements[i].toURI().toURL();
                }
                return new URLClassLoader(urls, currentLoader);
            }
            catch (MalformedURLException x) {
                throw new Exception("malformed classpath for " + classpathKey + " : " + x.getMessage());
            }
        }
        return currentLoader;
    }

    public String append(String key, String value) {
        return this.append(key, value, LIST_SEPARATOR);
    }

    public String append(String key, String value, String separator) {
        String newValue;
        String oldValue = this.getProperty(key);
        value = this.normalize(value);
        if (oldValue != null) {
            StringBuilder sb = new StringBuilder(oldValue);
            if (separator != null) {
                sb.append(separator);
            }
            sb.append(value);
            newValue = sb.toString();
        } else {
            newValue = value;
        }
        this.put(key, newValue);
        this.notifyPropertyChangeListeners(key, oldValue, newValue);
        return oldValue;
    }

    @Override
    public Object setProperty(String key, String newValue) {
        String oldValue = this.getProperty(key);
        newValue = this.normalize(newValue);
        this.put(key, newValue);
        this.notifyPropertyChangeListeners(key, oldValue, newValue);
        return oldValue;
    }

    public void parse(String s) {
        int i = s.indexOf("=");
        if (i > 0) {
            if (i > 1 && s.charAt(i - 1) == '+') {
                String key = s.substring(0, i - 1).trim();
                String val = s.substring(i + 1);
                this.append(key, val);
            } else {
                String key = s.substring(0, i).trim();
                String val = s.substring(i + 1);
                this.setProperty(key, val);
            }
        }
    }

    protected void notifyPropertyChangeListeners(String key, String oldValue, String newValue) {
        if (this.changeListeners != null) {
            for (ConfigChangeListener l : this.changeListeners) {
                l.propertyChanged(this, key, oldValue, newValue);
            }
        }
    }

    public TreeMap<Object, Object> asOrderedMap() {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(this.defaults);
        map.putAll(this);
        return map;
    }

    public void print(PrintWriter pw) {
        pw.println("----------- dictionary contents");
        TreeSet<String> kset = new TreeSet<String>();
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            if (!(k instanceof String)) continue;
            kset.add((String)k);
        }
        for (String key : kset) {
            String val = this.getExpandedString(key);
            pw.print(key);
            pw.print(" = ");
            pw.println(val);
        }
        if (this.freeArgs != null && this.freeArgs.length > 0) {
            pw.println("----------- free arguments");
            for (int i = 0; i < this.freeArgs.length; ++i) {
                pw.println(this.freeArgs[i]);
            }
        }
        pw.flush();
    }

    public void printStatus(Logger log) {
        log.config("configuration initialized from: " + this.getSourceName());
        Config def = (Config)this.defaults;
        if (def.source == null) {
            log.warning("no defaults.properties found");
        } else {
            log.config("default configuration initialized from: " + def.getSourceName());
        }
    }

    public class Exception
    extends java.lang.Exception {
        public Exception(String msg) {
            super(msg);
        }

        public Exception(String msg, Throwable cause) {
            super(msg, cause);
        }

        public Exception(String key, Class<?> cls, String failure) {
            super("error instantiating class " + cls.getName() + " for entry \"" + key + "\":" + failure);
        }

        public Exception(String key, Class<?> cls, String failure, Throwable cause) {
            this(key, cls, failure);
            this.initCause(cause);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("JPF configuration error: ");
            sb.append(this.getMessage());
            return sb.toString();
        }

        public Config getConfig() {
            return Config.this;
        }
    }
}

