/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.Subroutine;

public class Subroutines {
    private static final Integer WHITE = new Integer(0);
    private static final Integer GRAY = new Integer(1);
    private static final Integer BLACK = new Integer(2);
    private Map subroutines = new HashMap();
    public final Subroutine TOPLEVEL;

    public Subroutines(MethodGen methodGen) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        InstructionHandle[] instructionHandleArray = methodGen.getInstructionList().getInstructionHandles();
        CodeExceptionGen[] codeExceptionGenArray = methodGen.getExceptionHandlers();
        this.TOPLEVEL = new SubroutineImpl();
        HashSet<InstructionHandle> hashSet = new HashSet<InstructionHandle>();
        for (int i = 0; i < instructionHandleArray.length; ++i) {
            object = instructionHandleArray[i].getInstruction();
            if (!(object instanceof JsrInstruction)) continue;
            hashSet.add(((JsrInstruction)object).getTarget());
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = new SubroutineImpl();
            serializable2 = (InstructionHandle)iterator.next();
            ((SubroutineImpl)object).setLocalVariable(((ASTORE)((InstructionHandle)serializable2).getInstruction()).getIndex());
            this.subroutines.put(serializable2, object);
        }
        this.subroutines.put(instructionHandleArray[0], this.TOPLEVEL);
        hashSet.add(instructionHandleArray[0]);
        for (int i = 0; i < instructionHandleArray.length; ++i) {
            serializable2 = instructionHandleArray[i].getInstruction();
            if (!(serializable2 instanceof JsrInstruction)) continue;
            InstructionHandle instructionHandle = ((JsrInstruction)serializable2).getTarget();
            ((SubroutineImpl)this.getSubroutine(instructionHandle)).addEnteringJsrInstruction(instructionHandleArray[i]);
        }
        HashSet<InstructionHandle> hashSet2 = new HashSet<InstructionHandle>();
        serializable2 = new HashMap();
        for (InstructionHandle instructionHandle : hashSet) {
            int n;
            for (int i = 0; i < instructionHandleArray.length; ++i) {
                serializable2.put(instructionHandleArray[i], WHITE);
            }
            serializable2.put(instructionHandle, GRAY);
            serializable = new ArrayList();
            ((ArrayList)serializable).add(instructionHandle);
            if (instructionHandle == instructionHandleArray[0]) {
                for (n = 0; n < codeExceptionGenArray.length; ++n) {
                    serializable2.put(codeExceptionGenArray[n].getHandlerPC(), GRAY);
                    ((ArrayList)serializable).add(codeExceptionGenArray[n].getHandlerPC());
                }
            }
            while (((ArrayList)serializable).size() != 0) {
                InstructionHandle instructionHandle2 = (InstructionHandle)((ArrayList)serializable).remove(0);
                InstructionHandle[] instructionHandleArray2 = Subroutines.getSuccessors(instructionHandle2);
                for (int i = 0; i < instructionHandleArray2.length; ++i) {
                    if ((Integer)serializable2.get(instructionHandleArray2[i]) != WHITE) continue;
                    serializable2.put(instructionHandleArray2[i], GRAY);
                    ((ArrayList)serializable).add(instructionHandleArray2[i]);
                }
                serializable2.put(instructionHandle2, BLACK);
            }
            for (n = 0; n < instructionHandleArray.length; ++n) {
                if (serializable2.get(instructionHandleArray[n]) != BLACK) continue;
                ((SubroutineImpl)(instructionHandle == instructionHandleArray[0] ? this.getTopLevel() : this.getSubroutine(instructionHandle))).addInstruction(instructionHandleArray[n]);
                if (hashSet2.contains(instructionHandleArray[n])) {
                    throw new StructuralCodeConstraintException("Instruction '" + instructionHandleArray[n] + "' is part of more than one subroutine (or of the top level and a subroutine).");
                }
                hashSet2.add(instructionHandleArray[n]);
            }
            if (instructionHandle == instructionHandleArray[0]) continue;
            ((SubroutineImpl)this.getSubroutine(instructionHandle)).setLeavingRET();
        }
        for (int i = 0; i < codeExceptionGenArray.length; ++i) {
            for (serializable = codeExceptionGenArray[i].getStartPC(); serializable != codeExceptionGenArray[i].getEndPC().getNext(); serializable = ((InstructionHandle)serializable).getNext()) {
                for (InstructionHandle[] instructionHandleArray2 : this.subroutines.values()) {
                    if (instructionHandleArray2 == this.subroutines.get(instructionHandleArray[0]) || !instructionHandleArray2.contains((InstructionHandle)serializable)) continue;
                    throw new StructuralCodeConstraintException("Subroutine instruction '" + serializable + "' is protected by an exception handler, '" + codeExceptionGenArray[i] + "'. This is forbidden by the JustIce verifier due to its clear definition of subroutines.");
                }
            }
        }
        this.noRecursiveCalls(this.getTopLevel(), new HashSet());
    }

    private void noRecursiveCalls(Subroutine subroutine, Set set) {
        Subroutine[] subroutineArray = subroutine.subSubs();
        for (int i = 0; i < subroutineArray.length; ++i) {
            int n = ((RET)subroutineArray[i].getLeavingRET().getInstruction()).getIndex();
            if (!set.add(new Integer(n))) {
                SubroutineImpl subroutineImpl = (SubroutineImpl)subroutineArray[i];
                throw new StructuralCodeConstraintException("Subroutine with local variable '" + subroutineImpl.localVariable + "', JSRs '" + subroutineImpl.theJSRs + "', RET '" + subroutineImpl.theRET + "' is called by a subroutine which uses the same local variable index as itself; maybe even a recursive call? JustIce's clean definition of a subroutine forbids both.");
            }
            this.noRecursiveCalls(subroutineArray[i], set);
            set.remove(new Integer(n));
        }
    }

    public Subroutine getSubroutine(InstructionHandle instructionHandle) {
        Subroutine subroutine = (Subroutine)this.subroutines.get(instructionHandle);
        if (subroutine == null) {
            throw new AssertionViolatedException("Subroutine requested for an InstructionHandle that is not a leader of a subroutine.");
        }
        if (subroutine == this.TOPLEVEL) {
            throw new AssertionViolatedException("TOPLEVEL special subroutine requested; use getTopLevel().");
        }
        return subroutine;
    }

    public Subroutine subroutineOf(InstructionHandle instructionHandle) {
        for (Subroutine subroutine : this.subroutines.values()) {
            if (!subroutine.contains(instructionHandle)) continue;
            return subroutine;
        }
        System.err.println("DEBUG: Please verify '" + instructionHandle.toString(true) + "' lies in dead code.");
        return null;
    }

    public Subroutine getTopLevel() {
        return this.TOPLEVEL;
    }

    private static InstructionHandle[] getSuccessors(InstructionHandle instructionHandle) {
        InstructionHandle[] instructionHandleArray = new InstructionHandle[]{};
        InstructionHandle[] instructionHandleArray2 = new InstructionHandle[1];
        InstructionHandle[] instructionHandleArray3 = new InstructionHandle[2];
        Instruction instruction = instructionHandle.getInstruction();
        if (instruction instanceof RET) {
            return instructionHandleArray;
        }
        if (instruction instanceof ReturnInstruction) {
            return instructionHandleArray;
        }
        if (instruction instanceof ATHROW) {
            return instructionHandleArray;
        }
        if (instruction instanceof JsrInstruction) {
            instructionHandleArray2[0] = instructionHandle.getNext();
            return instructionHandleArray2;
        }
        if (instruction instanceof GotoInstruction) {
            instructionHandleArray2[0] = ((GotoInstruction)instruction).getTarget();
            return instructionHandleArray2;
        }
        if (instruction instanceof BranchInstruction) {
            if (instruction instanceof Select) {
                InstructionHandle[] instructionHandleArray4 = ((Select)instruction).getTargets();
                InstructionHandle[] instructionHandleArray5 = new InstructionHandle[instructionHandleArray4.length + 1];
                instructionHandleArray5[0] = ((Select)instruction).getTarget();
                System.arraycopy(instructionHandleArray4, 0, instructionHandleArray5, 1, instructionHandleArray4.length);
                return instructionHandleArray5;
            }
            instructionHandleArray3[0] = instructionHandle.getNext();
            instructionHandleArray3[1] = ((BranchInstruction)instruction).getTarget();
            return instructionHandleArray3;
        }
        instructionHandleArray2[0] = instructionHandle.getNext();
        return instructionHandleArray2;
    }

    public String toString() {
        return "---\n" + this.subroutines.toString() + "\n---\n";
    }

    private class SubroutineImpl
    implements Subroutine {
        private static final int UNSET = -1;
        private int localVariable = -1;
        private Set instructions = new HashSet();
        private Set theJSRs = new HashSet();
        private InstructionHandle theRET;

        public boolean contains(InstructionHandle instructionHandle) {
            return this.instructions.contains(instructionHandle);
        }

        public String toString() {
            int n;
            String string = "Subroutine: Local variable is '" + this.localVariable + "', JSRs are '" + this.theJSRs + "', RET is '" + this.theRET + "', Instructions: '" + this.instructions.toString() + "'.";
            string = string + " Accessed local variable slots: '";
            int[] nArray = this.getAccessedLocalsIndices();
            for (n = 0; n < nArray.length; ++n) {
                string = string + nArray[n] + " ";
            }
            string = string + "'.";
            string = string + " Recursively (via subsub...routines) accessed local variable slots: '";
            nArray = this.getRecursivelyAccessedLocalsIndices();
            for (n = 0; n < nArray.length; ++n) {
                string = string + nArray[n] + " ";
            }
            string = string + "'.";
            return string;
        }

        void setLeavingRET() {
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("setLeavingRET() called for top-level 'subroutine' or forgot to set local variable first.");
            }
            Iterator iterator = this.instructions.iterator();
            InstructionHandle instructionHandle = null;
            while (iterator.hasNext()) {
                InstructionHandle instructionHandle2 = (InstructionHandle)iterator.next();
                if (!(instructionHandle2.getInstruction() instanceof RET)) continue;
                if (instructionHandle != null) {
                    throw new StructuralCodeConstraintException("Subroutine with more then one RET detected: '" + instructionHandle + "' and '" + instructionHandle2 + "'.");
                }
                instructionHandle = instructionHandle2;
            }
            if (instructionHandle == null) {
                throw new StructuralCodeConstraintException("Subroutine without a RET detected.");
            }
            if (((RET)instructionHandle.getInstruction()).getIndex() != this.localVariable) {
                throw new StructuralCodeConstraintException("Subroutine uses '" + instructionHandle + "' which does not match the correct local variable '" + this.localVariable + "'.");
            }
            this.theRET = instructionHandle;
        }

        public InstructionHandle[] getEnteringJsrInstructions() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            InstructionHandle[] instructionHandleArray = new InstructionHandle[this.theJSRs.size()];
            return this.theJSRs.toArray(instructionHandleArray);
        }

        public void addEnteringJsrInstruction(InstructionHandle instructionHandle) {
            if (instructionHandle == null || !(instructionHandle.getInstruction() instanceof JsrInstruction)) {
                throw new AssertionViolatedException("Expecting JsrInstruction InstructionHandle.");
            }
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("Set the localVariable first!");
            }
            if (this.localVariable != ((ASTORE)((JsrInstruction)instructionHandle.getInstruction()).getTarget().getInstruction()).getIndex()) {
                throw new AssertionViolatedException("Setting a wrong JsrInstruction.");
            }
            this.theJSRs.add(instructionHandle);
        }

        public InstructionHandle getLeavingRET() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            return this.theRET;
        }

        public InstructionHandle[] getInstructions() {
            InstructionHandle[] instructionHandleArray = new InstructionHandle[this.instructions.size()];
            return this.instructions.toArray(instructionHandleArray);
        }

        void addInstruction(InstructionHandle instructionHandle) {
            if (this.theRET != null) {
                throw new AssertionViolatedException("All instructions must have been added before invoking setLeavingRET().");
            }
            this.instructions.add(instructionHandle);
        }

        public int[] getRecursivelyAccessedLocalsIndices() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int[] nArray = this.getAccessedLocalsIndices();
            for (int i = 0; i < nArray.length; ++i) {
                hashSet.add(new Integer(nArray[i]));
            }
            this._getRecursivelyAccessedLocalsIndicesHelper(hashSet, this.subSubs());
            int[] nArray2 = new int[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            int n = -1;
            while (iterator.hasNext()) {
                nArray2[++n] = (Integer)iterator.next();
            }
            return nArray2;
        }

        private void _getRecursivelyAccessedLocalsIndicesHelper(Set set, Subroutine[] subroutineArray) {
            for (int i = 0; i < subroutineArray.length; ++i) {
                int[] nArray = subroutineArray[i].getAccessedLocalsIndices();
                for (int j = 0; j < nArray.length; ++j) {
                    set.add(new Integer(nArray[j]));
                }
                if (subroutineArray[i].subSubs().length == 0) continue;
                this._getRecursivelyAccessedLocalsIndicesHelper(set, subroutineArray[i].subSubs());
            }
        }

        public int[] getAccessedLocalsIndices() {
            int n;
            Object object2;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (this.theRET == null && this != Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("This subroutine object must be built up completely before calculating accessed locals.");
            }
            for (Object object2 : this.instructions) {
                if (!(((InstructionHandle)object2).getInstruction() instanceof LocalVariableInstruction) && !(((InstructionHandle)object2).getInstruction() instanceof RET)) continue;
                n = ((IndexedInstruction)((Object)((InstructionHandle)object2).getInstruction())).getIndex();
                hashSet.add(new Integer(n));
                try {
                    int n2;
                    if (!(((InstructionHandle)object2).getInstruction() instanceof LocalVariableInstruction) || (n2 = ((LocalVariableInstruction)((InstructionHandle)object2).getInstruction()).getType(null).getSize()) != 2) continue;
                    hashSet.add(new Integer(n + 1));
                }
                catch (RuntimeException runtimeException) {
                    throw new AssertionViolatedException("Oops. BCEL did not like NULL as a ConstantPoolGen object.");
                }
            }
            object2 = new int[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            n = -1;
            while (iterator.hasNext()) {
                object2[++n] = (Integer)iterator.next();
            }
            return object2;
        }

        public Subroutine[] subSubs() {
            Object object;
            HashSet<Subroutine> hashSet = new HashSet<Subroutine>();
            Iterator iterator = this.instructions.iterator();
            while (iterator.hasNext()) {
                object = ((InstructionHandle)iterator.next()).getInstruction();
                if (!(object instanceof JsrInstruction)) continue;
                InstructionHandle instructionHandle = ((JsrInstruction)object).getTarget();
                hashSet.add(Subroutines.this.getSubroutine(instructionHandle));
            }
            object = new Subroutine[hashSet.size()];
            return hashSet.toArray((T[])object);
        }

        void setLocalVariable(int n) {
            if (this.localVariable != -1) {
                throw new AssertionViolatedException("localVariable set twice.");
            }
            this.localVariable = n;
        }
    }
}

