/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.verifier.structurals.ExceptionHandler;

public class ExceptionHandlers {
    private Map exceptionhandlers = new HashMap();

    public ExceptionHandlers(MethodGen methodGen) {
        CodeExceptionGen[] codeExceptionGenArray = methodGen.getExceptionHandlers();
        for (int i = 0; i < codeExceptionGenArray.length; ++i) {
            ExceptionHandler exceptionHandler = new ExceptionHandler(codeExceptionGenArray[i].getCatchType(), codeExceptionGenArray[i].getHandlerPC());
            for (InstructionHandle instructionHandle = codeExceptionGenArray[i].getStartPC(); instructionHandle != codeExceptionGenArray[i].getEndPC().getNext(); instructionHandle = instructionHandle.getNext()) {
                HashSet<ExceptionHandler> hashSet = (HashSet<ExceptionHandler>)this.exceptionhandlers.get(instructionHandle);
                if (hashSet == null) {
                    hashSet = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(instructionHandle, hashSet);
                }
                hashSet.add(exceptionHandler);
            }
        }
    }

    public ExceptionHandler[] getExceptionHandlers(InstructionHandle instructionHandle) {
        Set set = (Set)this.exceptionhandlers.get(instructionHandle);
        if (set == null) {
            return new ExceptionHandler[0];
        }
        ExceptionHandler[] exceptionHandlerArray = new ExceptionHandler[set.size()];
        return set.toArray(exceptionHandlerArray);
    }
}

