/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.VerifierFactoryObserver;

public class TransitiveHull
implements VerifierFactoryObserver {
    private int indent = 0;

    private TransitiveHull() {
    }

    public void update(String string) {
        System.gc();
        for (int i = 0; i < this.indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(string);
        ++this.indent;
        Verifier verifier = VerifierFactory.getVerifier(string);
        VerificationResult verificationResult = verifier.doPass1();
        if (verificationResult != VerificationResult.VR_OK) {
            System.out.println("Pass 1:\n" + verificationResult);
        }
        if ((verificationResult = verifier.doPass2()) != VerificationResult.VR_OK) {
            System.out.println("Pass 2:\n" + verificationResult);
        }
        if (verificationResult == VerificationResult.VR_OK) {
            try {
                JavaClass javaClass = Repository.lookupClass(verifier.getClassName());
                for (int i = 0; i < javaClass.getMethods().length; ++i) {
                    verificationResult = verifier.doPass3a(i);
                    if (verificationResult != VerificationResult.VR_OK) {
                        System.out.println(verifier.getClassName() + ", Pass 3a, method " + i + " ['" + javaClass.getMethods()[i] + "']:\n" + verificationResult);
                    }
                    if ((verificationResult = verifier.doPass3b(i)) == VerificationResult.VR_OK) continue;
                    System.out.println(verifier.getClassName() + ", Pass 3b, method " + i + " ['" + javaClass.getMethods()[i] + "']:\n" + verificationResult);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Could not find class " + verifier.getClassName() + " in Repository");
            }
        }
        --this.indent;
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length != 1) {
            System.out.println("Need exactly one argument: The root class to verify.");
            System.exit(1);
        }
        if ((n = stringArray[0].lastIndexOf(".class")) != -1) {
            stringArray[0] = stringArray[0].substring(0, n);
        }
        stringArray[0] = stringArray[0].replace('/', '.');
        TransitiveHull transitiveHull = new TransitiveHull();
        VerifierFactory.attach(transitiveHull);
        VerifierFactory.getVerifier(stringArray[0]);
        VerifierFactory.detach(transitiveHull);
    }
}

