/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class SyntheticRepository
implements Repository {
    private static final String DEFAULT_PATH = ClassPath.getClassPath();
    private static Map _instances = new HashMap();
    private ClassPath _path = null;
    private Map _loadedClasses = new HashMap();

    private SyntheticRepository(ClassPath classPath) {
        this._path = classPath;
    }

    public static SyntheticRepository getInstance() {
        return SyntheticRepository.getInstance(ClassPath.SYSTEM_CLASS_PATH);
    }

    public static SyntheticRepository getInstance(ClassPath classPath) {
        SyntheticRepository syntheticRepository = (SyntheticRepository)_instances.get(classPath);
        if (syntheticRepository == null) {
            syntheticRepository = new SyntheticRepository(classPath);
            _instances.put(classPath, syntheticRepository);
        }
        return syntheticRepository;
    }

    public void storeClass(JavaClass javaClass) {
        this._loadedClasses.put(javaClass.getClassName(), new SoftReference<JavaClass>(javaClass));
        javaClass.setRepository(this);
    }

    public void removeClass(JavaClass javaClass) {
        this._loadedClasses.remove(javaClass.getClassName());
    }

    public JavaClass findClass(String string) {
        SoftReference softReference = (SoftReference)this._loadedClasses.get(string);
        if (softReference == null) {
            return null;
        }
        return (JavaClass)softReference.get();
    }

    public JavaClass loadClass(String string) throws ClassNotFoundException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + string);
        }
        JavaClass javaClass = this.findClass(string = string.replace('/', '.'));
        if (javaClass != null) {
            return javaClass;
        }
        try {
            return this.loadClass(this._path.getInputStream(string), string);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException.toString());
        }
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        String string = clazz.getName();
        JavaClass javaClass = this.findClass(string);
        if (javaClass != null) {
            return javaClass;
        }
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        return this.loadClass(clazz.getResourceAsStream(string2 + ".class"), string);
    }

    private JavaClass loadClass(InputStream inputStream, String string) throws ClassNotFoundException {
        try {
            if (inputStream != null) {
                ClassParser classParser = new ClassParser(inputStream, string);
                JavaClass javaClass = classParser.parse();
                this.storeClass(javaClass);
                return javaClass;
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException.toString());
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + string);
    }

    public ClassPath getClassPath() {
        return this._path;
    }

    public void clear() {
        this._loadedClasses.clear();
    }
}

