/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;
import org.apache.bcel.generic.ObjectType;

public class ClassElementValueGen
extends ElementValueGen {
    private int idx;

    protected ClassElementValueGen(int n, ConstantPoolGen constantPoolGen) {
        super(99, constantPoolGen);
        this.idx = n;
    }

    public ClassElementValueGen(ObjectType objectType, ConstantPoolGen constantPoolGen) {
        super(99, constantPoolGen);
        this.idx = constantPoolGen.addUtf8(objectType.getSignature());
    }

    public ElementValue getElementValue() {
        return new ClassElementValue(this.type, this.idx, this.cpGen.getConstantPool());
    }

    public ClassElementValueGen(ClassElementValue classElementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        super(99, constantPoolGen);
        this.idx = bl ? constantPoolGen.addUtf8(classElementValue.getClassString()) : classElementValue.getIndex();
    }

    public int getIndex() {
        return this.idx;
    }

    public String getClassString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
        return constantUtf8.getBytes();
    }

    public String stringifyValue() {
        return this.getClassString();
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.idx);
    }
}

