/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;

public class SimpleElementValue
extends ElementValue {
    private int index;

    public SimpleElementValue(int n, int n2, ConstantPool constantPool) {
        super(n, constantPool);
        this.index = n2;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public String getValueString() {
        if (this.type != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.getIndex(), (byte)1);
        return constantUtf8.getBytes();
    }

    public int getValueInt() {
        if (this.type != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
        return constantInteger.getBytes();
    }

    public byte getValueByte() {
        if (this.type != 66) {
            throw new RuntimeException("Dont call getValueByte() on a non BYTE ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
        return (byte)constantInteger.getBytes();
    }

    public char getValueChar() {
        if (this.type != 67) {
            throw new RuntimeException("Dont call getValueChar() on a non CHAR ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
        return (char)constantInteger.getBytes();
    }

    public long getValueLong() {
        if (this.type != 74) {
            throw new RuntimeException("Dont call getValueLong() on a non LONG ElementValue");
        }
        ConstantLong constantLong = (ConstantLong)this.cpool.getConstant(this.getIndex());
        return constantLong.getBytes();
    }

    public float getValueFloat() {
        if (this.type != 70) {
            throw new RuntimeException("Dont call getValueFloat() on a non FLOAT ElementValue");
        }
        ConstantFloat constantFloat = (ConstantFloat)this.cpool.getConstant(this.getIndex());
        return constantFloat.getBytes();
    }

    public double getValueDouble() {
        if (this.type != 68) {
            throw new RuntimeException("Dont call getValueDouble() on a non DOUBLE ElementValue");
        }
        ConstantDouble constantDouble = (ConstantDouble)this.cpool.getConstant(this.getIndex());
        return constantDouble.getBytes();
    }

    public boolean getValueBoolean() {
        if (this.type != 90) {
            throw new RuntimeException("Dont call getValueBoolean() on a non BOOLEAN ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex());
        return constantInteger.getBytes() != 0;
    }

    public short getValueShort() {
        if (this.type != 83) {
            throw new RuntimeException("Dont call getValueShort() on a non SHORT ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex());
        return (short)constantInteger.getBytes();
    }

    public String toString() {
        return this.stringifyValue();
    }

    public String stringifyValue() {
        switch (this.type) {
            case 73: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(constantInteger.getBytes());
            }
            case 74: {
                ConstantLong constantLong = (ConstantLong)this.cpool.getConstant(this.getIndex(), (byte)5);
                return Long.toString(constantLong.getBytes());
            }
            case 68: {
                ConstantDouble constantDouble = (ConstantDouble)this.cpool.getConstant(this.getIndex(), (byte)6);
                return Double.toString(constantDouble.getBytes());
            }
            case 70: {
                ConstantFloat constantFloat = (ConstantFloat)this.cpool.getConstant(this.getIndex(), (byte)4);
                return Float.toString(constantFloat.getBytes());
            }
            case 83: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(constantInteger.getBytes());
            }
            case 66: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(constantInteger.getBytes());
            }
            case 67: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                return String.valueOf((char)constantInteger.getBytes());
            }
            case 90: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                if (constantInteger.getBytes() == 0) {
                    return "false";
                }
                if (constantInteger.getBytes() != 0) {
                    return "true";
                }
            }
            case 115: {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.getIndex(), (byte)1);
                return constantUtf8.getBytes();
            }
        }
        throw new RuntimeException("SimpleElementValue class does not know how to stringify type " + this.type);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        switch (this.type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dataOutputStream.writeShort(this.getIndex());
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValue doesnt know how to write out type " + this.type);
            }
        }
    }
}

