/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.util.Stack;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveKey;

class ClientVector
extends Stack
implements Runnable {
    private int num = 0;
    private KeepAliveCache cache;
    private KeepAliveKey key;
    HttpClient[] inUse;
    private int nap;

    ClientVector(KeepAliveCache keepAliveCache, KeepAliveKey keepAliveKey, int n) {
        this.cache = keepAliveCache;
        this.key = keepAliveKey;
        this.nap = n;
        this.inUse = new HttpClient[KeepAliveCache.getMaxConnections()];
    }

    synchronized HttpClient get() {
        if (this.empty()) {
            return null;
        }
        HttpClient httpClient = (HttpClient)this.pop();
        if (this.inUse.length == this.num) {
            HttpClient[] httpClientArray = new HttpClient[this.inUse.length * 2];
            System.arraycopy(this.inUse, 0, httpClientArray, 0, this.inUse.length);
            this.inUse = httpClientArray;
        }
        this.inUse[this.num++] = httpClient;
        return httpClient;
    }

    synchronized void put(HttpClient httpClient) {
        if (this.num > 0) {
            --this.num;
        }
        for (int i = 0; i < this.inUse.length; ++i) {
            if (this.inUse[i] != httpClient) continue;
            this.inUse[i] = null;
            break;
        }
        this.push(httpClient);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n;
        do {
            HttpClient httpClient;
            try {
                Thread.sleep(this.nap);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Cloneable cloneable = this.cache;
            synchronized (cloneable) {
                ClientVector clientVector = this;
                synchronized (clientVector) {
                    for (int i = 0; i < this.size(); ++i) {
                        httpClient = (HttpClient)this.elementAt(i);
                        httpClient.closeServer();
                    }
                    this.removeAllElements();
                    if (this.num == 0) {
                        this.cache.removeVector(this.key);
                        return;
                    }
                }
            }
            for (int i = 0; i < this.inUse.length; ++i) {
                httpClient = this.inUse[i];
                if (httpClient == null || !httpClient.kas.hurry()) continue;
                this.put(httpClient);
            }
            cloneable = this;
            synchronized (cloneable) {
                n = this.num + this.size();
            }
        } while (n > 0);
        this.cache.removeVector(this.key);
    }
}

