/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

public final class SizeEstimator {
    private long estimate = 0L;
    private long numberOfObjects = 0L;
    private static Object representativeObject = new Object();
    private static Class objectClass = representativeObject.getClass();
    private static int[] basicLengths = new int[]{0, 0, 4, 0, 1, 2, 4, 8, 1, 2, 4, 8, 0, 0, 0, 0, 0, 0};
    private static int CLASS_INDX = 2;
    private static int BOOLEAN_INDX = 4;
    private static int CHAR_INDX = 5;
    private static int FLOAT_INDX = 6;
    private static int DOUBLE_INDX = 7;
    private static int BYTE_INDX = 8;
    private static int SHORT_INDX = 9;
    private static int INT_INDX = 10;
    private static int LONG_INDX = 11;

    public void reserve(Class clazz, int n) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class passed was null");
        }
        this.estimate += (long)(n * this.sizeOf(clazz));
        this.numberOfObjects += (long)n;
    }

    public void reserve(SizeEstimator sizeEstimator, int n) {
        if (sizeEstimator == null) {
            throw new IllegalArgumentException("SizeEstimator object passed was null");
        }
        this.estimate += sizeEstimator.getEstimate() * (long)n;
    }

    public void reserve(SizeEstimator sizeEstimator) {
        this.reserve(sizeEstimator, 1);
    }

    public void reserveArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        this.estimate += (long)(this.arrayOverhead() + n * SizeEstimator.sizeOfRefEntry());
        ++this.numberOfObjects;
    }

    public void reserveArray(int n, Class clazz) {
        int n2 = 1;
        if (n < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        n2 = clazz == Byte.TYPE ? SizeEstimator.sizeOfByteEntry() : (clazz == Boolean.TYPE ? SizeEstimator.sizeOfBooleanEntry() : (clazz == Short.TYPE ? SizeEstimator.sizeOfShortEntry() : (clazz == Long.TYPE ? SizeEstimator.sizeOfLongEntry() : (clazz == Integer.TYPE ? SizeEstimator.sizeOfIntEntry() : (clazz == Character.TYPE ? SizeEstimator.sizeOfCharEntry() : (clazz == Float.TYPE ? SizeEstimator.sizeOfFloatEntry() : (clazz == Double.TYPE ? SizeEstimator.sizeOfDoubleEntry() : SizeEstimator.sizeOfRefEntry())))))));
        ++this.numberOfObjects;
        this.estimate += (long)(this.arrayOverhead() + n * n2);
    }

    public long getEstimate() {
        return this.estimate;
    }

    private native int sizeOf(Class var1);

    private int arrayOverhead() {
        return this.sizeOf(objectClass);
    }

    private static int sizeOfRefEntry() {
        return basicLengths[CLASS_INDX];
    }

    private static int sizeOfByteEntry() {
        return basicLengths[BYTE_INDX];
    }

    private static int sizeOfCharEntry() {
        return basicLengths[CHAR_INDX];
    }

    private static int sizeOfShortEntry() {
        return basicLengths[SHORT_INDX];
    }

    private static int sizeOfIntEntry() {
        return basicLengths[INT_INDX];
    }

    private static int sizeOfLongEntry() {
        return basicLengths[LONG_INDX];
    }

    private static int sizeOfFloatEntry() {
        return basicLengths[FLOAT_INDX];
    }

    private static int sizeOfDoubleEntry() {
        return basicLengths[DOUBLE_INDX];
    }

    private static int sizeOfBooleanEntry() {
        return basicLengths[BOOLEAN_INDX];
    }
}

