/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;

public class RelativeTime
extends HighResolutionTime {
    static RelativeTime zero = new RelativeTime();

    public RelativeTime() {
        this.set(0L, 0, Clock.getRealtimeClock());
    }

    public RelativeTime(Clock clock) {
        this(0L, 0, clock);
    }

    public RelativeTime(long l, int n) {
        this.set(l, n, Clock.getRealtimeClock(), true);
    }

    public RelativeTime(long l, int n, Clock clock) {
        this.set(l, n, clock == null ? Clock.getRealtimeClock() : clock, true);
    }

    public RelativeTime(RelativeTime relativeTime) {
        if (relativeTime == null) {
            throw new IllegalArgumentException("Illegal null argument");
        }
        this.set(relativeTime.getMilliseconds(), relativeTime.getNanoseconds(), relativeTime.getClock());
    }

    public RelativeTime(RelativeTime relativeTime, Clock clock) {
        if (relativeTime == null) {
            throw new IllegalArgumentException("Null time passed to RelativeTime constructor");
        }
        this.set(relativeTime.getMilliseconds(), relativeTime.getNanoseconds(), clock == null ? Clock.getRealtimeClock() : clock);
    }

    public AbsoluteTime absolute(Clock clock) {
        return this.absolute(clock, null);
    }

    public AbsoluteTime absolute(Clock clock, AbsoluteTime absoluteTime) {
        if (clock == null) {
            clock = Clock.getRealtimeClock();
        }
        if (absoluteTime == null) {
            absoluteTime = new AbsoluteTime();
        }
        clock.getTime().add(this.getMilliseconds(), this.getNanoseconds(), absoluteTime);
        absoluteTime.clock = clock;
        return absoluteTime;
    }

    public RelativeTime add(long l, int n) {
        return this.add(l, n, null);
    }

    public RelativeTime add(long l, int n, RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        if (HighResolutionTime.willOverrun(this.milliseconds, l)) {
            throw new ArithmeticException();
        }
        relativeTime.set(this.milliseconds + l, this.nanoseconds + n, this.clock, false);
        return relativeTime;
    }

    public RelativeTime add(RelativeTime relativeTime) {
        return this.add(relativeTime, null);
    }

    public RelativeTime add(RelativeTime relativeTime, RelativeTime relativeTime2) {
        if (relativeTime == null) {
            throw new IllegalArgumentException("null time argument");
        }
        if (relativeTime.clock != this.clock) {
            throw new IllegalArgumentException("Clocks don't match");
        }
        return this.add(relativeTime.getMilliseconds(), relativeTime.getNanoseconds(), relativeTime2);
    }

    public void addInterarrivalTo(AbsoluteTime absoluteTime) {
        if (absoluteTime == null) {
            throw new IllegalArgumentException("null destination parameter");
        }
        absoluteTime.add(this, absoluteTime);
    }

    public RelativeTime getInterarrivalTime() {
        return this.getInterarrivalTime(null);
    }

    public RelativeTime getInterarrivalTime(RelativeTime relativeTime) {
        return this.relative(Clock.getRealtimeClock(), relativeTime);
    }

    public RelativeTime relative(Clock clock) {
        return this.relative(clock, null);
    }

    public RelativeTime relative(Clock clock, RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        if (clock == null) {
            clock = Clock.getRealtimeClock();
        }
        relativeTime.set(this.milliseconds, this.nanoseconds, clock);
        return relativeTime;
    }

    public RelativeTime subtract(RelativeTime relativeTime) {
        return this.subtract(relativeTime, null);
    }

    public RelativeTime subtract(RelativeTime relativeTime, RelativeTime relativeTime2) {
        if (relativeTime == null) {
            throw new IllegalArgumentException("null time parameter");
        }
        if (this.clock != relativeTime.clock) {
            throw new IllegalArgumentException("clocks don't match");
        }
        if (relativeTime2 == null) {
            relativeTime2 = new RelativeTime();
        }
        if (HighResolutionTime.willOverrun(this.milliseconds, -relativeTime.getMilliseconds())) {
            throw new ArithmeticException();
        }
        relativeTime2.set(this.milliseconds - relativeTime.getMilliseconds(), (long)this.nanoseconds - (long)relativeTime.getNanoseconds(), relativeTime.clock, false);
        return relativeTime2;
    }

    public String toString() {
        return "(" + this.milliseconds + " ms, " + this.nanoseconds + " ns)";
    }

    static boolean isNegative(RelativeTime relativeTime) {
        return relativeTime.getMilliseconds() < 0L || relativeTime.getMilliseconds() == 0L && relativeTime.getNanoseconds() < 0;
    }

    static boolean isZero(RelativeTime relativeTime) {
        return relativeTime.getMilliseconds() == 0L && relativeTime.getNanoseconds() == 0;
    }

    static boolean isPositive(RelativeTime relativeTime) {
        return !RelativeTime.isZero(relativeTime) && !RelativeTime.isNegative(relativeTime);
    }

    public int compareToZero() {
        return this.compareTo(zero);
    }

    RelativeTime divideBy(int n, RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        long l = this.milliseconds / (long)n;
        long l2 = this.milliseconds - l * (long)n;
        long l3 = (long)this.nanoseconds + l2 * 1000000L;
        relativeTime.set(l, (int)(l3 /= (long)n), this.clock);
        return relativeTime;
    }

    long divideBy(RelativeTime relativeTime) {
        return this.divideBy(relativeTime.getMilliseconds(), relativeTime.getNanoseconds());
    }

    long divideBy(long l, int n) {
        double d = (double)this.milliseconds + (double)this.nanoseconds / 1000000.0;
        double d2 = (double)l + (double)n / 1000000.0;
        return (long)(d / d2);
    }

    RelativeTime times(int n, RelativeTime relativeTime) {
        long l = this.nanoseconds * n;
        long l2 = l % 1000000L + this.milliseconds * (long)n;
        relativeTime.set(l2, (int)(l % 1000000L), this.clock);
        return relativeTime;
    }
}

