/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.lang.reflect.InvocationTargetException;
import javax.realtime.AtomicReference;
import javax.realtime.ImmortalMemory;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryTypeConflictException;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.OffsetOutOfBoundsException;
import javax.realtime.PhysicalMemoryFactory;
import javax.realtime.PhysicalMemoryManager;
import javax.realtime.PhysicalMemoryName;
import javax.realtime.RawAccessFactory;
import javax.realtime.RawFloatAccessFactory;
import javax.realtime.RawIoAccessFactory;
import javax.realtime.RawMemoryName;
import javax.realtime.RawScalarAccess;
import javax.realtime.RawScalarAccessFactory;
import javax.realtime.RealtimeSystem;
import javax.realtime.SizeOutOfBoundsException;
import javax.realtime.UnsupportedPhysicalMemoryException;

public class RawMemoryAccess
implements RawScalarAccess {
    public static final RawMemoryName IO_ACCESS;
    public static final RawMemoryName MEM_ACCESS;
    long virtAddress = -1L;
    private long base;
    private long size;
    private boolean mapped;
    private static final int SIZEOF_BYTE = 1;
    private static final int SIZEOF_SHORT = 2;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_LONG = 8;
    static final int INITIAL_INDEX_SIZE = 10;
    private static AtomicReference head;
    static final Object hLock;
    static final Object nhLock;
    static /* synthetic */ Class class$javax$realtime$RawScalarAccess;
    static /* synthetic */ Class class$javax$realtime$RawFloatAccess;
    static /* synthetic */ Class class$javax$realtime$RawMemoryAccess$IndexEntry;

    public RawMemoryAccess(PhysicalMemoryName physicalMemoryName, long l, long l2) throws SecurityException, OffsetOutOfBoundsException, SizeOutOfBoundsException, UnsupportedPhysicalMemoryException, MemoryTypeConflictException {
        this.base = l;
        this.size = l2;
        this.virtAddress = PhysicalMemoryManager.create(physicalMemoryName, l, l2);
        this.mapped = true;
        if (l == 0L) {
            this.base = PhysicalMemoryManager.getPhysical(this.virtAddress);
        }
    }

    public RawMemoryAccess(PhysicalMemoryName physicalMemoryName, long l) throws SecurityException, OffsetOutOfBoundsException, SizeOutOfBoundsException, UnsupportedPhysicalMemoryException, MemoryTypeConflictException {
        this.base = 0L;
        this.size = l;
        this.virtAddress = PhysicalMemoryManager.create(physicalMemoryName, l);
        this.mapped = true;
        this.base = PhysicalMemoryManager.getPhysical(this.virtAddress);
    }

    public RawMemoryAccess(Object object, long l, long l2) throws SecurityException, OffsetOutOfBoundsException, SizeOutOfBoundsException, UnsupportedPhysicalMemoryException, MemoryTypeConflictException {
        this.base = l;
        this.size = l2;
        this.virtAddress = PhysicalMemoryManager.create(object, l, l2);
        this.mapped = true;
        if (l == 0L) {
            this.base = PhysicalMemoryManager.getPhysical(this.virtAddress);
        }
    }

    public RawMemoryAccess(Object object, long l) throws SecurityException, OffsetOutOfBoundsException, SizeOutOfBoundsException, UnsupportedPhysicalMemoryException, MemoryTypeConflictException {
        this.base = 0L;
        this.size = l;
        this.virtAddress = PhysicalMemoryManager.create(object, l);
        this.mapped = true;
        this.base = PhysicalMemoryManager.getPhysical(this.virtAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RawScalarAccess createRmaInstance(RawMemoryName rawMemoryName, long l, long l2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        IndexEntry indexEntry = RawMemoryAccess.findAccessClass(rawMemoryName, class$javax$realtime$RawScalarAccess == null ? (class$javax$realtime$RawScalarAccess = RawMemoryAccess.class$("javax.realtime.RawScalarAccess")) : class$javax$realtime$RawScalarAccess);
        if (indexEntry == null || indexEntry == MEM_ACCESS) {
            return RawMemoryAccess.createRmaInstance(MEM_ACCESS, l, l2);
        }
        if (Thread.currentThread() instanceof NoHeapRealtimeThread) {
            Object object = nhLock;
            synchronized (object) {
                return indexEntry.factory.newRawScalarAccess(l, l2);
            }
        }
        Object object = hLock;
        synchronized (object) {
            return indexEntry.factory.newRawScalarAccess(l, l2);
        }
    }

    public static void registerAccessFactory(RawScalarAccessFactory rawScalarAccessFactory) {
        if (rawScalarAccessFactory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        RawMemoryName rawMemoryName = rawScalarAccessFactory.getName();
        if (rawMemoryName == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (!(MemoryArea.getMemoryArea(rawMemoryName) instanceof ImmortalMemory) && !MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalArgumentException("Type must be in immortal memory");
        }
        if (!(MemoryArea.getMemoryArea(rawScalarAccessFactory) instanceof ImmortalMemory) && !MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalArgumentException("factory must be in immortal memory");
        }
        RealtimeSystem.getSecurityManager().checkSetFactory();
        RawMemoryAccess.internalAddAccessFactory(rawMemoryName, rawScalarAccessFactory, class$javax$realtime$RawScalarAccess == null ? (class$javax$realtime$RawScalarAccess = RawMemoryAccess.class$("javax.realtime.RawScalarAccess")) : class$javax$realtime$RawScalarAccess);
    }

    static void registerFloatOnlyAccessFactory(RawFloatAccessFactory rawFloatAccessFactory) {
        if (rawFloatAccessFactory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        RawMemoryName rawMemoryName = rawFloatAccessFactory.getName();
        if (rawMemoryName == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (!(MemoryArea.getMemoryArea(rawMemoryName) instanceof ImmortalMemory) && !MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalArgumentException("Type must be in immortal memory");
        }
        if (!(MemoryArea.getMemoryArea(rawFloatAccessFactory) instanceof ImmortalMemory) && !MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalArgumentException("factory must be in immortal memory");
        }
        RealtimeSystem.getSecurityManager().checkSetFactory();
        RawMemoryAccess.internalAddAccessFactory(rawMemoryName, rawFloatAccessFactory, class$javax$realtime$RawFloatAccess == null ? (class$javax$realtime$RawFloatAccess = RawMemoryAccess.class$("javax.realtime.RawFloatAccess")) : class$javax$realtime$RawFloatAccess);
    }

    static void internalAddAccessFactory(RawMemoryName rawMemoryName, Object object, Class clazz) {
        block13: {
            block12: {
                IndexEntry indexEntry;
                IndexEntry indexEntry2 = null;
                do {
                    indexEntry = (IndexEntry)head.get();
                    if (RawMemoryAccess.findAccessClass(rawMemoryName, clazz) != null) break block12;
                    if (indexEntry2 == null) {
                        if (MemoryArea.isSoftSubsetLExcludeNhOn0()) {
                            indexEntry2 = new IndexEntry();
                        } else {
                            try {
                                indexEntry2 = (IndexEntry)ImmortalMemory.instance().newInstance(class$javax$realtime$RawMemoryAccess$IndexEntry == null ? RawMemoryAccess.class$("javax.realtime.RawMemoryAccess$IndexEntry") : class$javax$realtime$RawMemoryAccess$IndexEntry);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                throw new RuntimeException("Logic error 1");
                            }
                            catch (InstantiationException instantiationException) {
                                throw new RuntimeException("Logic error 2: " + instantiationException);
                            }
                        }
                        indexEntry2.type = rawMemoryName;
                        if (object instanceof RawAccessFactory) {
                            indexEntry2.memFactory = (RawAccessFactory)object;
                        } else if (object instanceof RawScalarAccessFactory) {
                            indexEntry2.factory = (RawScalarAccessFactory)object;
                        } else if (object instanceof RawFloatAccessFactory) {
                            indexEntry2.fpFactory = (RawFloatAccessFactory)object;
                        }
                        indexEntry2.resultType = clazz;
                    }
                    indexEntry2.next = indexEntry;
                } while (!head.compareAndSet(indexEntry, indexEntry2));
                break block13;
            }
            throw new IllegalArgumentException("Duplicate access class for type");
        }
    }

    static IndexEntry findAccessClass(RawMemoryName rawMemoryName, Class clazz) {
        IndexEntry indexEntry = (IndexEntry)head.get();
        while (indexEntry != null) {
            if (indexEntry.type == rawMemoryName && indexEntry.resultType == clazz) {
                return indexEntry;
            }
            indexEntry = indexEntry.next;
        }
        return null;
    }

    public byte getByte(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, 1);
        return this.getByte0(this.virtAddress + l);
    }

    public void getBytes(long l, byte[] byArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, 1, byArray.length, n, n2);
        this.getBytes0(this.virtAddress + l, byArray, n, n2);
    }

    public int getInt(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, 4);
        return this.getInt0(this.virtAddress + l);
    }

    public void getInts(long l, int[] nArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, 4, nArray.length, n, n2);
        this.getInts0(this.virtAddress + l, nArray, n, n2);
    }

    public long getLong(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, 8);
        return this.getLong0(this.virtAddress + l);
    }

    public void getLongs(long l, long[] lArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, 8, lArray.length, n, n2);
        this.getLongs0(this.virtAddress + l, lArray, n, n2);
    }

    public short getShort(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, 2);
        return this.getShort0(this.virtAddress + l);
    }

    public void getShorts(long l, short[] sArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, 2, sArray.length, n, n2);
        this.getShorts0(this.virtAddress + l, sArray, n, n2);
    }

    public void setByte(long l, byte by) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, 1);
        this.setByte0(this.virtAddress + l, by);
    }

    public void setBytes(long l, byte[] byArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, 1, byArray.length, n, n2);
        this.setBytes0(this.virtAddress + l, byArray, n, n2);
    }

    public void setInt(long l, int n) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, 4);
        this.setInt0(this.virtAddress + l, n);
    }

    public void setInts(long l, int[] nArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, 4, nArray.length, n, n2);
        this.setInts0(this.virtAddress + l, nArray, n, n2);
    }

    public void setLong(long l, long l2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, 8);
        this.setLong0(this.virtAddress + l, l2);
    }

    public void setLongs(long l, long[] lArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, 8, lArray.length, n, n2);
        this.setLongs0(this.virtAddress + l, lArray, n, n2);
    }

    public void setShort(long l, short s) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, 2);
        this.setShort0(this.virtAddress + l, s);
    }

    public void setShorts(long l, short[] sArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, 2, sArray.length, n, n2);
        this.setShorts0(this.virtAddress + l, sArray, n, n2);
    }

    public long getMappedAddress() {
        if (this.mapped) {
            return this.virtAddress;
        }
        throw new IllegalStateException("The memory area is unmapped.");
    }

    public long map() {
        if (this.mapped) {
            return this.virtAddress;
        }
        return this.map(this.base, this.size);
    }

    public long map(long l) {
        return this.map(l, this.size);
    }

    public long map(long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("negative base address");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("size <= 0");
        }
        try {
            if (!this.mapped) {
                this.virtAddress = PhysicalMemoryManager.remap(this.base, l, l2);
            } else if (l != this.virtAddress) {
                PhysicalMemoryManager.temporaryUnmap(this.base);
                this.mapped = false;
                this.virtAddress = PhysicalMemoryManager.remap(this.base, l, l2);
            }
            this.mapped = true;
            return this.virtAddress;
        }
        catch (OffsetOutOfBoundsException offsetOutOfBoundsException) {
            offsetOutOfBoundsException.printStackTrace();
        }
        catch (SizeOutOfBoundsException sizeOutOfBoundsException) {
            sizeOutOfBoundsException.printStackTrace();
        }
        catch (UnsupportedPhysicalMemoryException unsupportedPhysicalMemoryException) {
            unsupportedPhysicalMemoryException.printStackTrace();
        }
        return -1L;
    }

    public void unmap() {
        if (this.mapped) {
            PhysicalMemoryManager.temporaryUnmap(this.base);
            this.mapped = false;
        }
    }

    protected void finalize() {
        PhysicalMemoryManager.free(this.virtAddress, this.size);
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void standardChecks(long l, int n) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (!this.mapped || this.virtAddress == -1L) {
            throw new SizeOutOfBoundsException("Memory not mapped");
        }
        if (l >= this.size || l < 0L) {
            throw new OffsetOutOfBoundsException("Offset passed is greater than memory size or less than 0");
        }
        if (l + (long)n > this.size) {
            throw new SizeOutOfBoundsException();
        }
    }

    void arrayChecks(long l, int n, int n2, int n3, int n4) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (n4 + n3 > n2) {
            throw new ArrayIndexOutOfBoundsException("Array passed is not big enough");
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative starting index");
        }
        if (l < 0L) {
            throw new OffsetOutOfBoundsException("offset is negative");
        }
        if (n4 < 0) {
            throw new OffsetOutOfBoundsException("'number' is negative");
        }
        this.standardChecks(l, n * n4);
    }

    private native byte getByte0(long var1);

    private native void setByte0(long var1, byte var3);

    private native int getInt0(long var1);

    private native void setInt0(long var1, int var3);

    private native long getLong0(long var1);

    private native void setLong0(long var1, long var3);

    private native short getShort0(long var1);

    private native void setShort0(long var1, short var3);

    private native void getBytes0(long var1, byte[] var3, int var4, int var5);

    private native void setBytes0(long var1, byte[] var3, int var4, int var5);

    private native void getInts0(long var1, int[] var3, int var4, int var5);

    private native void setInts0(long var1, int[] var3, int var4, int var5);

    private native void getLongs0(long var1, long[] var3, int var4, int var5);

    private native void setLongs0(long var1, long[] var3, int var4, int var5);

    private native void getShorts0(long var1, short[] var3, int var4, int var5);

    private native void setShorts0(long var1, short[] var3, int var4, int var5);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        head = new AtomicReference(null);
        hLock = new Object();
        nhLock = new Object();
        RawScalarAccessFactory rawScalarAccessFactory = new RawIoAccessFactory();
        IO_ACCESS = rawScalarAccessFactory.getName();
        try {
            RawMemoryAccess.registerAccessFactory(rawScalarAccessFactory);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        rawScalarAccessFactory = new PhysicalMemoryFactory();
        MEM_ACCESS = rawScalarAccessFactory.getName();
        try {
            RawMemoryAccess.registerAccessFactory(rawScalarAccessFactory);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static class IndexEntry {
        RawMemoryName type;
        Class resultType;
        RawScalarAccessFactory factory;
        RawAccessFactory memFactory;
        RawFloatAccessFactory fpFactory;
        IndexEntry next;

        IndexEntry() {
        }
    }
}

