/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.util.BitSet;
import javax.realtime.AffinitySet;
import javax.realtime.AsyncEventHandler;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.RealtimeThread;
import javax.realtime.RelativeTime;
import javax.realtime.SchedRefHolder;
import javax.realtime.Schedulable;
import javax.realtime.SchedulerRefRecycler;

public class ProcessingGroupParameters
implements Cloneable {
    Schedulable checkReversePtr;
    private HighResolutionTime start;
    private long startMillis;
    private int startNanos;
    private Clock startClock;
    private RelativeTime period;
    private long periodMillis;
    private int periodNanos;
    private Clock periodClock;
    private RelativeTime cost;
    private long costMillis;
    private int costNanos;
    private Clock costClock;
    private RelativeTime deadline;
    private long deadlineMillis;
    private int deadlineNanos;
    private Clock deadlineClock;
    private AsyncEventHandler overrunHandler;
    private AsyncEventHandler missHandler;
    private AffinitySet affinitySet;
    private SchedulerRefRecycler schedSet = new SchedulerRefRecycler();
    static BitSet nhWorkingSet = new BitSet(AffinitySet.getMaximumProcessorNumber());
    static BitSet hWorkingSet = new BitSet(AffinitySet.getMaximumProcessorNumber());
    static /* synthetic */ Class class$javax$realtime$Scheduler;

    public ProcessingGroupParameters(HighResolutionTime highResolutionTime, RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        this(highResolutionTime, relativeTime, relativeTime2, relativeTime3, asyncEventHandler, asyncEventHandler2, null);
    }

    public ProcessingGroupParameters(HighResolutionTime highResolutionTime, RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2, AffinitySet affinitySet) {
        this.internalSetStart(highResolutionTime);
        this.internalSetPeriod(relativeTime);
        this.internalSetCost(relativeTime2);
        this.internalSetDeadline(relativeTime3);
        this.internalSetProcAffinity(affinitySet);
        this.overrunHandler = asyncEventHandler;
        this.missHandler = asyncEventHandler2;
    }

    private RelativeTime validateDeadline(RelativeTime relativeTime, RelativeTime relativeTime2) throws IllegalArgumentException {
        if (relativeTime2 == null) {
            return new RelativeTime(relativeTime);
        }
        if (!RelativeTime.isPositive(relativeTime2)) {
            throw new IllegalArgumentException("deadline <= 0");
        }
        return relativeTime2;
    }

    private RelativeTime validateCost(RelativeTime relativeTime) throws IllegalArgumentException {
        if (relativeTime == null) {
            throw new IllegalArgumentException("null cost");
        }
        if (RelativeTime.isNegative(relativeTime)) {
            throw new IllegalArgumentException("Cost less than zero");
        }
        return relativeTime;
    }

    private RelativeTime validatePeriod(RelativeTime relativeTime) throws IllegalArgumentException {
        if (relativeTime == null) {
            throw new IllegalArgumentException("Null period");
        }
        if (!RelativeTime.isPositive(relativeTime)) {
            throw new IllegalArgumentException("period must be > 0");
        }
        return relativeTime;
    }

    private HighResolutionTime validateStart(HighResolutionTime highResolutionTime) throws IllegalArgumentException {
        if (highResolutionTime == null) {
            return new RelativeTime(0L, 0);
        }
        if (highResolutionTime instanceof RelativeTime && RelativeTime.isNegative((RelativeTime)highResolutionTime)) {
            throw new IllegalArgumentException("Start time less than zero");
        }
        return highResolutionTime;
    }

    synchronized void bind(RealtimeThread realtimeThread) {
        SchedRefHolder schedRefHolder = this.schedSet.find(realtimeThread);
        if (schedRefHolder == null) {
            this.schedSet.add(realtimeThread);
        } else {
            if (realtimeThread.getExecEnv() <= 0L) {
                throw new IllegalArgumentException("Rtt's exec env value is illegal: " + realtimeThread.getExecEnv());
            }
            if (realtimeThread.getThreadId() <= 0L) {
                throw new IllegalArgumentException(" Rtt's thread id value is illegal " + realtimeThread.getThreadId());
            }
            schedRefHolder.execEnv = realtimeThread.getExecEnv();
            schedRefHolder.threadId = realtimeThread.getThreadId();
        }
    }

    void unbind(RealtimeThread realtimeThread) {
        this.schedSet.remove(realtimeThread);
    }

    boolean isBinded() {
        return this.schedSet.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setIfFeasible(RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3) {
        RelativeTime relativeTime4;
        RelativeTime relativeTime5;
        RelativeTime relativeTime6;
        boolean bl = true;
        Object object = this;
        synchronized (object) {
            relativeTime6 = this.getPeriod();
            relativeTime5 = this.getCost();
            relativeTime4 = this.getDeadline();
            this.setPeriod(this.validatePeriod(relativeTime));
            this.setCost(this.validateCost(relativeTime2));
            this.setDeadline(this.validateDeadline(relativeTime, relativeTime3));
        }
        object = class$javax$realtime$Scheduler == null ? (class$javax$realtime$Scheduler = ProcessingGroupParameters.class$("javax.realtime.Scheduler")) : class$javax$realtime$Scheduler;
        synchronized (object) {
            for (int i = 0; i < this.schedSet.size(); ++i) {
                Schedulable schedulable = (Schedulable)((Object)this.schedSet.elementAt(i));
                if (schedulable.setProcessingGroupParametersIfFeasible(this)) continue;
                this.setPeriod(relativeTime6);
                this.setCost(relativeTime5);
                this.setDeadline(relativeTime4);
                int n = i - 1;
                while (i > 0) {
                    schedulable = (Schedulable)((Object)this.schedSet.elementAt(n));
                    schedulable.setProcessingGroupParametersIfFeasible(this);
                    --i;
                }
                bl = false;
                break;
            }
        }
        return bl;
    }

    public RelativeTime getCost() {
        return this.internalGetCost();
    }

    synchronized RelativeTime internalGetCost() {
        return this.cost;
    }

    long getCostMillis() {
        return this.costMillis;
    }

    int getCostNanos() {
        return this.costNanos;
    }

    Clock getCostClock() {
        return this.costClock;
    }

    public AsyncEventHandler getCostOverrunHandler() {
        return this.overrunHandler;
    }

    public RelativeTime getDeadline() {
        return this.internalGetDeadline();
    }

    RelativeTime internalGetDeadline() {
        return this.deadline;
    }

    long getDeadlineMillis() {
        return this.deadlineMillis;
    }

    int getDeadlineNanos() {
        return this.deadlineNanos;
    }

    Clock getDeadlineClock() {
        return this.deadlineClock;
    }

    public AsyncEventHandler getDeadlineMissHandler() {
        return this.missHandler;
    }

    public RelativeTime getPeriod() {
        return this.internalGetPeriod();
    }

    final RelativeTime internalGetPeriod() {
        return this.period;
    }

    final long getPeriodMillis() {
        return this.periodMillis;
    }

    final int getPeriodNanos() {
        return this.periodNanos;
    }

    final Clock getPeriodClock() {
        return this.periodClock;
    }

    public HighResolutionTime getStart() {
        return this.internalGetStart();
    }

    final HighResolutionTime internalGetStart() {
        return this.start;
    }

    long getStartMillis() {
        return this.startMillis;
    }

    int getStartNanos() {
        return this.startNanos;
    }

    Clock getStartClock() {
        return this.startClock;
    }

    public void setCost(RelativeTime relativeTime) {
        this.internalSetCost(relativeTime);
    }

    void internalSetCost(RelativeTime relativeTime) {
        this.cost = this.validateCost(relativeTime);
        this.costMillis = this.cost.getMilliseconds();
        this.costNanos = this.cost.getNanoseconds();
        this.costClock = this.cost.getClock();
    }

    public void setCostOverrunHandler(AsyncEventHandler asyncEventHandler) {
        this.overrunHandler = asyncEventHandler;
    }

    public void setDeadline(RelativeTime relativeTime) {
        this.internalSetDeadline(relativeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetDeadline(RelativeTime relativeTime) {
        ProcessingGroupParameters processingGroupParameters = this;
        synchronized (processingGroupParameters) {
            this.deadline = this.validateDeadline(this.period, relativeTime);
            this.deadlineMillis = this.deadline.getMilliseconds();
            this.deadlineNanos = this.deadline.getNanoseconds();
            this.deadlineClock = this.deadline.getClock();
        }
    }

    public void setDeadlineMissHandler(AsyncEventHandler asyncEventHandler) {
        this.missHandler = asyncEventHandler;
    }

    public void setPeriod(RelativeTime relativeTime) {
        this.internalSetPeriod(relativeTime);
    }

    synchronized void internalSetPeriod(RelativeTime relativeTime) {
        this.period = this.validatePeriod(relativeTime);
        this.periodMillis = this.period.getMilliseconds();
        this.periodNanos = this.period.getNanoseconds();
        this.periodClock = this.period.getClock();
    }

    public void setStart(HighResolutionTime highResolutionTime) {
        this.start = this.validateStart(highResolutionTime);
    }

    public AffinitySet getAffinitySet() {
        return this.internalGetProcAffinity();
    }

    public void setAffinitySet(AffinitySet affinitySet) {
        this.internalSetProcAffinity(affinitySet);
    }

    synchronized void internalSetStart(HighResolutionTime highResolutionTime) {
        this.start = this.validateStart(highResolutionTime);
        this.startMillis = this.start.getMilliseconds();
        this.startNanos = this.start.getNanoseconds();
        this.startClock = this.start.getClock();
    }

    final void internalSetProcAffinity(AffinitySet affinitySet) {
        if (affinitySet == null) {
            affinitySet = AffinitySet.getAllProcessors();
        }
        this.affinitySet = affinitySet;
    }

    final AffinitySet internalGetProcAffinity() {
        return this.affinitySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AffinitySet getEffectiveAffinity(RealtimeThread realtimeThread) {
        BitSet bitSet = null;
        bitSet = Thread.currentThread() instanceof NoHeapRealtimeThread ? nhWorkingSet : hWorkingSet;
        BitSet bitSet2 = bitSet;
        synchronized (bitSet2) {
            bitSet.andNot(bitSet);
            bitSet.or(realtimeThread.getAffinity().affinityBitSet);
            bitSet.and(this.affinitySet.affinityBitSet);
            if (AffinitySet.bitSetCardinality(bitSet) == 0) {
                return AffinitySet.getPGroupDefaultAffinity();
            }
            return AffinitySet.generate(bitSet);
        }
    }

    public synchronized Object clone() {
        ProcessingGroupParameters processingGroupParameters = null;
        try {
            HighResolutionTime highResolutionTime = this.start;
            RelativeTime relativeTime = this.cost;
            RelativeTime relativeTime2 = this.period;
            RelativeTime relativeTime3 = this.deadline;
            SchedulerRefRecycler schedulerRefRecycler = this.schedSet;
            this.start = null;
            this.cost = null;
            this.period = null;
            this.deadline = null;
            this.schedSet = null;
            this.checkReversePtr = null;
            processingGroupParameters = (ProcessingGroupParameters)super.clone();
            processingGroupParameters.start = highResolutionTime == null ? null : (HighResolutionTime)highResolutionTime.clone();
            processingGroupParameters.cost = relativeTime == null ? null : (RelativeTime)relativeTime.clone();
            processingGroupParameters.period = relativeTime2 == null ? null : (RelativeTime)relativeTime2.clone();
            processingGroupParameters.deadline = relativeTime3 == null ? null : (RelativeTime)relativeTime3.clone();
            processingGroupParameters.schedSet = new SchedulerRefRecycler();
            this.start = highResolutionTime;
            this.cost = relativeTime;
            this.period = relativeTime2;
            this.deadline = relativeTime3;
            this.schedSet = schedulerRefRecycler;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
        return processingGroupParameters;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

