/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.GarbageCollector;
import javax.realtime.RelativeTime;

class MarkAndSweepCollector
extends GarbageCollector {
    static double msPerMByte = -1.0;
    static final long MEG = 0x100000L;
    static final double FUDGE_FACTOR = 140.0;
    private static final int SIZE = 16384;
    private static int[] work1 = new int[16384];
    private static int[] work2 = new int[16384];

    MarkAndSweepCollector() {
    }

    public RelativeTime getPreemptionLatency() {
        return this.internalGetPreemptionLatency(null);
    }

    public RelativeTime getPreeptionLatency(RelativeTime relativeTime) {
        return this.internalGetPreemptionLatency(relativeTime);
    }

    final RelativeTime internalGetPreemptionLatency(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        long l = (long)((double)Runtime.getRuntime().totalMemory() * MarkAndSweepCollector.usPerMeg() * 140.0) / 0x100000L;
        long l2 = l / 1000L;
        relativeTime.set(l2 + 1L, 0);
        return relativeTime;
    }

    private static double usPerMeg() {
        if (msPerMByte < 0.0) {
            MarkAndSweepCollector.calibrate();
        }
        return msPerMByte * 1000.0;
    }

    private static void calibrate() {
        long l = System.currentTimeMillis();
        for (int i = 0; i < 4096; ++i) {
            System.arraycopy(work1, 0, work2, 0, 16384);
            System.arraycopy(work2, 0, work1, 0, 16384);
        }
        long l2 = System.currentTimeMillis();
        double d = 512.0;
        msPerMByte = (double)(l2 - l) / d;
    }
}

