/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AperiodicParameters;
import javax.realtime.AsyncEventHandler;
import javax.realtime.HeapMemory;
import javax.realtime.ImportanceParameters;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryParameters;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.ReleaseParameters;
import javax.realtime.Schedulable;
import javax.realtime.SchedulingParameters;
import javax.realtime.SporadicParameters;

class FeasibilityEntry {
    static final int APERIODIC = 0;
    static final int PERIODIC = 1;
    static final int SPORADIC = 2;
    int type;
    boolean groupMember;
    long startMs;
    int startNs;
    long periodMs;
    int periodNs;
    long costMs;
    int costNs;
    long deadlineMs;
    int deadlineNs;
    boolean hasMissHandler;
    boolean missHandlerInHeap;
    boolean hasOverrunHandler;
    boolean overrunHandlerInHeap;
    long mitMs;
    int mitNs;
    int priority;
    int importance;
    long groupPeriodMs;
    int groupPeriodNs;
    long groupCostMs;
    int groupCostNs;
    long threadHashCode;
    long maxMemoryArea;
    long maxImmortal;
    long allocationRate;

    FeasibilityEntry() {
    }

    void setReleaseParameters(ReleaseParameters releaseParameters) {
        this.deadlineMs = releaseParameters.deadlineMillis;
        this.deadlineNs = releaseParameters.deadlineNanos;
        this.costMs = releaseParameters.costMillis;
        this.costNs = releaseParameters.costNanos;
        AsyncEventHandler asyncEventHandler = releaseParameters.getDeadlineMissHandler();
        if (asyncEventHandler == null) {
            this.hasMissHandler = false;
            this.missHandlerInHeap = false;
        } else {
            this.hasMissHandler = true;
            this.missHandlerInHeap = MemoryArea.getMemoryArea(asyncEventHandler) instanceof HeapMemory;
        }
        asyncEventHandler = releaseParameters.getCostOverrunHandler();
        if (asyncEventHandler == null) {
            this.hasOverrunHandler = false;
            this.overrunHandlerInHeap = false;
        } else {
            this.hasOverrunHandler = true;
            this.overrunHandlerInHeap = MemoryArea.getMemoryArea(asyncEventHandler) instanceof HeapMemory;
        }
        if (releaseParameters instanceof PeriodicParameters) {
            this.type = 1;
            PeriodicParameters periodicParameters = (PeriodicParameters)releaseParameters;
            this.periodMs = periodicParameters.periodMillis;
            this.periodNs = periodicParameters.periodNanos;
            this.startMs = periodicParameters.startMillis;
            this.startNs = periodicParameters.startNanos;
        } else if (releaseParameters instanceof SporadicParameters) {
            this.type = 2;
            SporadicParameters sporadicParameters = (SporadicParameters)releaseParameters;
            this.mitMs = sporadicParameters.mitMillis;
            this.mitNs = sporadicParameters.mitNanos;
        } else if (releaseParameters instanceof AperiodicParameters) {
            this.type = 0;
        }
    }

    void updateFromSO(Schedulable schedulable) {
        if (schedulable.getMemoryParameters() != null) {
            this.setMemoryParameters(schedulable.getMemoryParameters());
        }
        if (schedulable.getReleaseParameters() != null) {
            this.setReleaseParameters(schedulable.getReleaseParameters());
        }
        if (schedulable.getSchedulingParameters() != null) {
            this.setSchedulingParameters(schedulable.getSchedulingParameters());
        }
    }

    void setSchedulingParameters(SchedulingParameters schedulingParameters) {
        if (schedulingParameters instanceof ImportanceParameters) {
            this.importance = ((ImportanceParameters)schedulingParameters).getImportance();
            this.priority = ((ImportanceParameters)schedulingParameters).getPriority();
        } else if (schedulingParameters instanceof PriorityParameters) {
            this.priority = ((PriorityParameters)schedulingParameters).getPriority();
        }
    }

    void setGroupParameters(ProcessingGroupParameters processingGroupParameters) {
        this.groupCostMs = processingGroupParameters.getCostMillis();
        this.groupCostNs = processingGroupParameters.getCostNanos();
        this.groupPeriodMs = processingGroupParameters.getPeriodMillis();
        this.groupPeriodNs = processingGroupParameters.getPeriodNanos();
    }

    void setMemoryParameters(MemoryParameters memoryParameters) {
        this.maxMemoryArea = memoryParameters.getMaxMemoryArea();
        this.maxImmortal = memoryParameters.getMaxImmortal();
        this.allocationRate = memoryParameters.getAllocationRate();
    }
}

