/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AEHImpl;
import javax.realtime.HeapMemory;
import javax.realtime.MITViolationException;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryParameters;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.RealtimeSystem;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.realtime.Schedulable;
import javax.realtime.Scheduler;
import javax.realtime.SchedulingParameters;

public class AsyncEventHandler
implements Schedulable {
    AEHImpl aehImpl;
    private boolean noHeapMode;
    private boolean reenterMemory;
    int associatedAEs = 0;

    public AsyncEventHandler() {
        this(null, null, null, null, null, false, null);
    }

    public AsyncEventHandler(boolean bl) {
        this(null, null, null, null, null, bl, null);
    }

    public AsyncEventHandler(Runnable runnable) {
        this(null, null, null, null, null, false, runnable);
    }

    public AsyncEventHandler(boolean bl, Runnable runnable) {
        this(null, null, null, null, null, bl, false, runnable, false);
    }

    public AsyncEventHandler(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, Runnable runnable) {
        this(schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, false, false, runnable, false);
    }

    public AsyncEventHandler(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, boolean bl) {
        this(schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, bl, false, null, false);
    }

    public AsyncEventHandler(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, boolean bl, Runnable runnable) {
        this(schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, bl, false, runnable, false);
    }

    public AsyncEventHandler(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, boolean bl, boolean bl2, Runnable runnable) {
        this(schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, bl, bl2, runnable, false);
    }

    AsyncEventHandler(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, boolean bl, boolean bl2, Runnable runnable, boolean bl3) {
        if (bl && RealtimeSystem.isSoftSubsetLExcludeAtcOn()) {
            throw new IllegalStateException("Noheap SOs cannot be created in heap-only mode.");
        }
        this.aehImpl = new AEHImpl(this, schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, bl, bl2, runnable, bl3);
        this.noHeapMode = bl;
        this.reenterMemory = bl2;
    }

    public void handleAsyncEvent() {
        this.aehImpl.handleAsyncEvent();
    }

    void handle(Object object, int n) throws RuntimeException, MITViolationException {
        this.aehImpl.handle(object, n);
    }

    public final void run() {
        this.aehImpl.simpleRun();
    }

    protected int getAndDecrementPendingFireCount() {
        return this.aehImpl.getAndDecrementPendingFireCount(false);
    }

    protected int getAndClearPendingFireCount() {
        return this.aehImpl.getAndClearPendingFireCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAndIncrementPendingFireCount() {
        if (this.aehImpl.handlerThread != Thread.currentThread()) {
            this.associate();
            try {
                int n = this.aehImpl.getAndIncrementPendingFireCount();
                return n;
            }
            finally {
                this.deAssociate(true);
            }
        }
        return this.aehImpl.getAndIncrementPendingFireCount();
    }

    protected int getPendingFireCount() {
        return this.aehImpl.getPendingFireCount();
    }

    public boolean addToFeasibility() {
        return this.aehImpl.addToFeasibility();
    }

    public boolean addIfFeasible() {
        return this.aehImpl.addIfFeasible();
    }

    public boolean removeFromFeasibility() {
        return this.aehImpl.removeFromFeasibility();
    }

    public void setSchedulingParameters(SchedulingParameters schedulingParameters) {
        this.aehImpl.setSchedulingParameters(schedulingParameters);
    }

    public boolean setSchedulingParametersIfFeasible(SchedulingParameters schedulingParameters) {
        return this.aehImpl.setSchedulingParametersIfFeasible(schedulingParameters);
    }

    public void setReleaseParameters(ReleaseParameters releaseParameters) {
        this.aehImpl.setReleaseParameters(releaseParameters);
    }

    public boolean setReleaseParametersIfFeasible(ReleaseParameters releaseParameters) {
        return this.aehImpl.setReleaseParametersIfFeasible(releaseParameters);
    }

    public void setMemoryParameters(MemoryParameters memoryParameters) {
        this.aehImpl.setMemoryParameters(memoryParameters);
    }

    public boolean setMemoryParametersIfFeasible(MemoryParameters memoryParameters) {
        return this.aehImpl.setMemoryParametersIfFeasible(memoryParameters);
    }

    public void setProcessingGroupParameters(ProcessingGroupParameters processingGroupParameters) {
        this.aehImpl.setProcessingGroupParameters(processingGroupParameters);
    }

    public boolean setProcessingGroupParametersIfFeasible(ProcessingGroupParameters processingGroupParameters) {
        return this.aehImpl.setProcessingGroupParametersIfFeasible(processingGroupParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.aehImpl.setIfFeasible(releaseParameters, memoryParameters, processingGroupParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        return this.aehImpl.setIfFeasible(releaseParameters, memoryParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.aehImpl.setIfFeasible(releaseParameters, processingGroupParameters);
    }

    public boolean setIfFeasible(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        return this.aehImpl.setIfFeasible(schedulingParameters, releaseParameters, memoryParameters);
    }

    public boolean setIfFeasible(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.aehImpl.setIfFeasible(schedulingParameters, releaseParameters, memoryParameters, processingGroupParameters);
    }

    public void setScheduler(Scheduler scheduler, SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) throws IllegalThreadStateException {
        this.aehImpl.setScheduler(scheduler, schedulingParameters, releaseParameters, memoryParameters, processingGroupParameters);
    }

    public void setScheduler(Scheduler scheduler) {
        this.aehImpl.setScheduler(scheduler);
    }

    public final boolean isDaemon() {
        return this.aehImpl.isDaemon();
    }

    public final void setDaemon(boolean bl) {
        if (this.associatedAEs > 0) {
            throw new IllegalThreadStateException("Can't use setDaemon() on an AEH that is associated with an AE");
        }
        this.aehImpl.setDaemon(bl);
    }

    public MemoryArea getMemoryArea() {
        return this.aehImpl.getMemoryArea();
    }

    public MemoryParameters getMemoryParameters() {
        return this.aehImpl.getMemoryParameters();
    }

    public ProcessingGroupParameters getProcessingGroupParameters() {
        return this.aehImpl.getProcessingGroupParameters();
    }

    public ReleaseParameters getReleaseParameters() {
        return this.aehImpl.getReleaseParameters();
    }

    public Scheduler getScheduler() {
        return this.aehImpl.getScheduler();
    }

    public SchedulingParameters getSchedulingParameters() {
        return this.aehImpl.getSchedulingParameters();
    }

    boolean isNoHeap() {
        return this.noHeapMode;
    }

    public boolean isReenterMemory() {
        return this.reenterMemory;
    }

    void shutdown() throws Throwable {
        try {
            if (this.aehImpl != null) {
                this.aehImpl.shutdown();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void shutdownFromFinishRtt() {
        try {
            if (this.aehImpl != null) {
                this.aehImpl.shutdownFromFinishRtt();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        if (MemoryArea.getMemoryArea(this) instanceof HeapMemory && this.aehImpl == null) {
            this.shutdown();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associate() {
        int n;
        AsyncEventHandler asyncEventHandler = this;
        synchronized (asyncEventHandler) {
            n = ++this.associatedAEs;
        }
        if (n == 1) {
            this.aehImpl.associate();
        }
    }

    void deAssociate() {
        this.deAssociate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deAssociate(boolean bl) {
        int n;
        AsyncEventHandler asyncEventHandler = this;
        synchronized (asyncEventHandler) {
            n = --this.associatedAEs;
        }
        if (n == 0) {
            this.aehImpl.deAssociate(bl);
        } else if (n < 0) {
            System.err.println("Logic error in AEH.deAssociate.  associatedAE is < 0");
            throw new RuntimeException("Attempt to deAssociate an AEH to a negative association");
        }
    }

    public String toString() {
        return "AsyncEventHandler " + this.hashCode() + "/" + this.aehImpl;
    }

    public RelativeTime getMinConsumption(RelativeTime relativeTime) {
        return this.aehImpl.getMaxConsumption(relativeTime);
    }

    public RelativeTime getMinConsumption() {
        return this.aehImpl.getMinConsumption();
    }

    public RelativeTime getMaxConsumption(RelativeTime relativeTime) {
        return this.aehImpl.getMaxConsumption(relativeTime);
    }

    public RelativeTime getMaxConsumption() {
        return this.aehImpl.getMaxConsumption();
    }

    public static RelativeTime getCurrentConsumption(RelativeTime relativeTime) {
        return AEHImpl.getCurrentConsumption(relativeTime);
    }

    public static RelativeTime getCurrentConsumption() {
        return AEHImpl.getCurrentConsumption();
    }
}

