/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class UnixFileSystem
extends FileSystem {
    private final char slash = AccessController.doPrivileged(new GetPropertyAction("file.separator")).charAt(0);
    private final char colon = AccessController.doPrivileged(new GetPropertyAction("path.separator")).charAt(0);

    public char getSeparator() {
        return this.slash;
    }

    public char getPathSeparator() {
        return this.colon;
    }

    private String normalize(String string, int n, int n2) {
        int n3;
        if (n == 0) {
            return string;
        }
        for (n3 = n; n3 > 0 && string.charAt(n3 - 1) == '/'; --n3) {
        }
        if (n3 == 0) {
            return "/";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (n2 > 0) {
            stringBuffer.append(string.substring(0, n2));
        }
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            char c = string.charAt(i);
            if (n4 == 47 && c == '/') continue;
            stringBuffer.append(c);
            n4 = c;
        }
        return stringBuffer.toString();
    }

    public String normalize(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (n2 == 47 && c == '/') {
                return this.normalize(string, n, i - 1);
            }
            n2 = c;
        }
        if (n2 == 47) {
            return this.normalize(string, n, n - 1);
        }
        return string;
    }

    public int prefixLength(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return string.charAt(0) == '/' ? 1 : 0;
    }

    public String resolve(String string, String string2) {
        if (string2.equals("")) {
            return string;
        }
        if (string2.charAt(0) == '/') {
            if (string.equals("/")) {
                return string2;
            }
            return string + string2;
        }
        if (string.equals("/")) {
            return string + string2;
        }
        return string + '/' + string2;
    }

    public String getDefaultParent() {
        return "/";
    }

    public boolean isAbsolute(File file) {
        return file.getPrefixLength() != 0;
    }

    public String resolve(File file) {
        if (this.isAbsolute(file)) {
            return file.getPath();
        }
        return this.resolve(System.getProperty("user.dir"), file.getPath());
    }

    public native String canonicalize(String var1) throws IOException;

    public native int getBooleanAttributes0(File var1);

    public int getBooleanAttributes(File file) {
        int n = this.getBooleanAttributes0(file);
        String string = file.getName();
        boolean bl = string.length() > 0 && string.charAt(0) == '.';
        return n | (bl ? 8 : 0);
    }

    public native boolean checkAccess(File var1, boolean var2);

    public native long getLastModifiedTime(File var1);

    public native long getLength(File var1);

    public native boolean createFileExclusively(String var1) throws IOException;

    public native boolean delete(File var1);

    public synchronized native boolean deleteOnExit(File var1);

    public native String[] list(File var1);

    public native boolean createDirectory(File var1);

    public native boolean rename(File var1, File var2);

    public native boolean setLastModifiedTime(File var1, long var2);

    public native boolean setReadOnly(File var1);

    public File[] listRoots() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead("/");
            }
            return new File[]{new File("/")};
        }
        catch (SecurityException securityException) {
            return new File[0];
        }
    }

    public int compare(File file, File file2) {
        return file.getPath().compareTo(file2.getPath());
    }

    public int hashCode(File file) {
        return file.getPath().hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static {
        UnixFileSystem.initIDs();
    }
}

