/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.CompilationRegistry;
import junit.framework.TestCase;
import org.junit.Assert;

public class TestTheCompilationRegistry
extends TestCase {
    public void testSimple() {
        CompilationRegistry creg = new CompilationRegistry();
        MethodOrFieldDesc m1 = new MethodOrFieldDesc("class1", "method1", "sig1");
        MethodOrFieldDesc m2 = new MethodOrFieldDesc("class1", "method2", "sig2");
        MethodOrFieldDesc m3 = new MethodOrFieldDesc("class2", "method3", "sig3");
        MethodOrFieldDesc m4 = new MethodOrFieldDesc("class4", "method4", "sig4");
        MethodOrFieldDesc m5 = new MethodOrFieldDesc("class4", "method4", "sig4");
        creg.toggleMethodCompilation(m1);
        creg.toggleMethodCompilation(m2);
        creg.toggleMethodCompilation(m3);
        creg.toggleMethodCompilation(m4);
        creg.toggleMethodCompilation(m5);
        String encoded = creg.encodeToString();
        Assert.assertNotNull((Object)encoded);
        creg.initializeFromString(encoded);
        Assert.assertTrue((boolean)creg.isClassCompiled("class1"));
        Assert.assertTrue((boolean)creg.isClassCompiled("class2"));
        Assert.assertFalse((boolean)creg.isClassCompiled("class4"));
        Assert.assertFalse((boolean)creg.isClassCompiled("class5"));
        Assert.assertTrue((boolean)creg.isMethodCompiled(m1));
        Assert.assertTrue((boolean)creg.isMethodCompiled(m2));
        Assert.assertTrue((boolean)creg.isMethodCompiled(m3));
        Assert.assertFalse((boolean)creg.isMethodCompiled(m4));
        Assert.assertFalse((boolean)creg.isMethodCompiled(m5));
    }

    public void testEmptyRegistry() {
        CompilationRegistry creg = new CompilationRegistry();
        MethodOrFieldDesc m1 = new MethodOrFieldDesc("class1", "method1", "sig1");
        creg.toggleMethodCompilation(m1);
        creg.toggleMethodCompilation(m1);
        String encoded = creg.encodeToString();
        Assert.assertEquals((Object)"0!", (Object)encoded);
        creg.initializeFromString(encoded);
        Assert.assertFalse((boolean)creg.isMethodCompiled(m1));
    }
}

