/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.BNode;
import icecaptools.CompilationSequence;
import icecaptools.FieldOffsetCalculator;
import icecaptools.IcecapProgressMonitor;
import icecaptools.MethodEntryPoints;
import icecaptools.RestartableMethodObserver;
import icecaptools.compiler.DefaultIcecapCodeFormatter;
import icecaptools.compiler.DefaultIcecapProgressMonitor;
import icecaptools.compiler.DefaultMethodObserver;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.compiler.IcecapCodeFormatter;
import icecaptools.compiler.OffsetPair;
import icecaptools.conversion.ConversionConfiguration;
import icecaptools.conversion.DependencyExtent;
import icecaptools.stackanalyser.ProducerConsumerCellInfo;
import icecaptools.stackanalyser.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.junit.Assert;
import org.junit.Test;
import test.icecaptools.DefaultCompilationRegistry;

public class TestSynchronization {
    @Test
    public void testMonitorEnterAnnotation() {
        ConversionConfiguration config = new ConversionConfiguration();
        config.setClassPath("/home/sek/workspace/icecaptools/bin");
        config.setInputPackage("test.icecapvm.minitests");
        config.setInputClass("TestThread1");
        CompilationSequence sequencer = new CompilationSequence();
        config.setCodeFormatter((IcecapCodeFormatter)new DefaultIcecapCodeFormatter());
        try {
            sequencer.startCompilation(System.out, (RestartableMethodObserver)new DefaultMethodObserver(), config, (IcecapProgressMonitor)new DefaultIcecapProgressMonitor(), (ICompilationRegistry)new DefaultCompilationRegistry(), "", false);
        }
        catch (Throwable throwable) {
            Assert.fail();
        }
        DependencyExtent extent = sequencer.getDependencyExtent();
        MethodEntryPoints runMethod = extent.getMethod("test.icecapvm.minitests.TestThread1$Counter", "run", "()V");
        Assert.assertNotNull((Object)runMethod);
        BNode monitorEnter = runMethod.getBNodeFromOriginalAddress(19);
        Assert.assertNotNull((Object)monitorEnter);
        Assert.assertEquals((long)-62L, (long)monitorEnter.getOpCode());
        try {
            ArrayList types = Util.getCellType((MethodEntryPoints)runMethod, (ProducerConsumerCellInfo)monitorEnter.getAinfo().entryStack.peek());
            Assert.assertNotNull((Object)types);
            Assert.assertEquals((long)1L, (long)types.size());
            String producerType = (String)types.get(0);
            Assert.assertEquals((Object)"java.lang.String", (Object)producerType);
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testSizeCalcultion() {
        ConversionConfiguration config = new ConversionConfiguration();
        config.setClassPath("/home/sek/workspace/icecaptools/bin");
        config.setInputPackage("test.icecapvm.minitests");
        config.setInputClass("TestThread");
        CompilationSequence sequencer = new CompilationSequence();
        config.setCodeFormatter((IcecapCodeFormatter)new DefaultIcecapCodeFormatter());
        try {
            sequencer.startCompilation(System.out, (RestartableMethodObserver)new DefaultMethodObserver(), config, (IcecapProgressMonitor)new DefaultIcecapProgressMonitor(), (ICompilationRegistry)new DefaultCompilationRegistry(), "", false);
        }
        catch (Throwable throwable) {
            Assert.fail();
        }
        LinkedList<String> classes = new LinkedList<String>();
        String className = "java.lang.String";
        classes.add(className);
        FieldOffsetCalculator foCalc = new FieldOffsetCalculator();
        try {
            foCalc.calculate(classes.iterator(), sequencer.getObserver());
        }
        catch (Exception exception) {
            Assert.fail();
        }
        HashMap sizes = foCalc.getObjectSizes();
        try {
            JavaClass stringClass = Repository.lookupClass((String)"java.lang.String");
            OffsetPair cfr_ignored_0 = (OffsetPair)sizes.get(stringClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
    }
}

