/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.IcecapClassPath;
import icecaptools.IcecapRepository;
import icecaptools.stackanalyser.StackReferencesAnalyser;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;
import org.junit.Assert;

public class TestStackAnalyser
extends TestCase {
    public void testStackUsage1() {
        IcecapClassPath classPath = new IcecapClassPath("/home/sek/workspace/icecaptools/bin");
        IcecapRepository repository = new IcecapRepository(SyntheticRepository.getInstance((ClassPath)classPath));
        org.apache.bcel.Repository.setRepository((Repository)repository);
        org.apache.bcel.Repository.clearCache();
        try {
            JavaClass clazz = org.apache.bcel.Repository.lookupClass((String)"test.icecaptools.minitests.TestStackUsage1");
            Method[] methods = clazz.getMethods();
            int index = 0;
            while (index < methods.length) {
                String signature;
                Method method = methods[index];
                if (method.getName().equals("foo") && (signature = method.getSignature()).equals("(Ljava/lang/String;I)Ljava/lang/String;")) {
                    Method javaMethod = method;
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(javaMethod, clazz);
                    try {
                        analyser.analyseStackUsage();
                    }
                    catch (Exception exception) {
                        Assert.fail();
                    }
                }
                ++index;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
    }

    public void testStackUsage2() {
        IcecapClassPath classPath = new IcecapClassPath("/home/sek/workspace/icecaptools/bin");
        IcecapRepository repository = new IcecapRepository(SyntheticRepository.getInstance((ClassPath)classPath));
        org.apache.bcel.Repository.setRepository((Repository)repository);
        org.apache.bcel.Repository.clearCache();
        try {
            JavaClass clazz = org.apache.bcel.Repository.lookupClass((String)"test.icecaptools.minitests.TestStackUsage2");
            Method[] methods = clazz.getMethods();
            int index = 0;
            while (index < methods.length) {
                String signature;
                Method method = methods[index];
                if (method.getName().equals("main") && (signature = method.getSignature()).equals("([Ljava/lang/String;)V")) {
                    Method javaMethod = method;
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(javaMethod, clazz);
                    try {
                        analyser.analyseStackUsage();
                    }
                    catch (Exception exception) {
                        Assert.fail();
                    }
                }
                ++index;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
    }

    public void testAll() {
        File file = new File(".");
        String location = null;
        try {
            location = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            Assert.fail();
        }
        String[] path1 = new String[]{"bin", "test", "icecaptools", "minitests"};
        this.testPathContent(location, path1, "test.icecaptools.minitests.");
        String[] path2 = new String[]{"bin", "test", "icecapvm", "minitests"};
        this.testPathContent(location, path2, "test.icecapvm.minitests.");
        Assert.assertNotNull((Object)location);
    }

    private void testPathContent(String location, String[] path, String package_name) {
        int i2 = 0;
        while (i2 < path.length) {
            location = String.valueOf(location) + File.separatorChar + path[i2];
            ++i2;
        }
        File dir = new File(location);
        String[] children = dir.list();
        int i3 = 0;
        while (i3 < children.length) {
            String child = children[i3];
            if (!child.equals("properties")) {
                StringTokenizer tokenizer = new StringTokenizer(child, ".");
                String className = tokenizer.nextToken();
                try {
                    JavaClass clazz = org.apache.bcel.Repository.lookupClass((String)(String.valueOf(package_name) + className));
                    Method[] methods = clazz.getMethods();
                    int index = 0;
                    while (index < methods.length) {
                        Method method = methods[index];
                        StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                        try {
                            analyser.analyseStackUsage();
                        }
                        catch (Exception exception) {
                            Assert.fail();
                        }
                        ++index;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Assert.fail();
                }
            }
            ++i3;
        }
    }
}

