/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.NewList;
import junit.framework.TestCase;

public class TestNewList
extends TestCase {
    public void testNewList() throws Exception {
        NewList newList1 = new NewList("java.lang.String;java.lang.Object");
        String actual = newList1.toString();
        TestNewList.assertEquals((String)actual, (String)"java.lang.Object;java.lang.String");
        newList1.addElement("java.lang.String");
        actual = newList1.toString();
        TestNewList.assertEquals((String)actual, (String)"java.lang.Object;java.lang.String");
        NewList newList2 = new NewList("java.lang.String;java.lang.Object");
        TestNewList.assertTrue((boolean)newList1.equals((Object)newList2));
        newList2.addElement("java.lang.Raw");
        TestNewList.assertFalse((boolean)newList1.equals((Object)newList2));
        TestNewList.assertFalse((boolean)newList1.equals(null));
        newList1.addElement("java.lang.Fail");
        newList1.merge(newList2);
        TestNewList.assertEquals((String)"java.lang.Fail;java.lang.Object;java.lang.Raw;java.lang.String", (String)newList1.toString());
        TestNewList.assertEquals((String)"java.lang.Object;java.lang.Raw;java.lang.String", (String)newList2.toString());
        TestNewList.assertTrue((boolean)newList2.lessThanOrEquals(newList1));
        TestNewList.assertTrue((boolean)new NewList().lessThanOrEquals(newList2));
        TestNewList.assertTrue((boolean)new NewList().lessThanOrEquals(newList1));
        TestNewList.assertFalse((boolean)newList2.lessThanOrEquals(new NewList()));
        TestNewList.assertFalse((boolean)newList1.lessThanOrEquals(new NewList()));
        TestNewList.assertFalse((boolean)newList1.lessThanOrEquals(null));
        newList2.addElement("");
        TestNewList.assertEquals((String)"java.lang.Object;java.lang.Raw;java.lang.String", (String)newList2.toString());
        NewList copy = new NewList(newList2);
        TestNewList.assertEquals((String)"java.lang.Object;java.lang.Raw;java.lang.String", (String)copy.toString());
    }

    public void testMerge() {
        NewList list1 = new NewList("a;c;e");
        NewList list2 = new NewList("b");
        list1.merge(list2);
        TestNewList.assertEquals((String)"a;b;c;e", (String)list1.toString());
        list2 = new NewList("a;c");
        list1.merge(list2);
        TestNewList.assertEquals((String)"a;b;c;e", (String)list1.toString());
    }

    public void testLessThan() {
        NewList list1 = new NewList("a");
        NewList list2 = new NewList("a");
        TestNewList.assertTrue((boolean)list1.lessThanOrEquals(list2));
        list1 = new NewList("a;b");
        list2 = new NewList("a");
        TestNewList.assertTrue((boolean)list2.lessThanOrEquals(list1));
        list1 = new NewList("a;b;d");
        list2 = new NewList("a;d");
        TestNewList.assertTrue((boolean)list2.lessThanOrEquals(list1));
        TestNewList.assertFalse((boolean)list1.lessThanOrEquals(list2));
        list1 = new NewList("a");
        list2 = new NewList("b");
        TestNewList.assertFalse((boolean)list1.lessThanOrEquals(list2));
    }
}

