/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.JavaArrayClass;
import icecaptools.NewList;
import icecaptools.RestartableMethodObserver;
import icecaptools.compiler.DefaultMethodObserver;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.conversion.ConversionConfiguration;
import icecaptools.conversion.Converter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.icecaptools.DefaultCompilationRegistry;

public class TestMiniTests {
    private Converter converter;
    private ConversionConfiguration config;

    @Before
    public void setUp() {
        try {
            this.converter = new Converter(System.out, (RestartableMethodObserver)new DefaultMethodObserver(), (ICompilationRegistry)new DefaultCompilationRegistry(), false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        this.config = new ConversionConfiguration();
        this.config.setClassPath("/home/skr/icecapvm/tools/bin");
        this.config.setInputPackage("test.icecaptools.minitests");
    }

    @Test
    public void testTest1() {
        this.config.setInputClass("Test1");
        NewList newList = this.converter.startConversion(this.config);
        Assert.assertEquals((Object)"java/lang/IllegalMonitorStateException", (Object)newList.toString());
    }

    @Test
    public void testTest2() {
        this.config.setInputClass("Test2");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/Test2");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest3() {
        this.config.setInputClass("Test3");
        NewList newList = this.converter.startConversion(this.config);
        Assert.assertEquals((Object)"", (Object)newList.toString());
    }

    @Test
    public void testTest4() {
        this.config.setInputClass("Test4");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ArrayIndexOutOfBoundsException");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/A");
        expected.addElement("test/icecaptools/minitests/B");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest5() {
        this.config.setInputClass("Test5");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/C");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest6() {
        this.config.setInputClass("Test6");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/C");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest7() {
        this.config.setInputClass("Test7");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/A");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest8() {
        this.config.setInputClass("Test8");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/B");
        expected.addElement("test/icecaptools/minitests/C");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest9() {
        this.config.setInputClass("Test9");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/B");
        expected.addElement("test/icecaptools/minitests/E");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest10() {
        this.config.setInputClass("Test10");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ClassCastException");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/C");
        expected.addElement("test/icecaptools/minitests/Sub1");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest11() {
        this.config.setInputClass("Test11");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/D");
        expected.addElement("test/icecaptools/minitests/Sub2");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest12() {
        this.config.setInputClass("Test12");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ArrayIndexOutOfBoundsException");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/D");
        expected.addElement("test/icecaptools/minitests/F");
        expected.addElement("test/icecaptools/minitests/Sub2");
        expected.addElement("test/icecaptools/minitests/Sub3");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest13() {
        this.config.setInputClass("Test13");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/C");
        expected.addElement("test/icecaptools/minitests/D");
        expected.addElement("test/icecaptools/minitests/Sub4");
        expected.addElement("test/icecaptools/minitests/Sub5");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest14() {
        this.config.setInputClass("Test14");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NegativeArraySizeException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("java/lang/StringBuffer");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest15() {
        this.config.setInputClass("Test15");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Class");
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ArithmeticException");
        expected.addElement("java/lang/ArrayIndexOutOfBoundsException");
        expected.addElement("java/lang/ArrayStoreException");
        expected.addElement("java/lang/AssertionError");
        expected.addElement("java/lang/Character");
        expected.addElement("java/lang/CharacterData00");
        expected.addElement("java/lang/CharacterData01");
        expected.addElement("java/lang/CharacterData02");
        expected.addElement("java/lang/CharacterData0E");
        expected.addElement("java/lang/CharacterDataLatin1");
        expected.addElement("java/lang/CharacterDataPrivateUse");
        expected.addElement("java/lang/CharacterDataUndefined");
        expected.addElement("java/lang/Class");
        expected.addElement("java/lang/ClassCastException");
        expected.addElement("java/lang/IllegalArgumentException");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/Integer");
        expected.addElement("java/lang/NegativeArraySizeException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/NumberFormatException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("java/lang/String");
        expected.addElement("java/lang/String$CaseInsensitiveComparator");
        expected.addElement("java/lang/StringBuffer");
        expected.addElement("java/lang/StringBuilder");
        expected.addElement("java/lang/StringIndexOutOfBoundsException");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest16() {
        Object[] array1 = new Object[2];
        Assert.assertTrue((boolean)JavaArrayClass.isArrayClass((String)array1.getClass().getName()));
        String elementType = JavaArrayClass.getElementType((String)array1.getClass().getName());
        Assert.assertTrue((boolean)JavaArrayClass.isReferenceClass((String)elementType));
        elementType = JavaArrayClass.getReferredType((String)elementType);
        Assert.assertEquals((Object)"java.lang.Object", (Object)elementType);
        Object[][] array2 = new Object[2][2];
        String className = array2.getClass().getName();
        while (JavaArrayClass.isArrayClass((String)className)) {
            className = JavaArrayClass.getElementType((String)className);
        }
        Assert.assertTrue((boolean)JavaArrayClass.isReferenceClass((String)className));
        className = JavaArrayClass.getReferredType((String)className);
        Assert.assertEquals((Object)"java.lang.Object", (Object)className);
        this.config.setInputClass("Test16");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Object");
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NegativeArraySizeException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("test/icecaptools/minitests/D");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest17() {
        this.config.setInputClass("Test17");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("test/icecaptools/minitests/F");
        expected.addElement("test/icecaptools/minitests/C");
        expected.addElement("test/icecaptools/minitests/D");
        Assert.assertTrue((boolean)expected.lessThanOrEquals(newList));
    }

    @Test
    public void testTest18() {
        this.config.setInputClass("Test18");
        NewList newList = this.converter.startConversion(this.config);
        Assert.assertTrue((newList.size() > 0 ? 1 : 0) != 0);
        NewList expected = new NewList();
        expected.addElement("java.lang.Class");
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ArrayIndexOutOfBoundsException");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NegativeArraySizeException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("java/lang/String");
        expected.addElement("test/icecaptools/minitests/B");
        expected.addElement("test/icecaptools/minitests/E");
        expected.addElement("test/icecaptools/minitests/F");
        expected.addElement("test/icecaptools/minitests/Implementor1");
        expected.addElement("test/icecaptools/minitests/Implementor2");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest19() {
        this.config.setInputClass("Test19");
        NewList newList = this.converter.startConversion(this.config);
        Assert.assertTrue((newList.size() > 0 ? 1 : 0) != 0);
        NewList expected = new NewList();
        expected.addElement("java.lang.Class");
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ArrayIndexOutOfBoundsException");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NegativeArraySizeException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("java/lang/String");
        expected.addElement("test/icecaptools/minitests/C");
        expected.addElement("test/icecaptools/minitests/Sub1");
        expected.addElement("test/icecaptools/minitests/Sub2");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest20() {
        this.config.setInputClass("Test20");
        NewList newList = this.converter.startConversion(this.config);
        Assert.assertTrue((newList.size() > 0 ? 1 : 0) != 0);
        NewList expected = new NewList();
        expected.addElement("java.lang.Class");
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ArrayIndexOutOfBoundsException");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NegativeArraySizeException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("java/lang/String");
        expected.addElement("test/icecaptools/minitests/C");
        expected.addElement("test/icecaptools/minitests/Sub1");
        expected.addElement("test/icecaptools/minitests/Sub2");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest21() {
        this.config.setInputClass("Test21");
        NewList newList = this.converter.startConversion(this.config);
        Assert.assertTrue((newList.size() > 0 ? 1 : 0) != 0);
        NewList expected = new NewList();
        expected.addElement("java.lang.Class");
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ArrayIndexOutOfBoundsException");
        expected.addElement("java/lang/Exception");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NegativeArraySizeException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("java/lang/String");
        expected.addElement("test/icecaptools/minitests/C");
        expected.addElement("test/icecaptools/minitests/Sub1");
        expected.addElement("test/icecaptools/minitests/Sub2");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }

    @Test
    public void testTest25() {
        this.config.setInputClass("Test25");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Class");
        expected.addElement("java.lang.Object");
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ArithmeticException");
        expected.addElement("java/lang/ArrayIndexOutOfBoundsException");
        expected.addElement("java/lang/ArrayStoreException");
        expected.addElement("java/lang/Character");
        expected.addElement("java/lang/Class");
        expected.addElement("java/lang/ClassCastException");
        expected.addElement("java/lang/IllegalArgumentException");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/InternalError");
        expected.addElement("java/lang/NegativeArraySizeException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("java/lang/String");
        expected.addElement("java/lang/StringBuilder");
        expected.addElement("java/lang/StringIndexOutOfBoundsException");
        expected.addElement("java/util/LinkedList");
        expected.addElement("java/util/LinkedList$Entry");
        expected.addElement("java/util/NoSuchElementException");
        expected.addElement("java/util/StringTokenizer");
        String[] actual = newList.getElementsAsArray();
        String[] exp = expected.getElementsAsArray();
        Assert.assertEquals((long)actual.length, (long)exp.length);
        int i2 = 0;
        while (i2 < exp.length) {
            if (!actual[i2].equals(exp[i2])) {
                System.out.println("failed: [" + actual[i2] + "]!=[" + exp[i2] + "]");
            }
            ++i2;
        }
    }

    @Test
    public void testTest26() {
        this.config.setInputClass("TestException");
        NewList newList = this.converter.startConversion(this.config);
        NewList expected = new NewList();
        expected.addElement("java.lang.Class");
        expected.addElement("java.lang.Throwable");
        expected.addElement("java/lang/ClassCastException");
        expected.addElement("java/lang/Exception");
        expected.addElement("java/lang/IllegalMonitorStateException");
        expected.addElement("java/lang/NegativeArraySizeException");
        expected.addElement("java/lang/NullPointerException");
        expected.addElement("java/lang/OutOfMemoryError");
        expected.addElement("java/lang/String");
        expected.addElement("test/icecaptools/minitests/Sub1");
        Assert.assertEquals((Object)expected.toString(), (Object)newList.toString());
    }
}

